@extends('admin.layouts.platform')

@section('title', 'Carrossel (Boas vindas)')

@section('subtitle', 'Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Entidade</span></li>
                <li><span>Carrossel (Boas vindas)</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('carrossel.update', encrypt($dado->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Item do Carrossel</h2>
                    </header>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex justify-content-center">
                                <div class="row">
                                    <span>Imagem </span>
                                    <label for="imageUpload" class="cursor-pointer" title="Clique para escolher a imagem">
                                        <div class="position-relative">
                                            <!-- Preview da imagem -->
                                            <img id="imagePreview" 
                                                src="{{ $dado->imagem ? asset('admin/endidadesIMG/bunnerSlide/carrossel/' . $dado->imagem) : asset('admin/img/logo.png') }}" 
                                                class=" border border-3 m-1" 
                                            {{-- class="rounded-circle border border-3 mb-3"  --}}
                                                style="width: 300px; height: 200px; object-fit: fill;" 
                                                alt="imagem">
                                        </div>
                                        <!-- Botão de seleção -->
                                    </label>
                                    <input type="file" id="imageUpload" value="{{ $dado->imagem }}" accept="image/jpeg,image/jpg,image/png" name="imagem" class="form-control d-none" onchange="previewImage(event)">
                                    
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <label for="titulo" class="form-label">Lema</label>
                                        <input type="text" class="form-control" id="nome" maxlength="50" name="lema" value="{{$dado->lema}}" placeholder="Digite o lema">
                                        <small id="counterTitulo" class="form-text text-muted mt-1">0 / 50 caracteres</small> 
                                    </div>     

                                    <div class="col-lg-12">
                                        <label for="estado" class="form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="1" {{ $dado->estado ? 'selected' : '' }}>Activo</option>
                                            <option value="0" {{ !$dado->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>  
                                    
                                </div>
                            </div>
                        </div>
                    </div>

                    <footer class="card-footer text-end">
                        <a href="{{ route('carrossel.index') }}" class="btn btn-dark">Voltar</a>
                        <button class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/bunner.js")}}"></script>
@endsection
