@extends('admin.layouts.platform')

@section('title', 'Entidade Visual')

@section('subtitle', 'Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Editar Entidade Visual</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Entidade</span></li>
                <li><span>Visual</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('entidade-visual.update', encrypt($entidade->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Entidade Visual</h2>
                    </header>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex justify-content-center">
                                <div class="row">
                                    <span>Visual <span style="color: red;">*</span></span>
                                    <label for="imageUpload" class="cursor-pointer" title="Clique para escolher a imagem">
                                        <div class="position-relative">
                                            <!-- Preview da imagem -->
                                            <img id="imagePreview" 
                                                src="{{ $entidade->logo ? asset('admin/endidadesIMG/' . $entidade->logo) : asset('admin/img/logo.png') }}" 
                                                class=" border border-3 m-1" 
                                            {{-- class="rounded-circle border border-3 mb-3"  --}}
                                                style="width: 300px; height: 200px; object-fit: fill;" 
                                                alt="{{$entidade->nome ?? "SISTEMA"}}">
                                        </div>
                                        <!-- Botão de seleção -->
                                    </label>
                                    <input type="file" id="imageUpload" value="{{ $entidade->logo }}" accept="image/jpeg,image/jpg,image/png" name="logo" class="form-control d-none" onchange="previewImage(event)">
                                    
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <span id="nota" style="background-color: #ffeb3b; color: #333; font-weight: bold; padding: 5px 10px; border-left: 4px solid #f44336; display: inline-block; border-radius: 3px; font-size: 1.1em; margin: 10px 0;"></span>
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <label for="titulo" class="form-label">Nome da Entidade <span id="nomeColor" style="color: red;"></span></label>
                                        <input type="text" class="form-control" id="nome" maxlength="100" name="nome" value="{{$entidade->nome}}" placeholder="Digite o nome">
                                        <small id="counterTitulo" class="form-text text-muted mt-1">0 / 100 caracteres</small> 
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="logo" class="form-label">Localização <span style="color: red;">*</span></label>
                                        <select class="form-select" onchange="taggleLocation(this.value)" id="local" name="local" required>
                                            <option value="" disabled {{ old('local', $entidade->localizacao) == null ? 'selected' : '' }}>Selecione...</option>
                                            <option value="1" {{ old('local', $entidade->localizacao) == '1' ? 'selected' : '' }}>Email (Header)</option>
                                            <option value="2" {{ old('local', $entidade->localizacao) == '2' ? 'selected' : '' }}>Email (Rodapé)</option>
                                            {{-- <option value="3" {{ old('local', $entidade->localizacao) == '3' ? 'selected' : '' }}>Portal (Sobre)</option> --}}
                                            <option value="4" {{ old('local', $entidade->localizacao) == '4' ? 'selected' : '' }}>Portal (Header)</option>
                                            <option value="5" {{ old('local', $entidade->localizacao) == '5' ? 'selected' : '' }}>Portal (Rodapé)</option>
                                            {{--  <option value="6" {{ old('local', $entidade->localizacao) == '6' ? 'selected' : '' }}>Portal (Bunner)</option> --}}
                                            <option value="7" {{ old('local', $entidade->localizacao) == '7' ? 'selected' : '' }}>Portal (Marca de água)</option>
                                            <option value="8" {{ old('local', $entidade->localizacao) == '8' ? 'selected' : '' }}>Portal (Boas vindas - header)</option>
                                            <option value="9" {{ old('local', $entidade->localizacao) == '9' ? 'selected' : '' }}>Portal (Boas vindas - rodapé)</option>
                                            <option value="10" {{ old('local', $entidade->localizacao) == '10' ? 'selected' : '' }}>Sistema (Background)</option>
                                            <option value="11" {{ old('local', $entidade->localizacao) == '11' ? 'selected' : '' }}>Area Reservada (Dashboard)</option>
                                            <option value="12" {{ old('local', $entidade->localizacao) == '12' ? 'selected' : '' }}>Area Reservada (Fluxo de autenticação)</option>                                            
                                            <option value="13" {{ old('local', $entidade->localizacao) == '13' ? 'selected' : '' }}>Todos</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="form-label">Estado<span style="color: red;"> *</span></label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="1" {{ $entidade->estado ? 'selected' : '' }}>Activo</option>
                                            <option value="0" {{ !$entidade->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>  
                                    
                                    <p>Apenas os campos marcados com <span style="color: red;">*</span> são
                                        obrigatórios.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <footer class="card-footer text-end">
                        <a href="{{ route('entidade-visual.index') }}" class="btn btn-dark">Voltar</a>
                        <button class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/entidadeVisual.js")}}"></script>
@endsection
