@extends('admin.layouts.platform')

@section('title', 'Painel de Configurações')

@section('subtitle','Configurações')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Painel de Configurações</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>

        @if (session('success'))
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: "{{ session('success') }}",
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif
        
        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                        </div>
                        <h2 class="card-title">Painel de Configurações</h2>
                    </header>
                    
                </section>
            </div>
        </div>

        <div class="col-lg-12 col-xl-12" style="padding-top: 10px;">
            <div class="tabs">
                <ul class="nav nav-tabs tabs-primary">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#orgaos" role="tab"
                                    aria-selected="false">Órgãos</a>
                        {{-- <button class="nav-link" data-bs-target="#orgaos" data-bs-toggle="tab"></button> --}}
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#profissoes" role="tab"
                            aria-selected="false">
                            </i>Profissões
                        </a>
                        {{-- <button class="nav-link" data-bs-target="#profissoes" data-bs-toggle="tab">Reset Palavra-Passe</button> --}}
                    </li>
                </ul>
                
                <div class="tab-content">
                    <div id="orgaos" class="tab-pane active" role="tabpanel">
                        <div class="row">
                            <div class="col">
                                <section class="card">
                                    <header class="card-header">
                                        <div class="card-actions">
                                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a> --}}
                                        </div>
                                        <h2 class="card-title">Listagem dos Órgãos</h2>
                                    </header>
                                    <div class="card-body">
                                        <table class="table table-bordered table-striped mb-0 datatable-tabletools" id="">
                                            <thead>
                                                <a id="addToTable" href="{{route('painel.update.orgaos')}}" class="btn btn-secondary mb-4"><i class="fa fa-refresh"></i> Actualizar Órgãos</a>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Nome</th>
                                                    <th>Descrição</th>
                                                    <th>Aplica-se?</th>
                                                    <th>Data Actualização</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($orgaos as $orgao)
                                                    <tr>
                                                        <td> {{ $loop->index + 1 }}</td>
                                                        <td>{{ $orgao->nome ?? '' }}</td>
                                                        <td>{{ $orgao->descricao ?? '' }}</td>
                                                        @if ($orgao->seAplica)
                                                            <td><span class="badge badge-success">Sim</span></td>
                                                        @else
                                                            <td><span class="badge badge-danger">Não</span></td>
                                                        @endif
                                                        <td>{{ $orgao->updated_at ?? '' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </section>
                            </div>
                        </div>                        
                    </div>
                    
                    <div id="profissoes" class="tab-pane" role="tabpanel">
                        <div class="row">
                            <div class="col">
                                <section class="card">
                                    <header class="card-header">
                                        <div class="card-actions">
                                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a> --}}
                                        </div>
                                        <h2 class="card-title">Listagem das Profissões</h2>
                                    </header>
                                    <div class="card-body">
                                        <table class="table table-bordered table-striped mb-0 datatable-tabletools" id="">
                                            <a id="addToTable" href="{{route('painel.update.profissoes')}}" class="btn btn-secondary mb-4"><i class="fa fa-refresh"></i> Actualizar Profissões</a>
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Nome</th>
                                                    <th>Descrição</th>
                                                    {{-- <th>Isenção?</th> --}}
                                                    <th>Data Actualização</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($profissoes as $profissao)
                                                    <tr>
                                                        <td> {{ $loop->index + 1 }}</td>
                                                        <td>{{ $profissao->nome ?? '' }}</td>
                                                        <td>{{ $profissao->descricao ?? '' }}</td>
                                                        {{-- @if ($profissao->isencao)
                                                            <td><span class="badge badge-success">Sim</span></td>
                                                        @else
                                                            <td><span class="badge badge-danger">Não</span></td>
                                                        @endif --}}
                                                        <td>{{ $profissao->updated_at ?? '' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end: page -->
    </section>
@endsection

@section('javascript')
@endsection