@extends('admin.layouts.platform')

@section('title', 'Evento')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Evento</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('eventos.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Evento</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>

                        <div class="card-body">
                            <div class="row">
                                <!-- Coluna da Imagem Principal -->
                                <div class="col-lg-4 text-center d-flex justify-content-center">
                                    <div>
                                        <span class="mt-2">Imagem do Evento</span>
                                        <div class="position-relative">
                                            <img id="imagePreviews" src="{{ asset('admin/imagens/users/default.png')}}" 
                                                class="border border-3 m-1" 
                                                style="width: 230px; height: 300px; object-fit: cover;" 
                                                alt="Preview">
                                        </div>
                                        <label for="imageUpload" class="btn btn-dark mt-2">Selecionar Imagem</label>
                                        <input type="file" id="imageUpload" accept="image/*" name="imagem" 
                                            class="form-control d-none" onchange="previewImage(event)" required>
                                    </div>
                                </div>

                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-8">
                                    <div class="row">
                                        <div class="col-lg-12 mb-3">
                                            <label for="titulo" class="form-label">Título</label>
                                            <input type="text" class="form-control" id="titulo" maxlength="200" name="titulo" placeholder="Digite o título do evento" required>
                                            {{-- <small id="counterTitulo" class="form-text text-muted mt-1">0 / 220 caracteres</small> --}}
                                        </div>

                                        <div class="col-lg-6 mb-3">
                                            <label for="data_evento" class="form-label">Data do Evento</label>
                                            <input type="date" class="form-control" id="data_evento" name="data_evento" required>
                                        </div>

                                        <div class="col-lg-6 mb-3">
                                            <label for="estado" class="form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>

                                        {{-- <div class="col-lg-6 mb-3">
                                            <label for="midias" class="form-label">Galeria de Imagens/Vídeos</label>
                                            <input type="file" name="midias[]" id="midias" class="form-control" accept="image/*,video/*" multiple>
                                            <small class="form-text text-muted">Você pode selecionar várias imagens e vídeos</small>
                                        </div> --}}

                                        <div class="col-lg-12 mb-3">
                                            <label for="resumo" class="form-label">Resumo</label>
                                            <textarea class="form-control" id="resumo" name="resumo" rows="4" maxlength="300" placeholder="Digite o resumo do evento" required></textarea>
                                            {{-- <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small> --}}
                                        </div>
                                    </div>
                                </div>

                                <!-- Campo de Detalhes -->
                                <div class="col-lg-12 mt-3">
                                    <label for="detalhes" class="form-label">Detalhes do Evento</label>
                                    <textarea class="form-control" id="detalhes" name="detalhes" rows="6" placeholder="Descreva os detalhes do evento aqui..."></textarea>
                                </div>
                            </div>
                        </div>

                        <footer class="card-footer text-end">
                            <a href="{{ route('eventos.index') }}" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>

    {{-- <script src="{{ asset("admin/js/Validacao/noticia.js")}}"></script> --}}
    <script src="{{ asset('tinymceEditor/js/tinymce/tinymce.min.js') }}"></script>
    <script>
        function previewImage(event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('imagePreviews').src = e.target.result;
                };
                reader.readAsDataURL(file);
            }
        }

        tinymce.init({
            selector: 'textarea#detalhes',
            height: 400,
            menubar: false,
            license_key: 'gpl',
            plugins: 'advlist autolink lists link charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime table wordcount',
            toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | preview',
            branding: false,

            content_style: `
                body {
                    font-family: Arial, sans-serif;
                    font-size: 16px;
                    line-height: 1.4;
                    color: #333;
                }

                p {
                    margin: 0 0 7px 0;
                }

                ul, ol {
                    color: #333;
                    margin: 0 0 10px 20px;
                }

                li {
                    color: black;
                    margin-bottom: 5px;
                }
            `
            
        });
    </script>
@endsection

