@extends('admin.layouts.platform')

@section('title', 'Evento')

@section('subtitle', 'Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Detalhes do Evento</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Evento</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Visualização do Evento</h2>
                </header>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center d-flex justify-content-center">
                            <img src="{{ $evento->imagem ? asset('admin/eventos/' . $evento->imagem) : asset('admin/imagens/users/default.png') }}"
                                class="border border-3 mb-1"
                                style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;" 
                                alt="Imagem">
                        </div>
                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-lg-12 mb-3">
                                    <label for="titulo" class="form-label">Título</label>
                                    <input type="text" class="form-control" id="titulo" maxlength="200" name="titulo" value="{{ $evento->titulo ?? ""}}" readonly>
                                    {{-- <small id="counterTitulo" class="form-text text-muted mt-1">0 / 145 caracteres</small> --}}
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label"><strong> Data do Evento:</strong></label>
                                    <p class="form-control-plaintext">{{ $evento->data_evento ?? ""}}</p>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label"><strong>Estado:</strong></label>
                                    <p class="form-control-plaintext">{{ $evento->estado ? 'Activo' : 'Inativo' }}</p>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <label for="resumo" class="form-label">Resumo</label>
                                    <textarea class="form-control" id="resumo" name="resumo" rows="4" maxlength="315" readonly>{{ $evento->resumo ?? '' }}</textarea>
                                    {{-- <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small> --}}
                                </div>
                                
                            </div>
                        </div>

                        <div class="col-lg-12 mb-3">
                            <label class="form-label"><strong>Detalhes do Evento</strong></label>
                            <textarea class="form-control" id="detalhes" name="detalhes" rows="5" placeholder="Digite a mensagem" readonly>{{ $evento->detalhe_evento ?? ''}}</textarea>
                            {{-- <p class="form-control-plaintext" align="justify">{{ $noticia->corpo_noticia ?? ""}}</p> --}}
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('eventos.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('eventos.edit', encrypt($evento->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>

        </div>

    </div>
</section>

<script src="{{ asset('tinymceEditor/js/tinymce/tinymce.min.js') }}"></script>
<script>
    tinymce.init({
        selector: 'textarea#detalhes',
        height: 400,
        menubar: false,
        license_key: 'gpl',
        plugins: 'advlist autolink lists link charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime table wordcount',
        toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | preview',
        branding: false,

        content_style: `
            body {
                font-family: Arial, sans-serif;
                font-size: 16px;
                line-height: 1.4;
                color: #333;
            }

            p {
                margin: 0 0 7px 0;
            }

            ul, ol {
                color: #333;
                margin: 0 0 10px 20px;
            }

            li {
                color: black;
                margin-bottom: 5px;
            }
        `
        
    });
</script>
@endsection
