<!doctype html>
<html class="fixed">

<head>

		<!-- Basic -->
		<meta charset="UTF-8">

		<title>{{ $config->portal_nome ?? 'N2BS - Template'}} | @yield('title')</title>

		<meta name="keywords" content="{{ $config->meta_dados["keywords"] ?? 'N2BS - Template'}}" />
		<meta name="description" content="{{ $config->meta_dados["description"] ?? 'N2BS - Template'}}">
		<meta name="author" content="{{ $config->meta_dados["author"] ?? 'N2BS - Template'}}">

		<!-- Favicon -->
		<link rel="shortcut icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}" type="image/x-icon" />
    	<link rel="apple-touch-icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}">


		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		{{-- <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script> --}}
		<!-- Web Fonts  -->
		<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap/css/bootstrap.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/animate/animate.compat.css')}} ">
		<link rel="stylesheet" href="{{ asset('admin/vendor/font-awesome/css/all.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/boxicons/css/boxicons.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/magnific-popup/magnific-popup.css')}} " />
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap-datepicker/css/bootstrap-datepicker3.css')}} " />

		<!-- Specific Page Vendor CSS -->
		<link rel="stylesheet" href="{{ asset('admin/vendor/jquery-ui/jquery-ui.css')}} " />
		<link rel="stylesheet" href="{{ asset('admin/vendor/jquery-ui/jquery-ui.theme.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/bootstrap-multiselect/css/bootstrap-multiselect.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/morris/morris.css')}} " />

		<link rel="stylesheet" href="{{ asset('admin/vendor/select2/css/select2.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/select2-bootstrap-theme/select2-bootstrap.min.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/datatables/media/css/dataTables.bootstrap5.css')}}" />

		<!-- Theme CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/theme.css')}} " />

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/custom.css')}} ">

		<!-- Head Libs -->
		<script src="{{ asset('admin/vendor/modernizr/modernizr.js')}} "></script>

		<script src="{{ asset('admin/master/style-switcher/style.switcher.localstorage.js')}} "></script>

	</head>
	<body>
		<section class="body">

			<!-- start: header -->
			<header class="header">
				<div class="logo-container">
					<a href="#" class="logo" style="padding-button: 10px">
						{{-- <img src="{{ asset('StyleCreateAccount/images/logo_AssociaT.png')}} " width="160" height="50" alt="AssociaT" /> --}}
						<img src="{{ isset($entidadeVisual) && $entidadeVisual->logo ? asset('admin/endidadesIMG/'. $entidadeVisual->logo) : asset('admin/imgDefault.png')  }}" width="160" height="50" alt="{{ $entidadeVisual->nome ?? 'SISTEMA' }}" >
                        {{-- <img src="{{asset('StyleCreateAccount/images/logo_AssociaT.png')}}" width="47%" alt="FSTPL" > --}}
					</a>

					<div class="d-md-none toggle-sidebar-left" data-toggle-class="sidebar-left-opened" data-target="html" data-fire-event="sidebar-left-opened">
						<i class="fas fa-bars" aria-label="Toggle sidebar"></i>
					</div>

				</div>

				<!-- start: search & user box -->
				<div class="header-right">

					{{-- <form action="#" class="search nav-form">
						<div class="input-group">
							<input type="text" class="form-control" name="q" id="q" placeholder="Search...">
							<button class="btn btn-default" type="submit"><i class="bx bx-search"></i></button>
						</div>
					</form> --}}

					<span class="separator"></span>

					{{-- <ul class="notifications">
						<li>
							<a href="#" class="dropdown-toggle notification-icon" data-bs-toggle="dropdown">
								<i class="bx bx-list-ol"></i>
								<span class="badge">3</span>
							</a>

							<div class="dropdown-menu notification-menu large">
								<div class="notification-title">
									<span class="float-end badge badge-default">3</span>
									Tasks
								</div>

								<div class="content">
									<ul>
										<li>
											<p class="clearfix mb-1">
												<span class="message float-start">Generating Sales Report</span>
												<span class="message float-end text-dark">60%</span>
											</p>
											<div class="progress progress-xs light">
												<div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;"></div>
											</div>
										</li>

										<li>
											<p class="clearfix mb-1">
												<span class="message float-start">Importing Contacts</span>
												<span class="message float-end text-dark">98%</span>
											</p>
											<div class="progress progress-xs light">
												<div class="progress-bar" role="progressbar" aria-valuenow="98" aria-valuemin="0" aria-valuemax="100" style="width: 98%;"></div>
											</div>
										</li>

										<li>
											<p class="clearfix mb-1">
												<span class="message float-start">Uploading something big</span>
												<span class="message float-end text-dark">33%</span>
											</p>
											<div class="progress progress-xs light mb-1">
												<div class="progress-bar" role="progressbar" aria-valuenow="33" aria-valuemin="0" aria-valuemax="100" style="width: 33%;"></div>
											</div>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li>
							<a href="#" class="dropdown-toggle notification-icon" data-bs-toggle="dropdown">
								<i class="bx bx-envelope"></i>
								<span class="badge">4</span>
							</a>

							<div class="dropdown-menu notification-menu">
								<div class="notification-title">
									<span class="float-end badge badge-default">230</span>
									Messages
								</div>

								<div class="content">
									<ul>
										<li>
											<a href="#" class="clearfix">
												<figure class="image">
													<img src="img/%21sample-user.jpg" alt="Joseph Doe Junior" class="rounded-circle" />
												</figure>
												<span class="title">Joseph Doe</span>
												<span class="message">Lorem ipsum dolor sit.</span>
											</a>
										</li>
										<li>
											<a href="#" class="clearfix">
												<figure class="image">
													<img src="img/%21sample-user.jpg" alt="Joseph Junior" class="rounded-circle" />
												</figure>
												<span class="title">Joseph Junior</span>
												<span class="message truncate">Truncated message. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet lacinia orci. Proin vestibulum eget risus non luctus. Nunc cursus lacinia lacinia. Nulla molestie malesuada est ac tincidunt. Quisque eget convallis diam, nec venenatis risus. Vestibulum blandit faucibus est et malesuada. Sed interdum cursus dui nec venenatis. Pellentesque non nisi lobortis, rutrum eros ut, convallis nisi. Sed tellus turpis, dignissim sit amet tristique quis, pretium id est. Sed aliquam diam diam, sit amet faucibus tellus ultricies eu. Aliquam lacinia nibh a metus bibendum, eu commodo eros commodo. Sed commodo molestie elit, a molestie lacus porttitor id. Donec facilisis varius sapien, ac fringilla velit porttitor et. Nam tincidunt gravida dui, sed pharetra odio pharetra nec. Duis consectetur venenatis pharetra. Vestibulum egestas nisi quis elementum elementum.</span>
											</a>
										</li>
										<li>
											<a href="#" class="clearfix">
												<figure class="image">
													<img src="img/%21sample-user.jpg" alt="Joe Junior" class="rounded-circle" />
												</figure>
												<span class="title">Joe Junior</span>
												<span class="message">Lorem ipsum dolor sit.</span>
											</a>
										</li>
										<li>
											<a href="#" class="clearfix">
												<figure class="image">
													<img src="img/%21sample-user.jpg" alt="Joseph Junior" class="rounded-circle" />
												</figure>
												<span class="title">Joseph Junior</span>
												<span class="message">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet lacinia orci. Proin vestibulum eget risus non luctus. Nunc cursus lacinia lacinia. Nulla molestie malesuada est ac tincidunt. Quisque eget convallis diam.</span>
											</a>
										</li>
									</ul>

									<hr />

									<div class="text-end">
										<a href="#" class="view-more">View All</a>
									</div>
								</div>
							</div>
						</li>
						<li>
							<a href="#" class="dropdown-toggle notification-icon" data-bs-toggle="dropdown">
								<i class="bx bx-bell"></i>
								<span class="badge">3</span>
							</a>

							<div class="dropdown-menu notification-menu">
								<div class="notification-title">
									<span class="float-end badge badge-default">3</span>
									Alerts
								</div>

								<div class="content">
									<ul>
										<li>
											<a href="#" class="clearfix">
												<div class="image">
													<i class="fas fa-thumbs-down bg-danger text-light"></i>
												</div>
												<span class="title">Server is Down!</span>
												<span class="message">Just now</span>
											</a>
										</li>
										<li>
											<a href="#" class="clearfix">
												<div class="image">
													<i class="bx bx-lock bg-warning text-light"></i>
												</div>
												<span class="title">User Locked</span>
												<span class="message">15 minutes ago</span>
											</a>
										</li>
										<li>
											<a href="#" class="clearfix">
												<div class="image">
													<i class="fas fa-signal bg-success text-light"></i>
												</div>
												<span class="title">Connection Restaured</span>
												<span class="message">10/10/2023</span>
											</a>
										</li>
									</ul>

									<hr />

									<div class="text-end">
										<a href="#" class="view-more">View All</a>
									</div>
								</div>
							</div>
						</li>
					</ul> --}}

					{{-- <span class="separator"></span> --}}

					<div id="userbox" class="userbox">
						<a href="#" data-bs-toggle="dropdown">
							<figure class="profile-picture">
								<img src="{{ Auth::user()->foto ? asset('admin/imagens/users/'. Auth::user()->foto) : asset('admin/imagens/users/default.png')  }} " alt="{{ Auth::user()->name_completo }}" class="rounded-circle" style="width: 30px; height: 30px; object-fit: cover;" />
							</figure>
							<div class="profile-info" data-lock-name="{{ Auth::user()->name_completo }}" data-lock-email="{{ Auth::user()->email }}">
								<span class="name">{{ Auth::user()->name_completo }}</span>
								<span class="role">{{ Auth::user()->role->name }}</span>
							</div>

							<i class="fa custom-caret"></i>
						</a>

						<div class="dropdown-menu">
							<ul class="list-unstyled mb-2">
								<li class="divider"></li>
								<li>
									<a role="menuitem" tabindex="-1" href="{{ route('admin.user.perfil', encrypt(Auth::user()->id)) }}"><i class="bx bx-user-circle"></i>Meu Perfil</a>
								</li>
								{{-- <li>
									<a role="menuitem" tabindex="-1" href="#" data-lock-screen="true"><i class="bx bx-lock"></i> Lock Screen</a>
								</li> --}}
								<li>
									<a role="menuitem" tabindex="-1"   href="{{ route('auth.logout') }}"><i class="bx bx-power-off"></i> Terminar Secção</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
				<!-- end: search & user box -->
			</header>
			<!-- end: header -->

			<div class="">
				<!-- start: sidebar -->
				<aside id="sidebar-left" class="sidebar-left">
				    <div class="sidebar-header">
				        <div class="sidebar-title">
				            Menu Principal
				        </div>
				        <div class="sidebar-toggle d-none d-md-block" data-toggle-class="sidebar-left-collapsed" data-target="html" data-fire-event="sidebar-left-toggle">
				            <i class="fas fa-bars" aria-label="Toggle sidebar"></i>
				        </div>
				    </div>
						@if (Auth()->user()->role_id == 1)
							@include('admin.menu.admin')
						@elseif (Auth()->user()->role_id == 2)
							@include('admin.menu.gestor')
						@elseif (Auth()->user()->role_id == 3)
							@include('admin.menu.editor')
						@endif
					</div>
				</aside>
				<!-- end: sidebar -->

				@yield('conteudo')

			</div>

			

			<aside id="sidebar-right" class="sidebar-right">
				<div class="nano">
					<div class="nano-content">
						<a href="#" class="mobile-close d-md-none">
							Collapse <i class="fas fa-chevron-right"></i>
						</a>

						<div class="sidebar-right-wrapper">

							<div class="sidebar-widget widget-calendar">
								<h6>Calendário</h6>
								<div data-plugin-datepicker data-plugin-skin="dark"></div>

								{{-- <ul>
									<li>
										<time datetime="2023-04-19T00:00+00:00">04/19/2023</time>
									</li>
								</ul> --}}
							</div>



						</div>
					</div>
				</div>
			</aside>

		</section>

		<!-- Vendor -->
		<script src="{{ asset('admin/vendor/jquery/jquery.js')}} "></script>
		<script src="{{ asset('admin/vendor/jquery-browser-mobile/jquery.browser.mobile.js')}} "></script>
		<script src="{{ asset('admin/vendor/jquery-cookie/jquery.cookie.js')}} "></script>
		<script src="{{ asset('admin/vendor/popper/umd/popper.min.js')}} "></script>
		<script src="{{ asset('admin/vendor/bootstrap/js/bootstrap.bundle.min.js')}} "></script>
		<script src="{{ asset('admin/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js')}} "></script>
		<script src="{{ asset('admin/vendor/common/common.js')}} "></script>
		<script src="{{ asset('admin/vendor/nanoscroller/nanoscroller.js')}} "></script>
		<script src="{{ asset('admin/vendor/magnific-popup/jquery.magnific-popup.js')}} "></script>
		<script src="{{ asset('admin/vendor/jquery-placeholder/jquery.placeholder.js')}} "></script>

		<!-- Specific Page Vendor -->
		<script src="{{ asset('admin/vendor/jquery-ui/jquery-ui.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqueryui-touch-punch/jquery.ui.touch-punch.js')}}  "></script>
		<script src="{{ asset('admin/vendor/jquery-appear/jquery.appear.js')}} "></script>
		<script src="{{ asset('admin/vendor/bootstrap-multiselect/js/bootstrap-multiselect.js')}} "></script>
		<script src="{{ asset('admin/vendor/jquery.easy-pie-chart/jquery.easypiechart.js')}} "></script>
		<script src="{{ asset('admin/vendor/flot/jquery.flot.js')}}  "></script>
		<script src="{{ asset('admin/vendor/flot.tooltip/jquery.flot.tooltip.js')}}  "></script>
		<script src="{{ asset('admin/vendor/flot/jquery.flot.pie.js')}} "></script>
		<script src="{{ asset('admin/vendor/flot/jquery.flot.categories.js')}} "></script>
		<script src="{{ asset('admin/vendor/flot/jquery.flot.resize.js')}} "></script>
		<script src="{{ asset('admin/vendor/jquery-sparkline/jquery.sparkline.js')}} "></script>


		<script src="{{ asset('admin/vendor/raphael/raphael.js')}} "></script>
		<script src="{{ asset('admin/vendor/morris/morris.js')}} "></script>
		<script src="{{ asset('admin/vendor/gauge/gauge.js')}} "></script>
		<script src="{{ asset('admin/vendor/liquid-meter/liquid.meter.js')}} "></script>
		<script src="{{ asset('admin/vendor/snap.svg/snap.svg.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/jquery.vmap.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/data/jquery.vmap.sampledata.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/jquery.vmap.world.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.africa.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.asia.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.australia.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.australia.jsvendor/jquery-sparkline/jquery.sparkline.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.europe.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.north-america.js')}} "></script>
		<script src="{{ asset('admin/vendor/jqvmap/maps/continents/jquery.vmap.south-america.js')}}"></script>

		<!-- Specific Page Vendor -->
		<script src="{{ asset('admin/vendor/select2/js/select2.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/media/js/jquery.dataTables.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/media/js/dataTables.bootstrap5.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/dataTables.buttons.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.bootstrap4.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.html5.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.print.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/JSZip-2.5.0/jszip.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/pdfmake-0.1.32/pdfmake.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/datatables/extras/TableTools/pdfmake-0.1.32/vfs_fonts.js')}}"></script>

		
		<script src="{{ asset('admin/js/examples/examples.datatables.default.js')}}"></script>
		<script src="{{ asset('admin/js/examples/examples.datatables.row.with.details.js')}}"></script>
		<script src="{{ asset('admin/js/examples/examples.datatables.tabletools.js')}}"></script>
		<script src="{{ asset('admin/js/examples/examples.modals.js')}}"></script>
		<script src="{{ asset('admin/js/examples/examples.dashboard.js')}} "></script>
		<script src="{{ asset('admin/js/examples/examples.validation.js')}}"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="{{ asset('admin/js/theme.js')}} "></script>

        <script src="{{ asset('admin/js/js/custom.js')}} "></script>
        <script src="{{ asset('admin/js/theme.init.js')}} "></script>

		<!-- Analytics to Track Preview Website -->
		<script>
		  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		  })(window,document,'script','../../../../www.google-analytics.com/analytics.js','ga');

		  ga('create', 'UA-42715764-8', 'auto');
		  ga('send', 'pageview');
		</script>

		<script src="{{ asset('admin/js/fullcalendar/fullcalendar.min.js') }}"></script>
		<script>
			document.addEventListener('DOMContentLoaded', function() {
			var calendarEl = document.getElementById('calendar');
			var calendar = new FullCalendar.Calendar(calendarEl, {
				initialView: 'dayGridMonth'
			});
			calendar.render();
			});
		</script>
		<!-- Examples -->
	</body>

</html>
