@extends('admin.layouts.platform')

@section('title', 'Membros da Comissão')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Estrutura Orgânica</span></li>
                <li><span>Membros da Comissão</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes do Membro da Comissão</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center">
                            <div>
                                <h5 class="mb-3">Foto do Membro</h5>
                                <img src="{{ $membro->foto ? asset('admin/imagens/membrosComissao/'.$membro->foto) : asset('admin/imagens/users/default.png') }}" 
                                     class="border border-3 mb-3"
                                     style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;"  
                                     alt="Foto do Membro">
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-lg-8 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nomeCompleto">Nome Completo</label>
                                        <input type="text" class="form-control" id="nome" value="{{ $membro->nome ?? '' }}" name="nome" placeholder="Digite o nome" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-4 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="telefone" name="telefone" value="{{ $membro->estado ? 'Activo' : 'Inativo'}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="cargo">Cargo</label>
                                        <input type="text" class="form-control" id="cargo" name="cargo" value="{{ $membro->cargos->nome ?? ''}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <label for="biografia" class="form-label">Biografia</label>
                                    <textarea class="form-control" id="biografia" name="biografia" rows="8" placeholder="Digite a Biografia" readonly>{{ $membro->biografia ?? '' }}</textarea>
                                    {{-- <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('membros-comissao.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('membros-comissao.edit', encrypt($membro->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
