@extends('admin.layouts.platform')

@section('title', 'Missão e Visão')

@section('subtitle','Editar')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Missão e Visão</span></li>
                    <li><span>Editar</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('missao-visao.update', encrypt($meta->id))}}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Valores</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>
                        <div class="card-body">
                            <div class="row">           
                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-6 mb-3">
                                            <label for="estado" class="col-form-label">Categoria</label>
                                            <select class="form-select" id="categoria" name="categoria" required>
                                                <option value="" disabled selected>Selecione um</option>
                                                <option value="1" {{ $meta->categoria ? 'selected' : '' }}>Missão</option>
                                                <option value="0" {{ !$meta->categoria ? 'selected' : '' }}>Visão</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="estado" class="col-form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="1" {{ $meta->estado ? 'selected' : '' }}>Activo</option>
                                                <option value="0" {{ !$meta->estado ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-12 mb-3">
                                            <label for="biografia" class="form-label">Descrição</label>
                                            <textarea class="form-control" id="descricao" name="descricao" rows="6" placeholder="Digite a Descrição" maxlength="300" required>{{ $meta->descricao ?? '' }}</textarea>
                                            <small id="counterDescricao" class="form-text text-muted mt-1">0 / 300 caracteres</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('missao-visao.index') }}" class="btn btn-dark">Voltar</a>
                            <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>
        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/missaoVisao.js")}}"></script>
@endsection

    
