@extends('admin.layouts.platform')

@section('title', 'Parceiros')

@section('subtitle','Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Parceiros</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('parceiro.update', encrypt($parceiro->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Parceiro</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                                <div>
                                    <h5 class="mb-3">Atualizar Foto</h5>
                                    <div class="position-relative">
                                        <img id="imagePreview" src="{{ $parceiro->imagem ? asset('admin/imagens/parceiros/'.$parceiro->imagem) : asset('admin/imagens/users/default.png') }}"
                                            class="border border-3 mb-3"
                                            style="width: 150px; height: 150px; object-fit: cover;"
                                            alt="Preview">
                                    </div>
                                    <label for="imageUpload" class="btn btn-primary">Selecionar Imagem</label>
                                    <input type="file" id="imageUpload" accept="image/*" name="foto"
                                           class="form-control d-none" onchange="previewImage(event)">
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <input type="hidden" class="form-control" name="id" value="{{ encrypt($parceiro->id) }}">
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="nomeCompleto">Nome do Parceiro</label>
                                            <input type="text" class="form-control" id="nome" name="nome" value="{{ $parceiro->nome }}" placeholder="Digite o nome do parceiro" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="username">Endereço</label>
                                            <input type="text" class="form-control" id="endereco" name="endereco" value="{{ $parceiro->endereco }}" placeholder="Digite o endereço" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="telefone">Telefone</label>
                                            <input type="text" class="form-control" id="telefone" name="telefone" value="{{ $parceiro->telefone }}" placeholder="Digite o número de telefone" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="col-form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="" disabled selected>Selecione o estado</option>
                                            <option value="1" {{ $parceiro->estado ? 'selected' : '' }}>Activo</option>
                                            <option value="0" {{ !$parceiro->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="site">Site</label>
                                            <input type="text" class="form-control" id="site" name="site" value="{{ $parceiro->site }}" placeholder="Digite o site">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label class="col-form-label" for="perfil">Categoria</label>
                                            <select id="categoria" name="categoria" class="form-control" title="Por favor, selecione a categoria" required>
                                                <option selected disabled value="">Selecione uma categoria</option>
                                                @foreach ($categoriasParceiros as $categoria)
                                                    <option value="{{ $categoria->id }}" {{ $parceiro->categoria_id == $categoria->id ? 'selected' : '' }}>{{ $categoria->nome }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('parceiro.index') }}" class="btn btn-dark">Voltar</a>
                        <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/parceiro.js")}}"></script>
@endsection
