@extends('admin.layouts.platform')

@section('title', 'Perguntas Frequentes')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Perguntas Frequentes</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes das Perguntas Frequentes</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nomeCompleto">Pergunta</label>
                                        <input type="text" class="form-control" id="pergunta" name="pergunta" value="{{ $faq->pergunta ?? '' }}?" placeholder="Digite o nome" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="username">Estado</label>
                                        <input type="text" class="form-control" id="estado" name="estado" value="{{ $faq->estado ? 'Activo' : 'Inativo' }}" placeholder="Digite o nome de utilizador" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 mb-3">
                        <label for="resumo" class="form-label">Resposta</label>
                        <textarea class="form-control" id="resposta" name="resposta" rows="4" placeholder="Digite a resposta" maxlength="200" readonly>{{ $faq->resposta ?? '' }}</textarea>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('perguntas-frequentes.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('perguntas-frequentes.edit', encrypt($faq->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
