@extends('admin.layouts.platform')

@section('title', 'Perfil')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Utilizadores</span></li>
                    <li><span>Perfil</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('perfis.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Perfil</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="nomeCompleto">Nome</label>
                                                <input type="text" class="form-control" id="nome" name="nome" placeholder="Digite o nome" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="col-form-label" for="username">Descrição</label>
                                                <input type="text" class="form-control" id="descricao" name="descricao" placeholder="Digite a descrição">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('perfis.index') }}" class="btn btn-dark">Voltar</a>
                            <button type="submit" class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/role.js")}}"></script>
@endsection

    