@extends('admin.layouts.platform')

@section('title', 'Utilizadores')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Utilizadores</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('utilizadors.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Utilizador</h2>
                            <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p>
                        </header>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                                    <div>
                                        <h5 class="mb-3">Carregar Foto</h5>
                                        <div class="position-relative">
                                            <!-- Preview da imagem -->
                                            <img id="imagePreview" src="{{ asset('admin/imagens/users/default.png')}}" 
                                                class=" border border-3 mb-3" 
                                            {{-- class="rounded-circle border border-3 mb-3"  --}}
                                                style="width: 150px; height: 150px; object-fit: cover;" 
                                                alt="Preview">
                                        </div>
                                        <!-- Botão de seleção -->
                                        <label for="imageUpload" class="btn btn-primary ">Selecionar Imagem</label>
                                        <input type="file" id="imageUpload" accept="image/*"  name="foto" required
                                            class="form-control d-none" onchange="previewImage(event)">
                                    </div>
                                </div>
            
                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-8">
                                    <div class="row">
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="nomeCompleto">Nome Completo</label>
                                                <input type="text" class="form-control" id="nomeCompleto" name="nome" placeholder="Digite o nome" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="username">Nome de Utilizador</label>
                                                <input type="text" class="form-control" id="username" name="username" placeholder="Digite o nome de utilizador" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="email">E-mail</label>
                                                <input type="email" class="form-control" id="email" name="email" placeholder="Digite o email" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="telefone">Telefone</label>
                                                <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Digite o número de telefone" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="estado" class="form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label for="perfil" class="form-label">Perfil</label>
                                                <select id="perfil" name="perfil" class="form-control" title="Por favor, selecione um perfil" required>
                                                    <option selected disabled value="">Selecione um Perfil</option>
                                                    @foreach ($roles as $role)
                                                        @if (!(Gate::allows('isGestor') && ($role->id == 1 || $role->id == 4)))
                                                            <option value="{{ $role->id }}"> {{ $role->name }}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('utilizadors.index') }}" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/user.js")}}"></script>
@endsection

    
