@extends('admin.layouts.platform')

@section('title', 'Utilizadores')

@section('subtitle','Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Utilizadores</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('utilizadors.update', encrypt($utilizador->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Utilizador</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                                <div>
                                    <h5 class="mb-3">Atualizar Foto</h5>
                                    <div class="position-relative">
                                        <img id="imagePreview" src="{{ $utilizador->foto ? asset('admin/imagens/users/'.$utilizador->foto) : asset('admin/imagens/users/default.png') }}" 
                                            class="border border-3 mb-3"
                                            style="width: 150px; height: 150px; object-fit: cover;" 
                                            alt="Preview">
                                    </div>
                                    <label for="imageUpload" class="btn btn-primary">Selecionar Imagem</label>
                                    <input type="file" id="imageUpload" accept="image/*" name="foto" 
                                           class="form-control d-none" onchange="previewImage(event)">
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">                                
                                    <input type="hidden" class="form-control" name="id" value="{{ encrypt($utilizador->id) }}">
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="form-label">Nome Completo</label>
                                        <input type="text" class="form-control" name="nome" value="{{ $utilizador->name_completo }}" required>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="form-label">Nome de Utilizador</label>
                                        <input type="text" class="form-control" name="username" value="{{ $utilizador->username }}" required>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="form-label">E-mail</label>
                                        <input type="email" class="form-control" name="email" value="{{ $utilizador->email }}" required>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="form-label">Telefone</label>
                                        <input type="text" class="form-control" name="telefone" value="{{ $utilizador->telefone }}" required>
                                    </div>
                                    @if (Auth::id() != $utilizador->id)
                                        <div class="col-lg-6 mb-3">
                                            <label for="estado" class="form-label">Estado</label>
                                            <select class="form-control" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                    <option value="1" {{ $utilizador->isActive ? 'selected' : '' }}>Activo</option>
                                                    <option value="0" {{ !$utilizador->isActive ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                        </div>
                                    @endif
                                    <div class=" @if (Auth::id() != $utilizador->id) col-lg-6 mb-3 @else col-lg-12 mb-3 @endif">
                                        <label for="estado" class="form-label">Perfil</label>
                                        <select name="perfil" class="form-control" required>
                                            @foreach ($roles as $role)
                                                @if (!(Gate::allows('isGestor') && ($role->id == 1 || $role->id == 4)))
                                                    <option value="{{ $role->id }}" {{ $utilizador->role_id == $role->id ? 'selected' : '' }}>{{ $role->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('utilizadors.index') }}" class="btn btn-dark">Voltar</a>
                        <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
    <!-- end: page -->
</section>

<script src="{{ asset("admin/js/Validacao/user.js")}}"></script>
@endsection