@extends('admin.layouts.platform')

@section('title', 'Utilizadores')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Utilizadores</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes do Utilizador</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center">
                            <div>
                                <h5 class="mb-3">Foto do Utilizador</h5>
                                <img src="{{ $utilizador->foto ? asset('admin/imagens/users/'.$utilizador->foto) : asset('admin/imagens/users/default.png') }}" 
                                     class="border border-3 mb-3"
                                     style="width: 150px; height: 150px; object-fit: cover;" 
                                     alt="Foto do Utilizador">
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nomeCompleto">Nome Completo</label>
                                        <input type="text" class="form-control" id="nomeCompleto" name="nome" value="{{ $utilizador->name_completo ?? '' }}" placeholder="Digite o nome" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="username">Nome de Utilizador</label>
                                        <input type="text" class="form-control" id="username" name="username" value="{{ $utilizador->username ?? '' }}" placeholder="Digite o nome de utilizador" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="email">E-mail</label>
                                        <input type="email" class="form-control" id="email" name="email" value="{{ $utilizador->email ?? ''}}" placeholder="Digite o email" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="telefone">Telefone</label>
                                        <input type="text" class="form-control" id="telefone" name="telefone" value="{{ $utilizador->telefone ?? ''}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="telefone" name="telefone" value="{{ $utilizador->isActive ? 'Activo' : 'Inativo'}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="telefone">Perfil</label>
                                        <input type="text" class="form-control" id="perfil" name="perfil" value="{{ $utilizador->role->name ?? ''}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('utilizadors.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('utilizadors.edit', encrypt($utilizador->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
