@extends('layouts.base')

@section('icone-modulo', 'fa fa-building')

@section('icone', 'fa fa-houzz')



@section('content')
    <section
        class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7"
        style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-12 font-weight-semibold">Entidades Parceiras</h1>
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb breadcrumb-light d-block text-center">
                        <li><a href="{{ route('home') }}">Pagina principal</a></li>
                        <li class="active">Parceiros</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>



    </div>
    </div>

    </div>
    {{-- <div id="examples" class="container py-2">
                <div class="row mb-5 pb-3">
                    <div class="col-md-6 col-lg-6 mb-20 mb-lg-0 appear-animation mb-1 pb-3" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="100">
                        <div class="card h-70"  >
                            <a href="https://arccla.gov.ao/" target="_blank"> <img class="card-img-top" src="{{ asset('frontend/img/logos/logo-4.png') }}" alt="Card Image" style=" height:100px; width:100%; object-fit: cover;  margin-bottom: 10px;" class="mb-1"></a>
                            <div class="card-body">
                                <h4 class="card-title mb-1 text-4 font-weight-bold">ARCCLA – Agência Reguladora de Certificação de Carga e Logística de Angola</h4>
                                <p class="card-text mb-2 pb-1" align="justify">A Agência Reguladora de Certificação de Carga e Logística de Angola, abreviadamente designada por «ARCCLA», é uma pessoa colectiva de direito público, que integra a Administração Indirecta do estado, dotado de autonomia administrativa, financeira e patrimonial.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 mb-20 mb-lg-0 appear-animation mb-1 pb-3" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="100">
                        <div class="card h-70">
                            <a href="https://www.antt.gov.ao/" target="_blank"> <img class="card-img-top" src="{{ asset('frontend/img/logos/logo-3.png') }}" alt="Card Image" style="height: 100px; width: 100%; margin-bottom: 10px; object-fit: cover;" class="mb-1"></a>
                            <div class="card-body">
                                <h4 class="card-title mb-1 text-4 font-weight-bold">ANTT – Agência Nacional dos Transportes Terrestres</h4>
                                <p class="card-text mb-2 pb-1" align="justify">A Agência Nacional dos Transportes Terrestres, abreviadamente designada por «ANTT», é uma pessoa colectiva de direito público que integra a Administração Indirecta do Estado, sob a forma de serviço personalizado, dotado de personalidade jurídica e de autonomia administrativa, financeira e patrimonial.</p>
                            </div>
                        </div>
                    </div>
                    <div class="w-100 h-"></div>
                    <div class="col-md-6 col-lg-6 mb-1 mb-lg-0 appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="100">
                        <div class="card h-70">
                            <a href="https://inipat.gov.ao/index.html" target="_blank"> <img class="card-img-top" src="{{ asset('frontend/img/logos/logo-2.png') }}" alt="Card Image" style="height: 100px; width: 100%; margin-bottom: 10px; object-fit: cover;" class="mb-1"></a>
                            <div class="card-body">
                                <h4 class="card-title mb-1 text-4 font-weight-bold">INIPAT – Instituto Nacional de Investigação e Prevenção de Acidentes de Transportes</h4>
                                <p class="card-text mb-2 pb-1" align="justify">O INIPAT é um instituto público que tem por missão a investigação de acidentes e incidentes que ocorram com os transportes civis, aéreos, marítimos e ferroviários, no território nacional sob jurisdição do Estado angolano.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 mb-5 mb-lg-0 appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="100">
                        <div class="card h-70">
                            <a href="https://mintrans.gov.ao/ao/tutela/" target="_blank"><img class="card-img-top" src="{{ asset('frontend/img/logos/logo-1.png') }}" alt="Card Image" style="height: 100px; width: 100%; margin-bottom: 10px; object-fit: cover;" class="mb-1"></a>
                            <div class="card-body">
                                <h4 class="card-title mb-1 text-4 font-weight-bold">AMN – Agência Marítima Nacional</h4>
                                <p class="card-text mb-2 pb-1" align="justify">A Agência Marítima Nacional, abreviadamente, designada por «AMN», é uma pessoa colectiva de direito público que integra a Administração Indirecta do Estado, sob forma de serviço personalizado, doptada de personalidade jurídica e de autonomia administrativa, financeira e patrimonial.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}

    <div id="examples" class="container py-2">
        <div class="row">
            <div class="col">

                <h2 class="font-weight-bold text-8">São parceiros do FSTPL:</h2>
                <hr class="solid">

                @foreach($categorias as $categoria)
                    <div  class="toggle m-0" data-plugin-toggle>
                        <div class="container">
                            <div class="row text-left pt-4">
                                <div class="col">
                                    <h4 class="text-6">
                                        {{ $categoria->nome ?? '' }}
                                    </h4>
                                    <hr>
                                </div>
                            </div>
                            @forelse($categoria->parceiros as $parceiro)
                                <div class="toggle toggle-primary m-0" data-plugin-toggle id="mainDiv">
                                    <style>
                                        :root {
                                            --secondary-color: {{ $config->secondary_color ?? 'black' }};
                                            --primary-color: {{ $config->primary_color ?? 'white' }};
                                        }

                                        #mainSection > a.toggle-title {
                                            color: var(--secondary-color) !important;
                                            border-color: var(--secondary-color) !important;
                                            /* background-color: var(--secondary-color) !important; */
                                        }
/* Quando ativo (expandido) */
                                        #mainSection.active > a.toggle-title {
                                            color: var(--primary-color) !important;
                                            background-color: var(--secondary-color) !important;
                                        }
                                       
                                    </style>
                                    <section class="toggle" id="mainSection">
                                        <a class="toggle-title"><strong class="font-weight-extra-bold">{{ $parceiro->nome ?? ''}}</strong></a>
                                        <div class="toggle-content">
                                            <div class="row py-4 pl-4">
                                                <div class="col-lg-8 text-center text-lg-start mb-2 mb-lg-0"
                                                    style="padding-left: 50px; padding-right: 50px;">
                                                    <a target="_blank" href="{{ $parceiro->site ?? '##'}}"> 
                                                        <img src="{{ $parceiro->imagem ? asset('admin/imagens/parceiros/'.$parceiro->imagem) : asset('admin/imagens/users/default.png') }}"
                                                            alt="Card Image" 
                                                            style="width: 40%; height: 170px; object-fit: cover;">
                                                    </a>
                                                </div>
                                                <p style="text-align: right; padding-right: 50px;">
                                                    <strong> Contacto:</strong> {{ $parceiro->telefone ?? ''}}
                                                    
                                                    <br>
                                                    <strong> Endereço:</strong> {{ $parceiro->endereco ?? ''}}
                                                    <hr>
                                                </p>
                                            </div>
                                        </div>
                                    </section>
                                </div>
                            @empty
                                <span>Nenhum parceiro registrado nesta categoria.</span>
                            @endforelse
                        </div>
                    </div>
                @endforeach
            </div>


        </div>

        <br>
        <br>




    @endsection


    @section('javascript')

    @endsection
