
@extends('layouts.base')

@section('icone-modulo',"fa fa-building")

@section('icone','fa fa-houzz')



@section('content')

            <section class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7" style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
                <div class="container">
                    <div class="row mt-5">
                        <div class="col-md-12 align-self-center p-static order-2 text-center">
                            <h1 class="text-12 font-weight-semibold">Legislação</h1>
                        </div>
                        <div class="col-md-12 align-self-center order-1">
                            <ul class="breadcrumb breadcrumb-light d-block text-center">
                                <li><a href="{{ route('home') }}">Pagina principal</a></li>
                                <li class="active">Informação</li>
                                <li class="active">Legislação</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            <div class="container py-4">
                <div class="row justify-content-center py-4">
                    @foreach ($legislacoes as $legislacao)
                        <div class="col-sm-10 col-md-7 col-lg-4 mb-4 mb-lg-3">
                            <div class="featured-boxes featured-boxes-modern-style-2 featured-boxes-modern-style-[red] my-4">
                                <div class="featured-box">
                                    <div class="box-content px-lg-4 px-xl-5 py-lg-5">
                                        <i style="color: {{ $config->secondary_color ?? 'black' }}" class="icon-featured far fa-file-alt"></i>
                                        <h2 class="font-weight-normal text-5"> <strong class="font-weight-extra-bold">{{ $legislacao->titulo ?? ''}}</strong></h2>
                                        <p class="mb-0">{{ $legislacao->subTitulo ?? ''}}</p>
                                        <a href="{{ asset('admin/documentos/legislacao/' . $legislacao->anexo) }}" download="{{ $legislacao->titulo ?? 'decreto'}}" class="btn btn-light btn-outline font-weight-semibold text-color-dark btn-px-5 btn-py-2 border-width-1 text-1 mt-3"><i class="fa fa-download"></i>  Baixar</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <hr class="solid my-5">
                </div>
            </div>

        </div>
        </div>


@endsection


@section('javascript')

@endsection
