@extends('layouts.base')

@section('icone-modulo',"fa fa-building")
@section('icone','fa fa-houzz')

@section('content')
<section class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7" style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
    <div class="container">
        <div class="row">
            <div class="row mt-5">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-12 font-weight-semibold">Simulador Complemento de Reforma</h1>
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb breadcrumb-light d-block text-center">
                        <li><a href="{{ route('home') }}">Pagina principal</a></li>
                        <li class="active">Informações</li>
                        <li class="active">Simulador Complemento de Reforma</li>
                    </ul>
                </div>
            </div>            
        </div>
    </div>
</section>
<div class="container justify-content-center">
    <div class="row py-4 justify-content-center">
        <div class="col-lg-12 appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="650">

            <div class="container">
                <div class="row">
                    <div class="col">
                        <section class="card card-admin">
                            <header class="card-header">
                                <div class="card-actions">
                                    <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a>
                                </div>
                                <h2 class="card-title">Simulador por Complemento de Reforma</h2>
                            </header>
                            <div class="card-body">

                                <table class="table align-middle table-nowrap table-striped text-center" id="customerTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="40%"></th>
                                            <th width="60%" style="text-align: center">Valores</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><strong>Salário Base</strong></td>
                                            <td>
                                                <div>
                                                    <div class="input-group">
                                                        <input onkeypress = "return validaS(this, event, this.value);" title="Digitar a salário actual da pessoa que se pretende ser simulado." type="text" class="dinheiro form-control" name="salarioBase" id="salarioBase" placeholder="Ex.: 250 000" style="text-align: right; font-size: 22px; color: #E9B618;  font-style: italic;" required/>
                                                        <span class="input-group-text" id="basic-addon2">AOA</span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td hidden><strong>Média do Salário Base</strong></td>
                                            <td hidden>
                                                <div>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control dinheiro" name="MSB" id="MSB" style="text-align: right; font-size: 22px; color: #E9B618;  font-style: italic;" readonly />
                                                        <span class="input-group-text" id="basic-addon2">AOA</span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <div class="form-group">
                                                <td><strong>Tempo de Contribuição</strong></td>
                                                <td>
                                                    <div>
                                                        <div class="input-group">
                                                            <input title="Introduzir os anos que contribuiu." type="number" min="36" class="form-control" name="tempoC" id="tempoC" style="text-align: right; font-size: 22px; color: #E9B618;  font-style: italic;" required/>
                                                            <span class="input-group-text" id="basic-addon2">Meses</span>
                                                        </div>
                                                        <span id="info-erro" class="text-danger"></span>
                                                    </div>
                                                </td>
                                            </div>
                                        </tr>
                                        <tr>
                                            <td hidden><strong>Tempo de Benefício</strong></td>
                                            <td hidden>
                                                <div>
                                                    <div class="input-group">
                                                        <input type="number" min="1" value="5" class="form-control" name="tempoBeneficio" id="tempoBeneficio" placeholder="Ex.: 1 mes(es)" style="text-align: right; font-size: 22px; color: #E9B618;  font-style: italic;" readonly/>
                                                        <span class="input-group-text" id="basic-addon2">Meses</span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total a Receber</strong></td>
                                            <td>
                                                <div>
                                                    <div class="input-group">
                                                        <input type="nu" class="form-control" name="totalReceber" id="totalReceber" style="text-align: right; font-size: 22px; color: #E9B618;  font-style: italic;" readonly />
                                                        <span class="input-group-text" id="basic-addon2">AOA</span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td hidden><strong>Total a Receber Por Mês</strong></td>
                                            <td hidden>
                                                <div>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" name="totalReceberMes" id="totalReceberMes" style="text-align: right; font-size: 22px; color: #E9B618;  font-style: italic;" readonly />
                                                        <span class="input-group-text" id="basic-addon2">AOA</span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </div>
</div>

@endsection

@section('javascript')

<script>
    function enviarValor() {
        var option = document.getElementById('mes_seleccionado').value;
        $("#teste").append("<input type='hidden' id='abc' name='okok' value=" + option + " />");
        var setado = $("#abc").val();
    }

    function alterarValor(param) {
        if (param == 'Geral') {
            $("#tpa2").attr("required", "false");
        }

    }
</script>

<script type='text/javascript' src="{{ asset('js/our/numeral.min.js') }}"></script>
<script type="text/javascript" src="{{asset('js/consultarAssociadoQuota.js')}}"></script>

<script>
    function formatarValor (valor) {
        return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valor);
    }

    function formatarValorBasic (valor) {
        return new Intl.NumberFormat('pt-BR', { minimumFractionDigits: 0, maximumFractionDigits: 2 }).format(valor);
    }

    function formatarValorMonetario(nStr) {
        nStr = nStr.replace(/\./gi, "");
        nStr += '';
        x = nStr.split(',');
        x1 = x[0];
        x2 = x.length > 1 ? ',' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + '.' + '$2');
        }
        return x1 + x2;
    }

    function desformatarValorBasic (valor) {
        return desformatado = parseFloat(valor.replace(/\./g, '').replace(',', '.'));
    }

    function desformatarS (valor) {
        return desformatado = parseFloat(valor.replace(/\./g, ''));
    }

    function desformatarValor (valor) {
        return desformatado = parseFloat(valor.replace(/\,/g, ''));
    }

    function desformatarToInt (valor) {
        const desformatado = parseFloat(valor.replace(/\D/g, ''), 10);
    }
</script>

<script type="text/javascript">

    $('#salarioBase').on('keyup', function() {
        var salario = $('#salarioBase').val();

        // console.log(desformatarS(salario));
        var salarioAnual = (desformatarS(salario) * 12).toFixed(2);
        $('#salarioBaseAnual').css("border-color","red");
        $('#salarioBaseAnual').addClass("animate6 bounceIn");
        $('#salarioBaseAnual').val(formatarValorBasic(salarioAnual));

        var MSB = (salarioAnual/12).toFixed(2);
        $('#MSB').css("border-color","red");
        $('#MSB').addClass("animate6 bounceIn");
        $('#MSB').val(formatarValorBasic(MSB));

        if ($('#tempoBeneficio').val() && $('#tempoC').val()) {

            var MSB = $('#MSB').val();
            var mesesContribuidos = $('#tempoC').val();
            var tempoBeneficio = $('#tempoBeneficio').val();

            if ($('#tempoC').val() < 36) {
                document.getElementById('info-erro').innerHTML = 'O tempo de contribuição deve ser a partir de 36 meses, que corresponde à três anos';
                return;
            } else {
                document.getElementById('info-erro').innerHTML = '';
                let subsidio = calcularValor(desformatarValorBasic(MSB), mesesContribuidos, tempoBeneficio);
                $('#totalReceber').val(formatarValorBasic(subsidio));
                $('#totalReceberMes').val(formatarValorBasic(subsidio/tempoBeneficio));
            }


        } else {
            $('#totalReceber').val('');
            $('#totalReceberMes').val('');
        }

        $('#salarioBase').val(formatarValorMonetario(salario));

    });

    $('#tempoC').on('keyup', function() {
        var anos = $('#tempoC').val();

        if ($('#tempoBeneficio').val() &&  $('#MSB').val() && anos >= 3) {

            var MSB = $('#MSB').val();
            var mesesContribuidos = $('#tempoC').val();
            var tempoBeneficio = $('#tempoBeneficio').val();

            if ($('#tempoC').val() < 36) {
                document.getElementById('info-erro').innerHTML = 'O tempo de contribuição deve ser a partir de 36 meses, que corresponde à três anos';
                return;
            } else {
                document.getElementById('info-erro').innerHTML = '';

                let subsidio = calcularValor(desformatarValorBasic(MSB), mesesContribuidos,tempoBeneficio);
                $('#totalReceber').css("border-color","red");
                $('#totalReceber').addClass("animate6 bounceIn");
                $('#totalReceber').val(formatarValorBasic(subsidio));

                $('#totalReceberMes').css("border-color","red");
                $('#totalReceberMes').addClass("animate6 bounceIn");
                $('#totalReceberMes').val(formatarValorBasic(subsidio/tempoBeneficio));
            }

        } else {
            $('#totalReceber').val('');
            $('#totalReceberMes').val('');
        }


    });

    $('#tempoBeneficio').on('keyup', function() {
        var meses = $('#tempoBeneficio').val();

        if ($('#MSB').val() && $('#tempoC').val() && $('#tempoBeneficio').val() >= 1) {

            var MSB = $('#MSB').val();
            var mesesContribuidos = $('#tempoC').val();
            var tempoBeneficio = $('#tempoBeneficio').val();

            if ($('#tempoC').val() < 36) {
                document.getElementById('info-erro').innerHTML = 'O tempo de contribuição deve ser a partir de 36 meses, que corresponde à três anos';
                return;
            } else {
                document.getElementById('info-erro').innerHTML = '';
                let subsidio = calcularValor(desformatarValorBasic(MSB), mesesContribuidos, tempoBeneficio);
                $('#totalReceber').val(formatarValorBasic(subsidio));
                $('#totalReceberMes').val(formatarValorBasic(subsidio/tempoBeneficio));
            }

        } else {
            $('#totalReceber').val('');
            $('#totalReceberMes').val('');
        }


    });

    function validaAno(campo, evento, valor) {
        var tecla = (window.evento) ? evento.keyCode : evento.which;
        if ((tecla === 13) || (tecla === 44) || (tecla === 45) || (tecla === 46)) {
            return false;
        }
        else {
            if (tecla === 8 || tecla === 0 || tecla === 45) {
                return true;
            }
            else {
                if (anosServico === valor) {
                    return false;
                }
                valor += "" + tecla - 48;
                valor = 3;
                if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                    return false;
                }
            }
        }
    }

    function validaNumero(evento, valor) {
        var tecla = (window.evento) ? evento.keyCode : evento.which;
        var anosServico = $('#anosServico').val() * 1;
        if ((tecla === 13) || (tecla === 44) || (tecla === 45) || (tecla === 46)) {
            return false;
        }
        else {
            if (tecla === 8 || tecla === 0 || tecla === 45) {
                return true;
            }
            else {
                if (anosServico === valor) {
                    return false;
                }
                valor += "" + tecla - 48;
                if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57 || valor > anosServico) {
                    return false;
                }
            }
        }
    }

    function validaNumeroS(evento, valor) {
        var tecla = (window.evento) ? evento.keyCode : evento.which;
        if ((tecla === 13) || (tecla === 44) || (tecla === 45) || (tecla === 46)) {
            return false;
        }
        else {
            if (tecla === 8 || tecla === 0 || tecla === 45) {
                return true;
            }
            else {
                valor += "" + tecla - 48;
                if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                    return false;
                }
            }
        }
    }

    function validaPercentagem(campo, evento, valor) {
        var tecla = (window.evento) ? evento.keyCode : evento.which;

        campo.value = campo.value.replace(/,/gi, ".");

        if (tecla === 13) {
            return false;
        }
        else {
            if (tecla === 8 || tecla === 0 || tecla === 45) {
                return true;
            }
            else {
                valor += "" + tecla - 48;
                if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57 || valor > 100) {
                    return false;
                }
            }
        }
    }

    function validaS(campo, evento, valor) {
        var tecla = (window.evento) ? evento.keyCode : evento.which;

        if (tecla === 13) {
            return false;
        }
        else {
            if (tecla === 8 || tecla === 0 || tecla === 45) {
                return true;
            }
            else {
                valor += "" + tecla - 48;
                if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57 || valor < 0) {
                    return false;
                }
            }
        }
    }

    function validaDouble(campo, evento, valor) {
        var tecla = (window.evento) ? evento.keyCode : evento.which;

        if (tecla === 13) {
            return false;
        }
        else {
            if (tecla === 8 || tecla === 0 || tecla === 45) {
                return true;
            }
            else {
                valor += "" + tecla - 48;
                if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                    return false;
                }
            }
        }
    }

    function calcularValor (MSB, mesesContribuidos, tempoBeneficio) {

        const limiteTempo = 96 // em meses, equivale a 8 anos
        let a = MSB * mesesContribuidos;
        let b = a * tempoBeneficio;
        let valor = b / limiteTempo;

        return valor;
    }

</script>

@endsection
