@extends('layouts.base')

@section('icone-modulo', 'fa fa-building')

@section('icone', 'fa fa-houzz')



@section('content')

    <div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs nav-style-1 nav-inside nav-inside-plus nav-dark nav-lg nav-font-size-lg show-nav-hover mb-0"
        data-plugin-options="{'autoplayTimeout': 7000}" data-dynamic-height="['700px','700px','700px','550px','500px']"
        style="height: 700px;">
        <div class="owl-stage-outer">
            <div class="owl-stage">
                @foreach ($bunnerItems as $item)
                    <div class="owl-item position-relative overflow-hidden overlay overlay-color-dark overlay-show overlay-op-6"
                        style="background-image: url({{ $item->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $item->imagem) : asset('admin/imgDefault.png') }}); background-size: cover; background-repeat: no-repeat; background-position: center; width: 100%">
                        <div class="container position-relative z-index-3 h-100">
                            <div class="row justify-content-center align-items-center h-100">
                                <div class="col-lg-7">
                                    <div class="d-flex flex-column align-items-center">
                                        <h1 style="color: {{ $item->cor_titulo ?? 'black'}};"
                                            class="font-weight-extra-bold text-10 text-md-12-13 line-height-1 text-center mb-2 appear-animation"
                                            data-appear-animation="blurIn" data-appear-animation-delay="500"
                                            data-plugin-options="{'minWindowWidth': 0}">
                                            {{ $item->titulo ?? 'Template N2BS'}}
                                        </h1>
                                        {{-- <h2 style="color: #fff;" class="position-relative text-color-dark text-5 line-height-5 font-weight-semibold ls-0 px-4 mb-2 appear-animation" data-appear-animation="fadeInDownShorterPlus" data-plugin-options="{'minWindowWidth': 0}">
                                                    <span style="color:#fff;">MINISTÉRIO DOS TRANSPORTES</span>
                                                </h2> --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="owl-nav">
            <button type="button" role="presentation" class="owl-prev" aria-label="Previous"></button>
            <button type="button" role="presentation" class="owl-next" aria-label="Next"></button>
        </div>
        <div class="owl-dots mb-5">
            {{-- <button role="button" class="owl-dot active"><span></span></button>
            <button role="button" class="owl-dot"><span></span></button>
            <button role="button" class="owl-dot"><span></span></button>
            <button role="button" class="owl-dot"><span></span></button> --}}
        </div>
    </div>


    <!--   <div class="row justify-content-center text-center mb-4 appear-animation"
                            data-appear-animation="fadeInUpShorter" data-appear-animation-delay="400">
                            <div class="col-lg-8">
                                <h2 class="font-weight-bold mb-3 mt-3">Sobre Nós</h2>
                                <p class="text-6 text-color-dark line-height-7 negative-ls-1 px-5">Atendendo a importância do Sector dos Transportes, como alavanca do crecimento e desenvolvimento sócio-económico do País,cujo cumprimento cabal das suas atribuições assenta no profissionalismo e melhor desempenho das funções pelos deus quadros.</p>
                                <p class="opacity-9 text-4">O FSTPL tem como objectivos a melhoria das condições de trabalho e sócioeconómicas dos funcionários, agentes administrativos, pessoal contratado e trabalhadores, assim como o apoio a actividades culturais, recreativas e desportivas.</p>
                            </div>-->


    {{-- <section class="section section-height-3 bg-color-grey m-0 border-0">
                <div class="container">
                    <div class="row align-items-center justify-content-center">
                        <div class="col-lg-6 pb-sm-4 pb-lg-0 pe-lg-5 mb-sm-5 mb-lg-0">
                            <h2 class="text-color-dark font-weight-normal text-6 mb-2">Conheça o <strong class="font-weight-extra-bold">FSTPL</strong></h2>
                            <p class="lead text-color-dark" align="justify">Atendendo a importância do Sector dos Transportes, como
                                alavanca do crecimento e desenvolvimento sócio-económico do País,cujo cumprimento cabal
                                das suas atribuições assenta no profissionalismo e melhor desempenho das funções pelos
                                deus quadros. </p>
                            <p class="lead text-color-dark" align="justify">O <strong class="font-weight-extra-bold">FSTPL</strong> tem como objectivos a melhoria das condições de
                                trabalho e sócioeconómicas dos funcionários, agentes administrativos, pessoal contratado
                                e trabalhadores, assim como o apoio a actividades culturais, recreativas e desportivas.
                            </p>
                        </div>
                        <div class="col-sm-8 col-md-6 col-lg-4 offset-sm-4 offset-md-4 offset-lg-2 position-relative mt-sm-5"
                            style="top: 1.7rem;">
                            <img src="{{ asset('frontend/img/generic/generic-corporate-3-1.jpg') }}" class="img-fluid position-absolute d-none d-sm-block appear-animation" data-appear-animation="expandIn" data-appear-animation-delay="300" style="top: 10%; left: -50%;" alt="" />
                            <img src="{{ asset('frontend/img/generic/generic-corporate-3-2.jpg') }}" class="img-fluid position-absolute d-none d-sm-block appear-animation" data-appear-animation="expandIn" style="top: -33%; left: -29%;" alt="" />
                            <img src="{{ asset('frontend/img/generic/generic-corporate-3-3.jpg') }}" class="img-fluid position-relative appear-animation mb-2" data-appear-animation="expandIn" data-appear-animation-delay="600" alt="" />
                        </div>
                    </div>
                </div>

            </section> --}}

    {{-- <section class="parallax section section-height-3 section-parallax m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5}" data-image-src="frontend/img/parallax/parallax-corporate-14-1.png">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-7 mb-5 mb-lg-0 appear-animation"
                            data-appear-animation="fadeInRightShorter">
                            <p class="text-color-primary text-2 line-height-1 mb-2">FSTPL</p>
                            <h4 class="text-color-dark font-weight-normal line-height-3 text-6">Fundo Social dos <strong class="font-weight-extra-bold">FSTPL - Funcionários e Trabalhadores do Sector dos Transportes</strong></h4>
                            <p class="text-color-dark" align="justify" class="lead pb-2 mb-4">Membros do <strong class="font-weight-extra-bold">FSTPL</strong> todos os funcionários, agentes
                                administrativos, pessoa contratado e trabalhadores que independentemente da relação
                                juridico-laboral, estejam ao serviço do Ministério dos Transportes, Orgãos
                                superintendidos.</p>
                            <a href="#"
                                class="btn btn-outline btn-primary font-weight-bold text-1 px-4 btn-py-2">Conheça-nos melhor</a>
                        </div>
                        <div class="col-lg-5">
                            <div class="row">
                                <div class="col appear-animation" data-appear-animation="fadeInRightShorter"
                                    data-appear-animation-delay="200">
                                    <div class="row counters counters-lg counters-text-dark">
                                        <div class="col-md-6 mb-5">
                                            <div class="counter">
                                                <strong class="font-weight-extra-bold text-12" data-to="1000"
                                                    data-append="+">0</strong>
                                                <label class="opacity-8 font-weight-normal text-4">Associados</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-5">
                                            <div class="counter">
                                                <strong class="font-weight-extra-bold text-12" data-to="300"
                                                    data-append="+">0</strong>
                                                <label class="opacity-8 font-weight-normal text-4">Agentes
                                                    administrativos</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-5 mb-md-0">
                                            <div class="counter">
                                                <strong class="font-weight-extra-bold text-12" data-to="20"
                                                    data-append="+">0</strong>
                                                <label
                                                    class="opacity-8 font-weight-normal text-4">Independentes</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="counter">
                                                <strong class="font-weight-extra-bold text-12" data-to="100"
                                                    data-append="+">0</strong>
                                                <label class="opacity-8 font-weight-normal text-4">Orgãos
                                                    Suplementares</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </section> --}}






    {{-- <div class="row text-center pt-4 mt-5">
                <div class="col">
                    <h2 class="word-rotator slide font-weight-bold text-8 mb-2">
                        <span>Mensagem do Presidente </span>
                        <span class="word-rotator-words bg-primary">

                        </span>

                    </h2>
                </div>
            </div>
            <div class="container py-4">
            <div class="row">
                <div class="col-md-7 order-2">
                    <div class="overflow-hidden">
                        <h2 class="text-color-dark font-weight-bold text-8 mb-0 pt-0 mt-0 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="300">Bruno Renato Custódio e Silva Inglês</h2>
                    </div>
                    <div class="overflow-hidden mb-3">
                        <p class="font-weight-bold text-primary text-uppercase mb-0 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="500">Presidente da Comissão de Gestão</p>
                    </div>
                    <p class="lead appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="700">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam <a href="#">vehicula</a> sit amet enim ac sagittis. Curabitur eget leo varius, elementum mauris eget, egestas quam. Donec ante risus, dapibus sed lectus non, lacinia vestibulum nisi. Morbi vitae augue quam. Nullam ac laoreet libero.</p>
                    <p class="pb-3 appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="800">Consectetur adipiscing elit. Aliquam iaculis sit amet enim ac sagittis. Curabitur eget leo varius, elementum mauris eget, egestas quam.</p>
                    <hr class="solid my-4 appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="900">
                    <div class="row align-items-center appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="1000">
                        <div class="col-lg-6">
                            <a href="#" class="btn btn-modern btn-dark mt-3">Get In Touch</a>
                            <a href="{{ route ('mensagemPresidente') }}" class="btn btn-modern btn-primary mt-3">Ver mais</a>
                        </div>
                        <div class="col-sm-6 text-lg-end my-4 my-lg-0">
                            <strong class="text-uppercase text-1 me-3 text-dark">follow me</strong>
                            <ul class="social-icons float-lg-end">
                                <li class="social-icons-facebook"><a href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                                <li class="social-icons-twitter"><a href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-x-twitter"></i></a></li>
                                <li class="social-icons-linkedin"><a href="http://www.linkedin.com/" target="_blank" title="Linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5 order-md-2 mb-4 mb-lg-0 appear-animation" data-appear-animation="fadeInRightShorter">
                    <img src="frontend/img/team/team-1.jpg" class="img-fluid" alt="">
                </div>
            </div> --}}

    {{-- <div class="row">
                <div class="col">
                    <hr class="solid my-5">
                </div>
            </div> --}}

    </div>
    {{-- <div class="container">

                <div class="row text-center pt-4 mt-5">
                    <div class="col">
                        <h2 class="word-rotator slide font-weight-bold text-8 mb-2">
                            <span>Órgãos Superintendidos </span>
                            <span class="word-rotator-words bg-primary">

                            </span>

                        </h2>
                    </div>
                </div>


                <div class="row py-4 my-5">
                    <div class="col py-3">
                        <div class="owl-carousel owl-theme mb-0"
                            data-plugin-options="{'responsive': {'0': {'items': 1}, '476': {'items': 1}, '768': {'items': 5}, '992': {'items': 7}, '1200': {'items': 7}}, 'autoplay': true, 'autoplayTimeout': 3000, 'dots': false}">
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/logos/logo-1.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/logos/logo-2.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/logos/logo-3.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/logos/logo-4.png') }}"
                                    alt="">
                            </div>

                        </div>

                    </div>
                </div>
            </div>



            <div class="container">

                <div class="row text-center pt-4 mt-5">
                    <div class="col">
                        <h2 class="word-rotator slide font-weight-bold text-8 mb-2">
                            <span>Entidades Tuteladas</span>
                            <span class="word-rotator-words bg-primary">

                            </span>

                        </h2>
                    </div>
                </div>


                <div class="row py-4 my-5">
                    <div class="col py-3">
                        <div class="owl-carousel owl-theme mb-0 ml-5"
                            data-plugin-options="{'responsive': {'0': {'items': 1}, '476': {'items': 1}, '768': {'items': 5}, '992': {'items': 7}, '1200': {'items': 7}}, 'autoplay': true, 'autoplayTimeout': 3000, 'dots': false}">
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/1.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/2.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/3.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/4.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/5.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/6.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/CFBlogo.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/4.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/CFM-Logotipo---copia.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/download.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/images(1).jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/images.jpg') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/Logo(1).png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/logo.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/logo_enna_ep.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/logo_novo.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/LOGO_TCUL.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/SECILLOGO.png') }}"
                                    alt="">
                            </div>
                            <div>
                                <img class="img-fluid opacity-2" src="{{ asset('frontend/img/Entidades_Tutelares/transferir.jpg') }}"
                                    alt="">
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col py-3">
                    <hr class="solid mt-5 mb-2">
                </div>
            </div> --}}


    {{-- <div class="container pb-1">

                <div class="row pt-4 text-center">
                    <div class="col">
                        <div class="overflow-hidden mb-3">
                            <h2 class="font-weight-bold text-8 mb-0 appear-animation" data-appear-animation="maskUp">
                                Nossos Serviços
                            </h2>
                        </div>
                    </div>
                </div>



                <div class="row">
                    <div class="featured-boxes featured-boxes-style-2">
                        <div class="row">
                            <div class="col-md-6 col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter"
                                data-appear-animation-delay="700">
                                <div class="featured-box featured-box-effect-4">
                                    <div class="box-content">
                                        <i
                                            class="icon-featured icon-screen-tablet icons text-color-primary bg-color-grey"></i>
                                        <h4 class="font-weight-bold">Atribuições de prémios de desempenho e incentivos
                                        </h4>
                                        <p align="justify" class="px-3">São atribuidos estimulos ou incentivos com
                                            base em critérios de premiação em função da produtividade e cumprimento de
                                            metas traçadas individualmente e às equipas de trabalho que se destaquem.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter"
                                data-appear-animation-delay="900">
                                <div class="featured-box featured-box-effect-4">
                                    <div class="box-content">
                                        <i
                                            class="icon-featured icon-layers icons text-color-light bg-color-primary"></i>
                                        <h4 class="font-weight-bold">Assistència médico-medicamentosa</h4>
                                        <p class="px-3" align="justify">Os benéficios com a natureza de apoio à
                                            saúde, destinam-se ao custeio das despesas de assistència
                                            médico-medicamentosas dos membros do FSTPL, seus cônjuges, filhos menores e
                                            dependentes, em condições a estabelecer, mediante proposta da comissão de
                                            gestão do FSTPL.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter"
                                data-appear-animation-delay="1100">
                                <div class="featured-box featured-box-effect-4">
                                    <div class="box-content">
                                        <i
                                            class="icon-featured icon-magnifier icons text-color-primary bg-color-grey"></i>
                                        <h4 class="font-weight-bold">Assistência Social</h4>
                                        <p class="px-3" align="justify">Benefícios de apoio social destinam-se a
                                            atribuição de subsídio de complemento de reforma aos membros do FSTPL.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 appear-animation" data-appear-animation="fadeInLeftShorter"
                                data-appear-animation-delay="1500">
                                <div class="featured-box featured-box-effect-4">
                                    <div class="box-content">
                                        <i
                                            class="icon-featured icon-screen-desktop icons text-color-light bg-color-primary"></i>
                                        <h4 class="font-weight-bold">Actividades culturais, desportivas e recreativas
                                        </h4>
                                        <p class="px-3" align="justify">Benefícios de natureza cultural, desporitva
                                            e recreativa, destinados a dinamização, organização e realização de
                                            encontros dos membros.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 appear-animation" data-appear-animation="fadeInLeftShorter"
                                data-appear-animation-delay="1300">
                                <div class="featured-box featured-box-effect-4">
                                    <div class="box-content">
                                        <i class="icon-featured icon-doc icons text-color-primary bg-color-grey"></i>
                                        <h4 class="font-weight-bold">Concessão e Emprestimos</h4>
                                        <p class="px-3" align="justify">Destina-se à concenssão de emprestimos aos
                                            membros que tenham contribuído para o FSTPL - Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes, por um peíodo minimo de
                                            12 meses..</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 appear-animation" data-appear-animation="fadeInLeftShorter"
                                data-appear-animation-delay="1100">
                                <div class="featured-box featured-box-effect-4">
                                    <div class="box-content">
                                        <i class="icon-featured icon-menu icons text-color-light bg-color-primary"></i>
                                        <h4 class="font-weight-bold">Reservas de contigencias e investimentos</h4>
                                        <p class="px-3" align="justify">Plano de investimentos previsto, com vista à
                                            salvaguarda da solidez e liquidez do FSTPL - Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}


    <div class="row text-center pt-4 mt-5 mt-10">
        <div class="col">
            <h2 class="word-rotator slide font-weight-bold text-8 mb-2">
                <span>Notícias Recentes</span>
            </h2>
        </div>
    </div>
    <section class="section-no-background section-height-4 border-0 appear-animation" data-appear-animation="fadeIn">

        <div class="container">
            <section class="section-no-background section-height-4 border-0 pb-5 appear-animation"
                data-appear-animation="fadeIn">
                <div class="container">
                    <div class="row justify-content-center recent-posts appear-animation"
                        data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200" id="noticias-container">

                        @foreach ($noticiasRecentes as $noticiaRecente)
                            <div class="col-lg-4 mb-4">
                                <article class="post post-large pb-5">
                                    <div class="post-image text-center">
                                        <a href="{{ route('noticias.detalhe', encrypt($noticiaRecente->id)) }}">
                                            <img
                                                src="{{ asset('admin/imagens/noticias/' . $noticiaRecente->imagem) }}"
                                                style="width: 500px; height: 200px; object-fit: cover;"
                                                height="100"
                                                class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-0"
                                                alt="" />
                                        </a>
                                    </div>

                                    <div class="post-date text-center">
                                        <span style="color: {{ $config->secondary_color ?? 'black' }}" class="day d-block">{{ date('d', strtotime($noticiaRecente->data_publicacao)) }}</span>
                                        <span style="background-color: {{ $config->secondary_color ?? 'black' }}" class="month d-block">{{ date('M', strtotime($noticiaRecente->data_publicacao)) }}</span>
                                    </div>

                                    <div class="post-content">
                                        <div style="width: 100%; height: 240px; overflow: hidden;">
                                            <h4 style="text-transform: uppercase;">
                                                <a href="{{ route('noticias.detalhe', encrypt($noticiaRecente->id)) }}"
                                                style="color: {{ $config->secondary_color ?? 'black' }}">
                                                {{ $noticiaRecente->titulo ?? '' }}
                                                </a>
                                            </h4>
                                        </div>

                                        <div style="width: 100%; height: 255px; overflow: hidden;">
                                            <p class="mb-1 text-justify">
                                                {{ $noticiaRecente->resumo ?? '' }}...
                                                <a href="{{ route('noticias.detalhe', encrypt($noticiaRecente->id)) }}"
                                                    class="read-more text-color-dark font-weight-bold text-2">
                                                    Ver mais <i class="fas fa-chevron-right text-1 ms-1"></i>
                                                </a>
                                            </p>
                                        </div>
                                    </div>
                                </article>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="row text-center">
        <div class="col">
            <h2 class="word-rotator slide font-weight-bold text-8 mb-2">
                <span>Eventos | Actividades Recentes</span>
            </h2>
        </div>
    </div>
    <section class="section-no-background section-height-4 border-0 pb-5 appear-animation" data-appear-animation="fadeIn">

        <div class="container">
            <section class="section-no-background section-height-4 border-0 pb-5 appear-animation"
                data-appear-animation="fadeIn">
                <div class="container">
                    <div class="row justify-content-center recent-posts appear-animation"
                        data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200" id="noticias-container">

                        @foreach ($eventosRecentes as $eventosRecente)
                            <div class="col-lg-4 mb-4">
                                <article class="post post-large pb-5">
                                    <div class="post-image text-center">
                                        <a href="{{ route('eventos.detalhe', encrypt($eventosRecente->id)) }}">
                                            <img
                                                src="{{ asset('admin/eventos/' . $eventosRecente->imagem) }}"
                                                style="width: 500px; height: 200px; object-fit: cover;"
                                                height="100"
                                                class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-0"
                                                alt="" />
                                        </a>
                                    </div>

                                    <div class="post-date text-center">
                                        <span style="color: {{ $config->secondary_color ?? 'black' }}" class="day d-block">{{ date('d', strtotime($eventosRecente->detalhe_evento)) }}</span>
                                        <span style="background-color: {{ $config->secondary_color ?? 'black' }}" class="month d-block">{{ date('M', strtotime($eventosRecente->detalhe_evento)) }}</span>
                                    </div>

                                    <div class="post-content">
                                        <div style="width: 100%; height: 240px; overflow: hidden;">
                                            <h4 style="text-transform: uppercase;">
                                                <a href="{{ route('eventos.detalhe', encrypt($eventosRecente->id)) }}"
                                                style="color: {{ $config->secondary_color ?? 'black' }}">
                                                {{ $eventosRecente->titulo ?? '' }}
                                                </a>
                                            </h4>
                                        </div>

                                        {{-- <div style="width: 100%; height: 255px; overflow: hidden;">
                                            <p class="mb-1 text-justify">
                                                {{ $eventosRecente->resumo ?? '' }}...
                                                <a href="{{ route('eventos.detalhe', encrypt($eventosRecente->id)) }}"
                                                    class="read-more text-color-dark font-weight-bold text-2">
                                                    Ver mais <i class="fas fa-chevron-right text-1 ms-1"></i>
                                                </a>
                                            </p>
                                        </div> --}}
                                    </div>
                                </article>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
    </section>
      <div id="examples" class="container py-2">

        <div class="row">
            <div class="col">
                <div class="row">
                    <div class="col pb-4">

                        <h4>FSTPL - AssociaT</h4>
                        <div class="ratio ratio-16x9">
                            <iframe frameborder="0" allowfullscreen=""
                                src="http://www.youtube.com/embed/Z-EFJnJ_iQA?showinfo=0&amp;wmode=opaque"></iframe>
                        </div>

                        <hr class="solid my-5">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="section d-flex justify-content-center align-items-center border-0 mb-0 appear-animation animated fadeIn appear-animation-visible" data-appear-animation="fadeIn" data-plugin-options="{'accY': -150}"
            style="animation-delay: 100ms; background-color: {{ $config->secondary_color ?? 'black' }}">
        <div class="container-fluid">
            <div class="row counters counters-sm d-flex justify-content-center align-items-center">
                {{-- <div class="col-sm-3 col-lg-3">
                    <div class="counter">
                        <i class="icons icon-user text-color-light"></i>
                        <strong class="text-color-light font-weight-extra-bold" data-to="1000" data-append="+">1000+</strong>
                        <label class="text-4 mt-1 text-color-light">Associados</label>
                    </div>
                </div> --}}
                <div class="col-sm-3 col-lg-3">
                    <div class="counter">
                        <i style="color:  {{ $config->primary_color ?? 'white' }}" class="icons icon-badge"></i>
                        <strong style="color:  {{ $config->primary_color ?? 'white' }}" class=" font-weight-extra-bold mt-3" data-to="{{$totalParceiros}}">{{$totalParceiros}}</strong>
                        <label style="color:  {{ $config->primary_color ?? 'white' }}" class="font-weight-extra-bold text-7 mt-3">Parceiros</label>
                    </div>
                </div>

                <div class="col-sm-3 col-lg-3">
                    <div class="counter">
                        <i style="color:  {{ $config->primary_color ?? 'white' }}" class="icons icon-cup"></i>
                        <strong style="color:  {{ $config->primary_color ?? 'white' }}" class="font-weight-extra-bold mt-3" data-to="{{$totalBeneficios}}">{{$totalBeneficios}}</strong>
                        <label style="color:  {{ $config->primary_color ?? 'white' }}" class="font-weight-extra-bold text-7 mt-3">Benefícios</label>
                    </div>
                </div>
            </div>
        </div>
    </section>
    </div>



@endsection


@section('javascript')

@endsection
