<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\CandidatoController;
use App\Http\Controllers\Api\UserController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
// Route::get('/candidatos', [CandidatoController::class,'index']);
// Route::post('/candidatos/destroyer', [CandidatoController::class,'deletarCandidaturas']);
// Route::get('/candidatos/download/zip/doc', [CandidatoController::class, 'downloadAllDocs']);

// Route::get('/candidatos/get', [CandidatoController::class,'index']);

Route::post('/generate-spring-token', [UserController::class,'userTokenGenerate']);

Route::middleware('auth:sanctum')->get('/test-api', function () {
    return response()->json(['mensagem' => "credenciado"], 200);
});

Route::middleware('auth:sanctum')->get('/candidatos', [CandidatoController::class,'index']);
Route::middleware('auth:sanctum')->post('/candidatos/destroyer', [CandidatoController::class,'deletarCandidaturas']);
Route::middleware('auth:sanctum')->get('/candidatos/download/zip/doc', [CandidatoController::class, 'downloadAllDocs']);


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
