<?php

use App\Http\Controllers\AssociadoController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [SiteController::class, 'home']);
Route::get('apresentacao', [SiteController::class, 'apresentacao'])->name('apresentacao');
Route::get('estruturaOrganica', [SiteController::class, 'estruturaOrganica'])->name('estruturaOrganica');
Route::get('mensagemPresidente', [SiteController::class, 'mensagemPresidente'])->name('mensagemPresidente');
Route::get('contactos', [SiteController::class, 'contactos'])->name('contactos');
Route::get('perguntasFrequentes', [SiteController::class, 'perguntasFrequentes'])->name('perguntasFrequentes');
Route::get('missaoValor', [SiteController::class, 'missaoValor'])->name('missaoValor');


Route::group(['middleware' => ['auth']], function () {
    Route::post('gestor/associado/new/add', [AssociadoController::class, 'addAssociado']);
    Route::post('gestor/utilizador/new/add', [UserController::class, 'createAccountUser']);
});
