<?php $__env->startSection('title', 'Notificações'); ?>

<?php $__env->startSection('subtitle','Update'); ?>

<?php $__env->startSection('conteudo'); ?>
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin')); ?>">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Entidade</span></li>
                    <li><span>App-Notification</span></li>
                    <li><span>Views</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        <?php if($errors->any()): ?>
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '<?php echo e(session('success')); ?>',
                    confirmButtonText: 'Fechar'
                })
            </script>
        <?php endif; ?>

        <div class="row" style="padding-top: 80px;">
            <form action="<?php echo e(route('sys-notificacoes.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                
                            </div>
                            <h2 class="card-title">Configurações de Notificações</h2>
                            
                        </header>

                        <div class="card-body">
                            <div class="row">
                                <!-- Coluna dos Inputs -->
                                <div class="col-md-6">
                                    <label for="estado" class="form-label">Notificar Por</label>
                                    <select class="form-control"  id="estado" name="tipo" required>
                                        <option value="" disabled <?php echo e(old('tipo', $notificacao->tipo) == null ? 'selected' : ''); ?>>Selecione a forma de notificação</option>
                                        <option value="2" <?php echo e(old('tipo', $notificacao->tipo == 2)  ? 'selected' : ''); ?>>Emails</option>
                                        <option value="1" <?php echo e(old('tipo', $notificacao->tipo == 1)  ? 'selected' : ''); ?>>Mensagens</option>
                                        
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label" for="numero-mecanografico-input">Descrição</label>
                                    <input type="text" class="form-control"
                                        placeholder="Informe a descricao" name="descricao" value="<?php echo e($notificacao->descricao ?? old('descricao')); ?>" >
                                    <div class="invalid-feedback">Por favor, preencha o cargo</div>
                                </div>

                                <span class="mt-4" style="color: red">Nota: Aqui, Configura-se o metodo de notificação que será utilizado pelo sistema, por Padrão o Sistema utilizará o Serviço de mensagens</span>
                                                           
                            </div>
                        </div>

                        <footer class="card-footer text-end">
                            
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/admin/configuracoes/entidade/appNotification/create.blade.php ENDPATH**/ ?>