<?php $__env->startSection('title', 'Sobre'); ?>
<?php $__env->startSection('subtitle','Configurações'); ?>

<?php $__env->startSection('conteudo'); ?>
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Dashboard</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="<?php echo e(route('admin')); ?>">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Sobre</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    
    <?php if($errors->any()): ?>
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `<ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($error); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>`,
                confirmButtonText: 'Fechar'
            });
        </script>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <script>
            Swal.fire({
                title: 'Sucesso',
                icon:'success',
                text: '<?php echo e(session('success')); ?>',
                confirmButtonText: 'Fechar'
            })
        </script>
    <?php endif; ?>

    
    <div style="padding-top: 80px;">
        <form action="<?php echo e(route('sobre.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">Informações da Seção "Sobre"</h2>
                        </header>
                        <div class="card-body">
                            <div class="col-lg-12">
                                <label for="estado" class="form-label">Estado</label>
                                <select class="form-select" id="estado" name="estado" required>
                                    <option value="1" <?php echo e($dado->estado ? 'selected' : ''); ?>>Activo</option>
                                    <option value="0" <?php echo e(!$dado->estado ? 'selected' : ''); ?>>Inativo</option>
                                </select>
                            </div>  
                            <hr>
                            <div class="form-group">
                                <h3 for="sobre">Conteúdo da Seção Sobre</h3>
                                <textarea name="conteudo" id="sobre" class="form-control" rows="15"><?php echo e(old('sobre', $dado->conteudo ?? '')); ?></textarea>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <button class="btn btn-warning">Salvar</button>
                        </footer>
                    </section>
                </div>
            </div>
        </form>
    </div>
</section>


<script src="<?php echo e(asset('tinymceEditor/js/tinymce/tinymce.min.js')); ?>"></script>
<script>
    tinymce.init({
        selector: 'textarea#sobre',
        height: 400,
        menubar: true,
        license_key: 'gpl',
        plugins: 'advlist autolink lists link charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime table wordcount',
        toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | preview',
        branding: false,

        content_style: `
            body {
                font-family: Arial, sans-serif;
                font-size: 16px;
                line-height: 1.4;
                color: #333;
            }

            p {
                margin: 0 0 7px 0;
            }

            ul, ol {
                color: #333;
                margin: 0 0 10px 20px;
            }

            li {
                color: black;
                margin-bottom: 5px;
            }
        `
        
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/admin/configuracoes/sobre/index.blade.php ENDPATH**/ ?>