<?php $__env->startSection('title', 'Bunner'); ?>

<?php $__env->startSection('subtitle', 'Editar'); ?>

<?php $__env->startSection('conteudo'); ?>
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Editar Item do Bunner</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="<?php echo e(route('admin')); ?>">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Entidade</span></li>
                <li><span>Visual</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <?php if($errors->any()): ?>
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    <?php endif; ?>

    <div class="row" style="padding-top: 80px;">
        <form action="<?php echo e(route('bunner.update', encrypt($bunner->id))); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Item do Bunner</h2>
                    </header>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex justify-content-center">
                                <div class="row">
                                    <span>Imagem </span>
                                    <label for="imageUpload" class="cursor-pointer" title="Clique para escolher a imagem">
                                        <div class="position-relative">
                                            <!-- Preview da imagem -->
                                            <img id="imagePreview" 
                                                src="<?php echo e($bunner->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunner->imagem) : asset('admin/img/logo.png')); ?>" 
                                                class=" border border-3 m-1" 
                                            
                                                style="width: 300px; height: 200px; object-fit: fill;" 
                                                alt="imagem">
                                        </div>
                                        <!-- Botão de seleção -->
                                    </label>
                                    <input type="file" id="imageUpload" value="<?php echo e($bunner->imagem); ?>" accept="image/jpeg,image/jpg,image/png" name="imagem" class="form-control d-none" onchange="previewImage(event)">
                                    
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <label for="titulo" class="form-label">Titulo</label>
                                        <input type="text" class="form-control" id="nome" maxlength="200" name="titulo" value="<?php echo e($bunner->titulo); ?>" placeholder="Digite o nome">
                                        <small id="counterTitulo" class="form-text text-muted mt-1">0 / 200 caracteres</small> 
                                    </div>        

                                    <div class="col-md-4">
                                        <label>Cor do titulo</label>
                                        <div class="d-flex align-items-center gap-2">
                                            <input type="color" id="cor_id" name="cor" class="form-control form-control-color">
                                            <div id="preview_cor" style="width: 40px; height: 40px; border-radius: 5px; border: 1px solid #ccc; background-color: <?php echo e($bunner->cor_titulo); ?>;"></div>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                            <label for="fixo" class="form-label">Imagem Fixa? </label>
                                            <select class="form-select" id="fixo" name="fixo" required>
                                                <option value="1" <?php echo e($bunner->isFixo ? 'selected' : ''); ?>>Sim</option>
                                                <option value="0" <?php echo e(!$bunner->isFixo ? 'selected' : ''); ?>>Não</option>
                                            </select>
                                        </div>

                                    <div class="col-lg-4">
                                        <label for="estado" class="form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="1" <?php echo e($bunner->estado ? 'selected' : ''); ?>>Activo</option>
                                            <option value="0" <?php echo e(!$bunner->estado ? 'selected' : ''); ?>>Inativo</option>
                                        </select>
                                    </div>  
                                    
                                </div>
                            </div>
                        </div>
                    </div>

                    <footer class="card-footer text-end">
                        <a href="<?php echo e(route('bunner.index')); ?>" class="btn btn-dark">Voltar</a>
                        <button class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="<?php echo e(asset("admin/js/Validacao/bunner.js")); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/admin/configuracoes/entidade/bunner/edit.blade.php ENDPATH**/ ?>