<?php $__env->startSection('title', 'Cargos'); ?>

<?php $__env->startSection('subtitle','Listagem'); ?>

<?php $__env->startSection('conteudo'); ?>
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin')); ?>">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Cargos</span></li>
                    <li><span>Listagem</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        
        <?php if(session('success')): ?>
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '<?php echo e(session('success')); ?>',
                    confirmButtonText: 'Fechar'
                })
            </script>
        <?php endif; ?>

        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            
                        </div>
                        <h2 class="card-title">Listagem de Cargos</h2>
                    </header>
                    <div class="card-body">
                        
                        <table class="table table-bordered table-striped mb-0" id="datatable-tabletools">
                            <thead>
                                <a id="addToTable" href="<?php echo e(route('cargo.create')); ?>" class="btn btn-dark">Adicionar Novo Cargo <i class="fas fa-plus"></i></a>
                                <tr>
                                    <th>#</th>
                                    <th>Nome </th>
                                    <th>Principal </th>
                                    <th>Estado</th>
                                    <th>Acção</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $cargos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cargo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td> <?php echo e($loop->index + 1); ?></td>
                                        <td><?php echo e($cargo->nome ?? ''); ?></td>
                                        <?php if($cargo->principal): ?>
                                            <td><span class="badge badge-success">Sim</span></td>
                                        <?php else: ?>
                                            <td><span class="badge badge-warning">Não</span></td>
                                        <?php endif; ?>
                                        <?php if($cargo->estado): ?>
                                            <td><span class="badge badge-success">Activo</span></td>
                                        <?php else: ?>
                                            <td><span class="badge badge-warning">Inativo</span></td>
                                        <?php endif; ?>
                                        <td class="actions">
                                            <a href="<?php echo e(route('cargo.show', encrypt($cargo->id))); ?>"><i class="fa-solid fa-eye"></i></a>
                                            <a href="<?php echo e(route('cargo.edit', encrypt($cargo->id))); ?>"><i class="fas fa-pencil-alt"></i></a>
                                            <?php if(!Gate::allows('isEditor')): ?>
                                                <a class="mb-1 mt-1 me-1 modal-basic" href="#modalEliminar<?php echo e($cargo->id); ?>"><i class="far fa-trash-alt"></i></a>
                                            <?php endif; ?>
                                        </td>


                                        <div id="modalEliminar<?php echo e($cargo->id); ?>" class="modal-block modal-block-danger mfp-hide">
                                            <section class="card">
                                                <header class="card-header">
                                                    <h2 class="card-title">AVISO!</h2>
                                                </header>
                                                <div class="card-body">
                                                    <div class="modal-wrapper">
                                                        <div class="modal-icon">
                                                            <i class="fas fa-times-circle"></i>
                                                        </div>
                                                        <div class="modal-text">
                                                            <h4 class="font-weight-bold text-dark">AVISO</h4>
                                                            <p>Deseja realmente eliminar este Cargo?</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <form action="<?php echo e(route('cargo.destroy', encrypt($cargo->id))); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <footer class="card-footer">
                                                        <div class="row">
                                                            <div class="col-md-12 text-end">
                                                                <button class="btn btn-primary modal-dismiss">Cancelar </button>
                                                                <button type="submit" class="btn btn-danger">Sim, Elimine-o</button>
                                                            </div>
                                                        </div>
                                                    </footer>
                                                </form>
                                            </section>
                                        </div>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>

        <!-- end: page -->
    </section>
<?php $__env->stopSection(); ?>

    

<?php $__env->startSection('javascript'); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/admin/configuracoes/cargo/index.blade.php ENDPATH**/ ?>