<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Associado;
use Usoko\SIGBundle\Entity\PessoaDocumento;
use Usoko\SIGBundle\Entity\Documentoidentificacao;
use Usoko\SIGBundle\Form\AssociadoType;
use Usoko\SIGBundle\General\DataGeneral;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\UploadGeneral;
use Usoko\SIGBundle\Entity\Pessoa;
use Usoko\SIGBundle\Entity\HistoricoImport;
use Usoko\SIGBundle\Entity\Orgao;
use Usoko\SIGBundle\Entity\Cargo;
use Usoko\SIGBundle\Entity\Profissao;
use Usoko\SIGBundle\General\Validacao;
use Symfony\Component\HttpFoundation\Response;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\NumeroReal;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Associado controller.
 *
 */
class AssociadoController extends Controller {

    /**
     * Lists all Associado entities.
     *
     */
    public function indexAction($cod, Request $request) {
        $em = $this->getDoctrine()->getManager();
        
       
        if ($cod == 'N') {
            $query = $em->createQuery("
        SELECT a FROM UsokoSIGBundle:Associado a,
        UsokoSIGBundle:Pessoa p
        WHERE a.pessoa=p.id
        AND a.tipo=BT
          ORDER BY p.nome"
            );
            $entities = $query->getResult();
        } else {
            $query = $em->createQuery("
        SELECT a FROM UsokoSIGBundle:Associado a,
        UsokoSIGBundle:Pessoa p
        WHERE a.pessoa=p.id
          ORDER BY p.nome"
            );
            //die($query->getResult());
            $entities = $query->getResult();
        }


        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Associado:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
                    'tipo' => $cod,
        ));
    }

    public function indexActionknp($cod) {
        $em = $this->getDoctrine()->getManager();

        if ($cod == 'N') {
            $entities = $em->getRepository('UsokoSIGBundle:Associado')->findBy(array('tipo' => 'BT'), array('nMecanografico' => 'ASC'));
        } else {
            $entities = $em->getRepository('UsokoSIGBundle:Associado')->findBy(array(), array('nMecanografico' => 'ASC'));
        }


        return $this->render('UsokoSIGBundle:Associado:index.html.twig', array(
                    'entities' => $entities,
                    'tipo' => $cod,
        ));
    }

    public function index2Action($cod) {
        $em = $this->getDoctrine()->getManager();

        if ($cod == 'AT') {
            $entities = $em->getRepository('UsokoSIGBundle:Associado')->findBy(array('tipo' => 'BT'));
        } else {
            $entities = $em->getRepository('UsokoSIGBundle:Associado')->findAll();
        }

        return $this->render('UsokoSIGBundle:Associado:Atendente/index.html.twig', array(
                    'entities' => $entities,
                    'tipo' => $cod,
        ));
    }

    /**
     * Creates a new Associado entity.
     *
     */
    public function createAction(Request $request) {
        $salario = $this->salario($request);

        $entity = new Associado();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if (Validacao::validar($this, $entity)) {
            $entity->setSalario($salario);
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();

            $entity->getConta()->setTipo(VarsGeneral::CONS_CONTABAN_TIPO_ASSO);
            $entity->getPessoa()->setTipo(VarsGeneral::CONS_PESSOA_TIPO_ASSOCIADO);
            $temp_fotoPessoa = $entity->getPessoa()->getFoto();
            $entity->getPessoa()->setFoto(null);

            $temp_anexoAss = $entity->getAnexo();
            $entity->setAnexo(null);
            $entity->setDataAssociacao(DataGeneral::tempoGeral());
            $entity->setSalario((double) $this->valor($request));
            $entity->setImportado('N');

            $em->persist($entity);
            $em->flush();

// uploads
            if ($temp_fotoPessoa) {
                $file_name = md5($entity->getPessoa()->getId()) . VarsGeneral::CONS_UPLOAD_EXTENCTION;
                $answer = UploadGeneral::upload($temp_fotoPessoa, VarsGeneral::CONS_UPLOAD_ASSOCIADO_FOTO, $file_name);
                $entity->getPessoa()->setFoto($file_name);
            }
            if ($temp_anexoAss) {
                $file_name = md5($entity->getId()) . VarsGeneral::CONS_UPLOAD_EXTENCTION;
                $answer = UploadGeneral::upload($temp_anexoAss, VarsGeneral::CONS_UPLOAD_ASSOCIADO_ANEXO, $file_name);
                $entity->setAnexo($file_name);
            }

            $em->flush();   // update

            AuditoriaGeneral::auditar($this, $em, $entity, "Associado", "I", "Registo de Um Novo Associado");
            $em->getConnection()->commit();

            $id = $this->get('nzo_url_encryptor')->encrypt($entity->getId());
            return $this->redirect($this->generateUrl('home_atendente', array('id' => $id)));
        }

        $erros = Validacao::validar($this, $entity, false);
        $msgs = '';
        $msgDocError = "";
        $message = "";
        $cont = 0;
        foreach ($erros as $erro) {
            $cont++;
            $message .= $cont . 'º ' . $erro->getMessage() . '  |  ';

//            if ($erro->getCode() === 27) {
//                $msgDocError = VarsGeneral::MESSAGE_DOC_ERROR;
//                break;
//            }
        }
        if ($message != "") {
            $msgs = $this->get('nzo_url_encryptor')->encrypt($message);
        }

        return $this->render('UsokoSIGBundle:Associado:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
                    'msg' => $msgDocError,
                    'msgs' => $msgs
        ));
    }

    /**
     * Creates a form to create a Associado entity.
     *
     * @param Associado $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Associado $entity) {
        $form = $this->createForm(new AssociadoType(), $entity, array(
            'action' => $this->generateUrl('associado_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new Associado entity.
     *
     */
    public function newAction() {

        $entity = new Associado();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Associado:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
                    'msg' => ''
        ));
    }

    /**
     * Finds and displays a Associado entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Associado:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Associado entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $editForm = $this->createEditForm($entity);

        $deleteForm = $this->createDeleteForm($id);
// UsokoSIGBundle:Associado:perfil_use_AD.html.twig
// UsokoSIGBundle:Associado:edit.html.twig

        $action = $this->generateUrl('associado_update', array('id' => $entity->getId()));
        return $this->render('UsokoSIGBundle:Associado:editN.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
                    'action' => $action
        ));
    }

    /**
     * Creates a form to edit a Associado entity.
     *
     * @param Associado $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Associado $entity) {
        $form = $this->createForm(new AssociadoType(), $entity, array(
            'action' => $this->generateUrl('associado_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing Associado entity.
     *
     */
         public function updateAction(Request $request, $id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();

        $entity = new Associado();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity. ' . $id);
        }

        $entity->setAnexo(null);
        $entity->getPessoa()->setFoto(null);

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        $post = $request->request->get('usoko_sigbundle_associado');

//        print_r($post);
        //die(print_r($post));
        $pessoa = $entity->getPessoa();
        $pessoa->setNome($post['pessoa']['nome']);
        $pessoa->setGenero($post['pessoa']['genero']);
        $pessoa->setEstadoCivil($post['pessoa']['estadoCivil']);
        $pessoa->setDataNascimento(DataGeneral::dateForDatabase($post['pessoa']['dataNascimento']));

        if (isset($pessoa->getDocumentoidentificacao()[0])) {
            $documentoidentificacao = $pessoa->getDocumentoidentificacao()[0];
            $documentoidentificacao->setNumero($post['pessoa']['documentoidentificacao'][0]['numero']);
            $documentoidentificacao->setLocalEmissao($post['pessoa']['documentoidentificacao'][0]['localEmissao']);
            $tipodocumento = $em->getRepository('UsokoSIGBundle:Tipodocumento')->find($post['pessoa']['documentoidentificacao'][0]['tipodocumento']);
            $documentoidentificacao->setTipodocumento($tipodocumento);
            $documentoidentificacao->setDataEmissao(DataGeneral::dateForDatabase($post['pessoa']['documentoidentificacao'][0]['dataEmissao']));
            $documentoidentificacao->setDataExpiracao(DataGeneral::dateForDatabase($post['pessoa']['documentoidentificacao'][0]['dataExpiracao']));
        }

        //Contacto
        if (isset($pessoa->getContacto()[0])) {
            $cont = 0;
            foreach ($pessoa->getContacto() as $contacto):
                $contacto->setNome($post['pessoa']['contacto'][$cont]['nome']);
                $tipocontacto = $em->getRepository('UsokoSIGBundle:Tipocontacto')->find($post['pessoa']['contacto'][$cont]['tipocontacto']);
                $contacto->setTipocontacto($tipocontacto);
                $cont++;
            endforeach;
        }

        if (isset($pessoa->getEndereco()[0])) {
            $pessoa->getEndereco()[0]->setBairro($post['pessoa']['endereco'][0]['bairro']);
            $pessoa->getEndereco()[0]->setRua($post['pessoa']['endereco'][0]['rua']);
            $pessoa->getEndereco()[0]->setNumero($post['pessoa']['endereco'][0]['numero']);
        }
//falta Dados do contacto


        $entity->setPessoa($pessoa);

        //Dados do asscociado
        $entity->setNumero((isset($post['numero'])) ? $post['numero'] : $entity->getNumero() );
        $entity->setNMecanografico($post['nMecanografico']);
  
        $patente = $em->getRepository('UsokoSIGBundle:Patente')->find($post['patente']);
        $orgao = $em->getRepository('UsokoSIGBundle:Orgao')->find($post['orgao']);
        $cargo = $em->getRepository('UsokoSIGBundle:Cargo')->find($post['cargo']);
        $profissao = $em->getRepository('UsokoSIGBundle:Profissao')->find($post['profissao']);
        $entity->setPatente($patente);
        $entity->setOrgao($orgao);
        $entity->setCargo($cargo);
        $entity->setProfissao($profissao);
        $entity->setSalario($post['salario']);
        $entity->setStatus($post['status']);

        //Conta
        if (isset($post['conta'])) {
            $contaAnterior = $entity->getConta();
            $conta = $post['conta'];
            $contaAnterior->setNumero($conta['numero']);
            $contaAnterior->setIban($conta['iban']);
            $bancoInstituicao = $em->getRepository('UsokoSIGBundle:BancoInstituicao')->find($conta['bancoInstituicao']);
            $contaAnterior->setBancoInstituicao($bancoInstituicao);
            $entity->setConta($contaAnterior);
        }

        $entity->setDataAdmissao(DataGeneral::dateForDatabase($post['dataAdmissao']));


        if (Validacao::validar($this, $entity)) {

            $em->getConnection()->beginTransaction();

            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Associado", "U", "Actualização de Um Associado");
            $em->getConnection()->commit();

            $id = $this->get('nzo_url_encryptor')->encrypt($id);
            return $this->redirect($this->generateUrl('perfil_associado', array('id' => $id)));
        }

        $erros = Validacao::validar($this, $entity, false);
        $msgs = '';
        $message = "";
        $cont = 0;
        foreach ($erros as $erro) {
            $cont++;
            $message .= $cont . 'º ' . $erro->getMessage() . '  |  ';
        }
        if ($message != "") {
            $msgs = $this->get('nzo_url_encryptor')->encrypt($message);
        }

        $id = $this->get('nzo_url_encryptor')->encrypt($id);
        $action = $this->generateUrl('associado_update', array('id' => $id));
        return $this->render('UsokoSIGBundle:Associado:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
                    'action' => $action,
                    'msgs' => $msgs
        ));
    }
    public function updateAntesAction(Request $request, $id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();

        $entity = new Associado();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity. ' . $id);
        }

        $entity->setAnexo(null);
        $entity->getPessoa()->setFoto(null);

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        $post = $request->request->get('usoko_sigbundle_associado');

//        print_r($post);
//        die;
        $pessoa = $entity->getPessoa();
        $pessoa->setNome($post['pessoa']['nome']);
        $pessoa->setGenero($post['pessoa']['genero']);
        $pessoa->setEstadoCivil($post['pessoa']['estadoCivil']);
        //$dataNas = DataGeneral::date2Datetime($post['pessoa']['dataNascimento']);
        //$pessoa->setDataNascimento($dataNas);

        if (isset($pessoa->getDocumentoidentificacao()[0])) {
            $pessoa->getDocumentoidentificacao()[0]->setNumero($post['pessoa']['documentoidentificacao'][0]['numero']);
            $pessoa->getDocumentoidentificacao()[0]->setLocalEmissao($post['pessoa']['documentoidentificacao'][0]['localEmissao']);
        }

        if (isset($pessoa->getEndereco()[0])) {
            $pessoa->getEndereco()[0]->setBairro($post['pessoa']['endereco'][0]['bairro']);
            $pessoa->getEndereco()[0]->setRua($post['pessoa']['endereco'][0]['rua']);
            $pessoa->getEndereco()[0]->setNumero($post['pessoa']['endereco'][0]['numero']);
        }

        $entity->setPessoa($pessoa);
        $entity->setNumero((isset($post['numero'])) ? $post['numero'] : $entity->getNumero() );
        $entity->setSalario($post['salario']);
        $entity->setNMecanografico($post['nMecanografico']);
        //$entity->setDataAdmissao($post['dataAdmissao']);
        // contacto
        // conta

        if (Validacao::validar($this, $entity)) {

            $em->getConnection()->beginTransaction();

            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Associado", "U", "Actualização de Um Associado");
            $em->getConnection()->commit();

            $id = $this->get('nzo_url_encryptor')->encrypt($id);
            return $this->redirect($this->generateUrl('perfil_associado', array('id' => $id)));
        }

        $erros = Validacao::validar($this, $entity, false);
        $msgs = '';
        $message = "";
        $cont = 0;
        foreach ($erros as $erro) {
            $cont++;
            $message .= $cont . 'º ' . $erro->getMessage() . '  |  ';
        }
        if ($message != "") {
            $msgs = $this->get('nzo_url_encryptor')->encrypt($message);
        }

        $id = $this->get('nzo_url_encryptor')->encrypt($id);
        $action = $this->generateUrl('associado_update', array('id' => $id));
        return $this->render('UsokoSIGBundle:Associado:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
                    'action' => $action,
                    'msgs' => $msgs
        ));
    }

    /**
     * Deletes a Associado entity.
     *
     */
    public function deleteAction($id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity. ' . $id);
        }
        $em->getConnection()->beginTransaction();
        AuditoriaGeneral::auditar($this, $em, $entity, "Associado", "D", "Remoção de Um Associado");

        try {
            $em->remove($entity);
            $em->flush();
        } catch (\Doctrine\DBAL\DBALException $e) {
            $em->getConnection()->rollback();
            return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
        }

        $em->getConnection()->commit();
        return $this->redirect($this->generateUrl('associado'));
    }

    /**
     * Creates a form to delete a Associado entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('associado_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    public function graficoAction() {
        $estatistica = array();
        $em = $this->getDoctrine()->getManager();
        //$entities = $em->getRepository('UsokoSIGBundle:Associado')->findAll();

        //$total = count($entities);
        //estatistica do estado civil
        $t_solteiro = 0;
        $t_casado = 0;
        $t_divorsiado = 0;
        $t_viuvo = 0;
        
        //total dos associados por genero
        $t_masc = 0;
        $t_fem = 0;
        
        //total por estado dos associados
        $t_activo = 0;
        $t_inactivo = 0;
        $t_desvinculado = 0;
        $t_reformado = 0;
        $t_falecido = 0;
        $t_adido = 0;
        //Nºao faz a consulta aqui , cria um metodo no repositorio isso cria problema de performace 
//        $entity = new Associado();
//        foreach ($entities as $entity) {
//            $genero = $entity->getPessoa()->getGenero();
//            if ($genero == 'M') {
//                $t_masc++;
//            } else {
//                $t_fem++;
//            }
//        }

 $t_nenhum = 0;
        $t_BEDT = 0;
        $t_cpl = 0;
        $t_cpn = 0;
        $t_cdudpm = 0;
        $t_coe = 0;
        
        
        //Nºao faz a consulta aqui , cria um metodo no repositorio isso cria problema de performace 
//        $entity = new Associado();
//        foreach ($entities as $entity) {
//            $genero = $entity->getPessoa()->getGenero();
//            if ($genero == 'M') {
//                $t_masc++;
//            } else {
//                $t_fem++;
//            }
//        }

        $grafico['t_nenhum'] =100;

        $grafico['total'] =100;
        $grafico['t_masc'] = 5;
        $grafico['t_fem'] = 10;
        
        $grafico['t_solt'] = 15;
        $grafico['t_casado'] = 20;
        $grafico['t_uniaofacto'] = 12;
        $grafico['t_divorsiado'] = 25;
        $grafico['t_viuvo'] = 12;
        
        
        $grafico['t_activo'] = 12;
        $grafico['t_inactivo'] = 12;
        $grafico['t_desvinculado'] = 12;
        $grafico['t_reformado'] = 12;
        $grafico['t_falecido'] = 12;
        $grafico['t_adido'] = 12;
        

        
    
    
        

        print_r(json_encode($grafico));
//        die;
//        return new JsonResponse($estatistica);
        
        return $this->render('UsokoSIGBundle:Associado:homeGestor.html.twig', array(
                    'genero' => $entities , 't_masc' => $grafico['t_masc']           
        ));
    }

    public function isValidoIban($iban) {
        $iban = trim($iban);
        return (substr($iban, 0, 4) == "AO06" && strlen($iban) == 25);
    }

    private $em = null;

    public function excelAction(Request $request) {

        if (!isset($_FILES['ficheiro'])) {
            echo "Nenhum Ficheiro de Importação foi Identificado!";
            return;
        }

        $incluiBen = $request->get('beneficiarios');
        $ficheiro = $_FILES['ficheiro'];

        $inputFileType = 'Excel2007';
        $inputFileName = $ficheiro['tmp_name']; // '../web/uploads/example1.xlsx';

        /**  Create a new Reader of the type defined in $inputFileType  * */
        $objReader = \PHPExcel_IOFactory::createReader($inputFileType);
        /**  Load $inputFileName to a PHPExcel Object  * */
        $objPHPExcel = $objReader->load($inputFileName);

        $dados = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);

        $i = 0;

        $this->em = $this->getDoctrine()->getManager();
        $contactoT = $this->em->getRepository('UsokoSIGBundle:Tipocontacto')->find(1);

        $total_novos = 0;
        $total_actualizados = 0;
        $conflito_id = 0;
        $conflito_dt = 0;
        $erros_iban = 0;

        $arr_conflito_id = array();
        $arr_conflito_dt = array();
        $arr_erros_iban = array();

        foreach ($dados as $d) {
            if ($i) {
                $this->posActual = 0;
                $numMecanog = $d[$this->getPosicaoProxima()]; //$d['A'];
                if ($numMecanog == "") {
                    continue;
                }
                $numAssociado = $d[$this->getPosicaoProxima()];

                $nome = $d[$this->getPosicaoProxima()]; //$d['B'];
                $genero = $d[$this->getPosicaoProxima()]; //$d['C'];
                $estadoCivil = $d[$this->getPosicaoProxima()]; //$d['D'];
                $estado = $d[$this->getPosicaoProxima()]; //$d['E'];
                $dtNasc = DataGeneral::dtUSPT($d[$this->getPosicaoProxima()]); //DataGeneral::dtUSPT($d['F']);
                $docID_tipo = $d[$this->getPosicaoProxima()]; //$d['G'];
                $docID_num = $d[$this->getPosicaoProxima()]; //$d['H'];

                $docID_dtEmissao = $d[$this->getPosicaoProxima()];
                $docID_dtEmissao = isset($docID_dtEmissao) ? DataGeneral::dtUSPT($docID_dtEmissao) : new \DateTime(); //Verificar se está setado antes

                $docID_dtExpiracao = $d[$this->getPosicaoProxima()];
                $docID_dtExpiracao = isset($docID_dtExpiracao) ? DataGeneral::dtUSPT($docID_dtExpiracao) : new \DateTime(); //Verificar se está setado antes

                $docID_dtLocalEmissao = $d[$this->getPosicaoProxima()];
                $docID_dtLocalEmissao = isset($docID_dtLocalEmissao) ? $docID_dtLocalEmissao : 'DESCONHECIDO';
                //Verificar se está setado antes


                $telefone = $d[$this->getPosicaoProxima()]; //$d['I'];
                $orgao_nome = $d[$this->getPosicaoProxima()]; //$d['J'];
                $cargo_nome = $d[$this->getPosicaoProxima()]; // $d['K'];
                $profissao_nome = $d[$this->getPosicaoProxima()]; // $d['K'];
                $salarioBase = $d[$this->getPosicaoProxima()]; //$d['L'];
                $dtAdmiss = DataGeneral::dtUSPT($d[$this->getPosicaoProxima()]); //DataGeneral::dtUSPT($d['M']);
                $dtAssoc = DataGeneral::dtUSPT($d[$this->getPosicaoProxima()]); //DataGeneral::dtUSPT($d['N']);

                $endereco_nome = $d[$this->getPosicaoProxima()]; //$d['O'];
                $banco_nome = $d[$this->getPosicaoProxima()]; //$d['P'];
                $iban = $d[$this->getPosicaoProxima()]; //$d['Q'];
                $num_conta = $d[$this->getPosicaoProxima()]; //$d['R'];

                $total_quotas = $d[$this->getPosicaoProxima()]; //$d['R'];
                //echo "<br/>$numMecanog - $numAssociado - $nome - $genero - $estadoCivil - $estado - $dtNasc - $docID_tipo - $docID_num - $telefone - $orgao_nome - $cargo_nome - $salarioBase - $dtAdmiss - $dtAssoc - $endereco_nome - $banco_nome - $iban - $num_conta - $total_quotas";
                //$this->em->getConnection()->beginTransaction();

                $profissao = $this->em->getRepository("UsokoSIGBundle:Profissao")->findOneByNome($profissao_nome);
                if (!$profissao) {
                    $profissao = new Profissao();
                    $profissao->setNome($profissao_nome);
                    $this->em->persist($profissao);
                }

                $orgao = $this->em->getRepository('UsokoSIGBundle:Orgao')->findOneByNome($orgao_nome);
                if (!$orgao) {
                    $orgao = new Orgao();
                    $orgao->setNome($orgao_nome);
                    $this->em->persist($orgao);
                }

                $cargo = $this->em->getRepository('UsokoSIGBundle:Cargo')->findOneByCargo($cargo_nome);

                if (!$cargo) {
                    $cargo = new Cargo();
                    $cargo->setCargo($cargo_nome);
                    $this->em->persist($cargo);
                }



                $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_OUTO_ID;
                switch (substr(strtoupper($docID_tipo), 0, 1)) {
                    case VarsGeneral::CONS_TIPO_DOCUMENTO_ID_BILHETE_IDENTIDADE:
                        $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_BILHETE_IDENTIDADE_ID;
                        break;
                    case VarsGeneral::CONS_TIPO_DOCUMENTO_ID_PASSAPORTE:
                        $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_PASSAPORTE_ID;
                        break;
                    case VarsGeneral::CONS_TIPO_DOCUMENTO_ID_CEDULA_PESSOAL:
                        $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_CEDULA_PESSOAL_ID;
                        break;
                }
                $docIDT = $this->em->getRepository('UsokoSIGBundle:Tipodocumento')->find($docIDT_ID);

                $tm = new \DateTime('now');
                $tm = $tm->format('d/m/Y H:i:s');

                if (!$docIDT) {
                    $docIDT = new \Usoko\SIGBundle\Entity\Tipodocumento();
                    $docIDT->setTipo($docID_tipo)
                            ->setDescricao("AUTO_IMPORT_$tm");
                    $this->em->persist($docIDT);
                }

                $banco = $this->em->getRepository('UsokoSIGBundle:BancoInstituicao')->findOneBySigla($banco_nome);
                if (!$banco) {
                    $banco = new \Usoko\SIGBundle\Entity\BancoInstituicao();
                    $banco
                            ->setSigla($banco_nome)
                            ->setNome("AUTO_IMPORT_$banco_nome")
                    ;
                    $this->em->persist($banco);
                }
                $this->em->flush();


                $docID = new \Usoko\SIGBundle\Entity\Documentoidentificacao();
                $docID->setTipodocumento($docIDT)
                        ->setNumero($docID_num)
                        ->setDataEmissao((new \DateTime($docID_dtEmissao)))
                        ->setDataExpiracao((new \DateTime($docID_dtExpiracao)))
                        ->setLocalEmissao($docID_dtLocalEmissao)
                ;

                $contacto = new \Usoko\SIGBundle\Entity\Contacto();
                $contacto->setNome($telefone)
                        ->setTipocontacto($contactoT);

                $provincia = $this->em->getRepository("UsokoSIGBundle:Provincia")->find(4);
                $municipio = $this->em->getRepository("UsokoSIGBundle:Municipio")->find(4);

                if (!$provincia || !$municipio) {
                    echo 'Erro de Importação. Configuração de Endereço Inválido. Contacte o Administrador';
                    die;
                }

                $endereco = new \Usoko\SIGBundle\Entity\Endereco();
                $endereco->setMunicipio($municipio)
                        ->setProvincia($provincia)
                        ->setDescricao($endereco_nome)
                        ->setBairro("DESCONHECIDO")
                        ->setRua("DESCONHECIDO")
                        ->setNumero("DESCONHECIDO")
                ;


                $pessoa = new Pessoa();
                $pessoa
                        ->setTipo(VarsGeneral::CONS_PESSOA_TIPO_ASSOCIADO)
                        ->setNome($nome)
                        ->setGenero($genero)
                        ->setEstadoCivil($estadoCivil)
                        ->setDataNascimento(new \DateTime($dtNasc))
                        ->addDocumentoidentificacao($docID)
                        ->addContacto($contacto)
                        ->addEndereco($endereco)
                ;

                $banco_conta = new \Usoko\SIGBundle\Entity\BancoConta();
                $banco_conta
                        ->setNumero($num_conta)
                        ->setIban($iban)
                        ->setTipo(\Usoko\SIGBundle\General\VarsGeneral::CONS_CONTABAN_TIPO_ASSO)
                        ->setBancoInstituicao($banco)
                ;

                $associado = new Associado();
                $associado
                        ->setNMecanografico($numMecanog)
                        ->setNumero($numAssociado)
                        ->setPessoa($pessoa)
                        ->setConta($banco_conta)
                        ->setSalario($salarioBase)
                        ->setOrgao($orgao)
                        ->setCargo($cargo)
                        ->setProfissao($profissao)
                        ->setDataAssociacao(new \DateTime($dtAssoc))
                        ->setDataAdmissao(new \DateTime($dtAdmiss))
                        ->setStatus($estado == '' ? 'A' : $estado)
                        ->setImportado('S');

                //INÍCIO: VALIDAÇÃO DO ASSOCIADO
                $errors = Validacao::validar($this, $associado, false);

                $total_novos++;
                $isConflito = false;
                $associado_tst = null;

                foreach ($errors as $erro) {
                    //echo '<br/>ERRO:';
                    $isConflito = false;
                    //Caso Haja Conflito de Identidade (Mecanográfico=> 27, NID => 28)
                    if ($erro->getCode() === 27) {
                        //echo 27;
                        $doc_tst = $this->em->getRepository('UsokoSIGBundle:Documentoidentificacao')->findOneBy(array('numero' => $docID_num, 'tipodocumento' => $docIDT));
                        if ($doc_tst) {

                            $pessoa_tst = $doc_tst->getPessoa()->first(); //$em->getRepository('UsokoSIGBundle:Pessoa')->findOneByDocumentoidentificacao($doc_tst);
                            if ($pessoa_tst) {

                                $associado_tst = $this->em->getRepository('UsokoSIGBundle:Associado')->findOneByPessoa($pessoa_tst);
                            }
                        }
                    } elseif ($erro->getCode() === 28) {
                        //echo 28;
                        $associado_tst = $this->em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('nMecanografico' => $associado->getNMecanografico()));
                    } else {
                        // echo 'Erro: ' . $erro->getCode() . ' - ' . $erro->getMessage();
                        continue; //ignora os outros erros. Ex.: Nome com Caracteres Especiais
                    }

                    if (!$associado_tst) {
                        //Número Mecanográfico não é o mesmo::Houve Conflito de Identidade
                        $conflito_id++;
                        array_push($arr_conflito_id, $associado);

                        $isConflito = true;
                        // echo "<br/>Conflito de Identidade";
                        //Não precisa analisar outros erros
                    } else {
                        //Mesma Pessoa::Actualiza os dados
                        $pessoa = $associado_tst->getPessoa();
                        $pessoa->removeContacto($contacto);

                        $contactos = $pessoa->getContacto();
                        foreach ($contactos as $c) {
                            if ($c->getTipocontacto() == $contactoT)
                                $contacto_ = $c;
                        }

                        $contacto
                                ->setTipocontacto($contacto_->getTipocontacto())
                                ->setNome($contacto_->getNome());

                        $pessoa
                                ->setEstadoCivil($estadoCivil)
                                ->addContacto($contacto)
                        ;

                        $associado = $associado_tst;
                        $total_actualizados++;
                        $total_novos--;
// echo "<br/>Registo Actualizado";
                    }
                    break;
                }

                if ($isConflito) {
                    $total_novos--;
                    continue;
                }

                $associado
                        ->setPessoa($pessoa)
                        ->setNumero($numAssociado)
                        ->setDataAssociacao(new \DateTime($dtAssoc))
                        ->setDataAdmissao(new \DateTime($dtAdmiss))
                        ->setConta($banco_conta)
                        ->setSalario($salarioBase)
                        ->setOrgao($orgao)
                        ->setCargo($cargo)
                        ->setProfissao($profissao)
                        ->setDataAssociacao(new \DateTime($dtAssoc))
                        ->setDataAdmissao(new \DateTime($dtAdmiss))
                        ->setImportado('S');

                if ($associado->getDataAdmissao()->format('Y-m-d') > date('Y-m-d') |
                        $associado->getDataAssociacao()->format('Y-m-d') > date('Y-m-d') |
                        $associado->getDataAssociacao()->format('Y-m-d') < $associado->getDataAdmissao()->format('Y-m-d')) {
                    $conflito_dt++;

                    if ($associado_tst)
                        $total_actualizados--;
                    else
                        $total_novos--;
                    array_push($arr_conflito_dt, $associado);
                    continue;
                }

                $this->em->persist($associado);
                $this->em->flush();
                //$this->em->getConnection()->commit();
//                //Tratamento de Dependentes
//                $this->em->beginTransaction();
                $this->registarHistorico($associado, $numAssociado, $total_quotas);

                $this->importarDependentes($d, $associado, $tm, $contactoT);


                $this->em->flush();
//                $this->em->getConnection()->commit();
            }
            $i++;
        }

        return $this->importacaoAction(array(
                    'accao' => $total_novos + $total_actualizados + $conflito_id + $conflito_dt,
                    'total_novos' => $total_novos,
                    'total_actualizados' => $total_actualizados,
                    'conflitos_id' => $conflito_id,
                    'conflitos_dt' => $conflito_dt,
                    'erros_iban' => $erros_iban,
                    'arr_conflitos_id' => $arr_conflito_id,
                    'arr_conflitos_dt' => $arr_conflito_dt,
                    'arr_erros_iban' => $arr_erros_iban
        ));
    }

    public function importarDependentes($d, $associado, $tm, $contactoT) {

        do {
            $pos_nome = $this->getPosicaoProxima();

            if (!isset($d[$pos_nome]))
                break;

            $ben_nome = $d[$pos_nome];

            $ben_genero = $d[$this->getPosicaoProxima()];
            $ben_dtNasc = DataGeneral::dtUSPT($d[$this->getPosicaoProxima()]);
            $ben_ID_tipo = $d[$this->getPosicaoProxima()];
            $ben_ID_num = $d[$this->getPosicaoProxima()];
            $ben_telefone = $d[$this->getPosicaoProxima()];
            $ben_percent = $d[$this->getPosicaoProxima()];
            $grauparentesco_nome = $d[$this->getPosicaoProxima()];
            $grauparentesco_nome = $grauparentesco_nome == '' ? 'OUTRO' : $grauparentesco_nome;

            $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_OUTO_ID;
            switch (substr(strtoupper($ben_ID_tipo), 0, 1)) {
                case VarsGeneral::CONS_TIPO_DOCUMENTO_ID_BILHETE_IDENTIDADE:
                    $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_BILHETE_IDENTIDADE_ID;
                    break;
                case VarsGeneral::CONS_TIPO_DOCUMENTO_ID_PASSAPORTE:
                    $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_PASSAPORTE_ID;
                    break;
                case VarsGeneral::CONS_TIPO_DOCUMENTO_ID_CEDULA_PESSOAL:
                    $docIDT_ID = VarsGeneral::CONS_TIPO_DOCUMENTO_ID_CEDULA_PESSOAL_ID;
                    break;
            }
            $docIDT = $this->em->getRepository('UsokoSIGBundle:Tipodocumento')->find($docIDT_ID);

            if (!$docIDT) {
                echo 'Não existe Tipo de Documento: ' . $docIDT_ID . ' Contactee o Administrador';
                die;
            }

            $grauparentesco = $this->em->getRepository('UsokoSIGBundle:Grauparentesco')->findOneByNome($grauparentesco_nome);
            if (!$grauparentesco) {
                $grauparentesco = new \Usoko\SIGBundle\Entity\Grauparentesco();
                $grauparentesco->setNome($grauparentesco_nome)
                        ->setDescricao('AUTO_IMPORT_' . $tm);
                $this->em->persist($grauparentesco);
            }


            $dep_docID = new \Usoko\SIGBundle\Entity\Documentoidentificacao();

            $dep_docID
                    ->setNumero($ben_ID_num)
                    ->setTipodocumento($docIDT)
                    ->setLocalEmissao("DESCONHECIDO")
                    ->setDataEmissao(new \DateTime())
                    ->setDataExpiracao(new \DateTime())
            ;

            $dep_contacto = new \Usoko\SIGBundle\Entity\Contacto();
            $dep_contacto
                    ->setNome($ben_telefone)
                    ->setTipocontacto($contactoT)
            ;
            $dep_pessoa = new Pessoa();
            $dep_pessoa
                    ->setNome($ben_nome)
                    ->setGenero($ben_genero)
                    ->setDataNascimento(new \DateTime($ben_dtNasc))
                    ->addContacto($dep_contacto)
                    ->addDocumentoidentificacao($dep_docID)
            ;

            $dependente = new \Usoko\SIGBundle\Entity\Dependente();
            $dependente->setPessoa($dep_pessoa);

            //INÍCIO: VALIDAÇÃO DO DEPENDENTE
            $errors = Validacao::validar($this, $dependente, false);

            foreach ($errors as $erro) {
                //Caso Haja Conflito de Identidade (Mecanográfico=> 27, NID => 28)
                if ($erro->getCode() === 27) {

                    $doc_tst = $this->em->getRepository('UsokoSIGBundle:Documentoidentificacao')->findOneBy(array('numero' => $ben_ID_num, 'tipodocumento' => $docIDT));
                    if ($doc_tst) {
                        $dep_pessoa = $doc_tst->getPessoa()->first(); //$em->getRepository('UsokoSIGBundle:Pessoa')->findOneByDocumentoidentificacao($doc_tst);
                        $dependente = $this->em->getRepository('UsokoSIGBundle:Dependente')->findOneByPessoa($dep_pessoa);
                    }
                } else {

                    continue; //ignora os outros erros. Ex.: Nome com Caracteres Especiais
                }
            }

            $dep_pessoa
                    ->setNome($ben_nome)
                    ->setGenero($ben_genero)
                    ->setDataNascimento(new \DateTime($ben_dtNasc))
                    ->setTipo(\Usoko\SIGBundle\General\VarsGeneral::CONS_PESSOA_TIPO_DEPENDENTE)
            //->addContacto($dep_contacto)
            ;

            $dependente->setPessoa($dep_pessoa);

            //FIM: VALIDAÇÃO DO DEPENDENTE

            $this->em->persist($dependente);
            $this->em->flush();

            $associado_dep = new \Usoko\SIGBundle\Entity\AssociadoDependentes();
            $associado_dep
                    ->setAssociado($associado)
                    ->setDependentes($dependente)
                    ->setGrauparentesco($grauparentesco)
                    ->setPercentagem($ben_percent)
            ;

            $this->em->persist($associado_dep);
            $this->em->flush();
        } while (trim($ben_nome) != "");
    }

    public function registarHistorico($associado, $numAssociado, $total_quotas) {
        $utilizador = $utilizador = $this->get('security.context')->getToken()->getUser();
        $historico = new HistoricoImport();
        $historico->setData(new \Datetime('now'))
                ->setAssociado($associado)
                ->setUtilizador($utilizador)
                ->setNumAssociado($numAssociado)
                ->setNumQuotas($total_quotas);
        $this->em->persist($historico);
    }

    private $posActual = 0;

    public function getPosicaoProxima() {
        return $this->getPosicaoLetra(++$this->posActual);
    }

    public function getPosicaoLetra($pos = 1, $init = 1) {
        $array = array(
            0 => 'A', 1 => 'B', 2 => 'C', 3 => 'D', 4 => 'E', 5 => 'F', 6 => 'G', 7 => 'H', 8 => 'I', 9 => 'J',
            10 => 'K', 11 => 'L', 12 => 'M', 13 => 'N', 14 => 'O', 15 => 'P', 16 => 'Q', 17 => 'R', 18 => 'S', 19 => 'T',
            20 => 'U', 21 => 'V', 22 => 'W', 23 => 'X', 24 => 'Y', 25 => 'Z'
        );

        $res = '';
        $i = 0;
        if ($pos > 26) {
            $pos %= 27;
            $pos++;
            $res .= $this->getPosicaoLetra( ++$i);
        }
        return $res . $array[$pos - $init];
    }

    private $excel;

    public function centralizar($x1, $y1, $x2, $y2, $merge = true, $vertical = false) {
        $coord = "{$this->getCoordenada($x1)}$y1:{$this->getCoordenada($x2)}$y2";
        if ($merge)
            $this->excel->getActiveSheet()->mergeCells($coord);

        if ($vertical)
            $this->excel->getActiveSheet()->getStyle($coord)
                    ->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);

        $this->excel->getActiveSheet()->getStyle($coord)
                ->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    }

    private function getCoordenada($i) {
        $array = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'AA', 'AB');
        return $array[$i + 1];
    }

    private function aplicaEstilo($x1, $y1, $x2, $y2, $styleArray) {
        $coord = "{$this->getCoordenada($x1)}$y1:{$this->getCoordenada($x2)}$y2";
        $this->excel->getActiveSheet()->getStyle($coord)->applyFromArray($styleArray);
    }

    public function excel_exportarAction(Request $request = null) {

        $indice = 0;
        $array = array('accao' => 0);
        if (!$request->get('exportar'))
            return $this->render('UsokoSIGBundle:Associado:exportacao.html.twig', $array);

        $mes = $request->get('mes');
        $tipo = $request->get('tipo');

        $inputFileType = 'Excel2007';
        $inputFileName = '../web/uploads/file_model.xlsx';

        /**  Create a new Reader of the type defined in $inputFileType  * */
        $objReader = \PHPExcel_IOFactory::createReader($inputFileType);
        /**  Load $inputFileName to a PHPExcel Object  * */
        $this->excel = $objReader->load($inputFileName);


//$objPHPExcel = new \PHPExcel();
// Set document properties
        $this->excel->getProperties()->setCreator("USOKO")
                ->setLastModifiedBy("USOKO")
                ->setTitle("Ficheiro de Pagamento de Quotas")
                ->setSubject("Ficheiro de Pagamento de Quotas pelo Banco - USOKO")
                ->setKeywords("usoko quota associado banco subssidio")
                ->setCategory("USOKOSIG - NAZZA");


        $associado = new Associado();
        $titulo = "PAGAMENTOS";
        $valor = 0;

        if ($tipo == 'T') {
            $tipos = array('J', 'Q', 'C', 'PP');
        } else
            $tipos = array($tipo);

        foreach ($tipos as $tipo) {

            $em = $this->getDoctrine()->getManager();
            $mes_txt = "AND P.mesAno = '$mes'";
            if ($tipo == 'J' | $tipo == 'Q') {
                if ($tipo == 'J') {
                    $titulo = 'PAGAMENTOS DE JOIAS';
                    $joia = $em->getRepository("UsokoSIGBundle:Tipopagamento")->findOneByTipo('J');
                    if (!$joia) {
                        echo 'Não está definida o Tipo de Pagamento Joia. Por favor contacte o Administrador do Sistema';
                        die;
                    }
                    $valor = $joia->getValor();
                    $mes_txt = '';
                } else {
                    $titulo = 'PAGAMENTOS DE QUOTAS';
                }
            } elseif ($tipo == 'C') {
                $titulo = 'PAGAMENTOS DE CRÉDITOS';
            } elseif ($tipo == 'PP') {
                $titulo = 'PAG. DE P. DE PENSÕES';
                $pp = $em->getRepository("UsokoSIGBundle:Tipopagamento")->findOneByTipo('PP');
                if (!$pp) {
                    echo 'Não está definida o Tipo de Pagamento Plano de Pensão. Por favor contacte o Administrador do Sistema';
                    die;
                }
                $valor = $pp->getValor();
            }

            $sql = "SELECT DISTINCT P "
                    . "FROM UsokoSIGBundle:Pagamento P, UsokoSIGBundle:Tipopagamento TP, UsokoSIGBundle:Associado A "
                    . "WHERE P.associado = A.id AND P.tipopagamento = TP.id $mes_txt AND P.estado='L' AND TP.tipo='$tipo'";

            // Rename worksheet
            $this->excel->setActiveSheetIndex($indice++);
            $this->excel->createSheet();

            $this->excel->getActiveSheet()->setTitle('USOKO - ' . $titulo);



            $logo = __DIR__ . '/../../../../web/img/nossas/logo.png';
            $this->insereImagem($logo, 110, 'A' . "1");
            $this->excel->getActiveSheet()->getRowDimension('1')->setRowHeight(85);

            $this->excel->getActiveSheet()->setCellValue('B1', 'USOKO - Associação Mutualista');
            $this->excel->getActiveSheet()->setCellValue('A2', $tipo);
            $this->excel->getActiveSheet()->setCellValue('H2', 'MÊS REFERENTE');
            $this->excel->getActiveSheet()->setCellValue('I2', $mes);

            $this->centralizar('0', '1', '7', '1', true, true);

            $array_colunas = array(
                'A3' => 'N.º MECANOGRÁFICO',
                'B3' => 'NOME COMPLETO',
                'C3' => 'CATEGORIA',
                'D3' => 'SITUAÇÃO',
                'E3' => 'CONTA BANCÁRIA',
                'F3' => 'ÓRGÃO',
                'G3' => 'DATA DE INGRESSO',
                'H3' => 'VALOR (AKZ)',
                'I3' => 'DESCONTADO?'
            );

// Add some data
            foreach ($array_colunas as $key => $value) {
                $this->excel->getActiveSheet()->setCellValue($key, $value);
                $this->excel->getActiveSheet()->getColumnDimension(substr($key, 0, 1))->setAutoSize(true);
            }

            $query = $em->createQuery($sql);

            $pagamentos = $query->getResult();
            $i = 3;


            if ($tipo == 'J' | $tipo == 'Q') {
                $lista = $em->getRepository("UsokoSIGBundle:Associado")->findAll();
            } elseif ($tipo == 'C') {
                $lista = $em->getRepository("UsokoSIGBundle:CreditoResposta")->findByResposta('AP');
            } elseif ($tipo == 'PP') {
                $lista = $em->getRepository("UsokoSIGBundle:PlanoPensao")->findByEstado('A');
            }


            foreach ($lista as $obj) {

                $continue = false;
                $valor_pago = 0;
                $registo = 0;
                if ($tipo == 'J' | $tipo == 'Q') {
                    $associado = $obj;
                    if ($tipo == 'Q') {
                        $quota = $em->getRepository("UsokoSIGBundle:Tipopagamento")->findOneByTipo('Q');
                        if (!$quota) {
                            echo 'Não encontra-se definido tipo de pagamento Quota. Contacte o Administrador';
                            die;
                        }
                        $taxa = $quota->getValor() / 100;
                        $valor = $associado->getSalario() * $taxa - $valor_pago;
                    }
                } elseif ($tipo == 'C') {
                    $credito_resposta = $obj;
                    $associado = $obj->getCreditoPedido()->getAssociado();
                    $valor = $credito_resposta->getValorMensal();
                    $registo = $obj->getId();
                } elseif ($tipo == 'PP') {
                    $plano_pensao = $obj;
                    $associado = $obj->getAssociado();
                    $valor = $plano_pensao->getValor();
                    $registo = $obj->getId();
                }


                foreach ($pagamentos as $pagamento) {
                    if ($pagamento->getAssociado() == $associado && $pagamento->getRegisto() == $registo) {
                        $continue = true;
                    }
                }

                if ($continue)
                    continue;


                $i++;
                //$associado = $pagamento->getAssociado();
                //$num_ID = $associado->getPessoa()->getDocumentoidentificacao() != array() ? $associado->getPessoa()->getDocumentoidentificacao()->first()->getNumero() : '';
                $num_conta = $associado->getConta() ? $associado->getConta()->getNumero() : '';
                $this->excel->setActiveSheetIndex($indice - 1)
                        ->setCellValue("A$i", $associado->getNMecanografico())
                        ->setCellValue("B$i", strtoupper($associado->getPessoa()->getNome()))
                        ->setCellValue("C$i", $associado->getCargo()->getCargo())
                        ->setCellValue("D$i", $associado->getStatus() == 'A' ? 'ACTIVO' : 'REFORMADO')
                        ->setCellValue("E$i", $num_conta)
                        ->setCellValue("F$i", $associado->getOrgao()->getNome())
                        ->setCellValue("G$i", $associado->getDataAssociacao()->format('d/m/Y'))
                        ->setCellValue("H$i", $valor)
                        ->setCellValue("I$i", 'NÃO')
                        ->setCellValue("J$i", $registo)
                        ->getCell("E$i")->setValueExplicit($num_conta, \PHPExcel_Cell_DataType::TYPE_STRING)
                ;
            }


// $this->pdf->SetFillColor(27, 90, 141);
            $style_fundo = array(
                'font' => array(
                    'bold' => true,
                    'color' => array('argb' => 'FFFFFF')
                ),
                'fill' => array(
                    'type' => \PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array(
                        'argb' => 'FF7700',
                    )
                ),
            );

            $style_transparente = array(
                'font' => array(
                    'color' => array('argb' => 'FFFFFF')
                )
            );

            $style_fundo_preto = array(
                'font' => array(
                    'bold' => true,
                    'color' => array('argb' => 'FFFFFF')
                ),
                'fill' => array(
                    'type' => \PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array(
                        'argb' => '000000',
                    )
                ),
                'borders' => array(
                    'outline' => array(
                        'style' => \PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '000000'),
                    ),
                    'inside' => array(
                        'style' => \PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '000000'),
                    ),
                ),
            );


            $styleArray = array(
                'borders' => array(
                    'outline' => array(
                        'style' => \PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => 'FF7700'),
                    ),
                    'inside' => array(
                        'style' => \PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => 'FF7700'),
                    ),
                ),
            );
            $this->aplicaEstilo(6, 2, 7, 2, $style_fundo_preto);
            $this->aplicaEstilo(-1, 3, 7, 3, $style_fundo);
            $this->aplicaEstilo(-1, 3, 7, $i, $styleArray);

            $this->excel->getActiveSheet()->getProtection()->setPassword(date('hisdmY'));
            $this->excel->getActiveSheet()->getProtection()->setSheet(true); // This should be enabled in order to enable any of the following!
            $this->excel->getActiveSheet()->getProtection()->setSort(true);
            $this->excel->getActiveSheet()->getProtection()->setInsertRows(true);
            $this->excel->getActiveSheet()->getProtection()->setFormatCells(true);
            $this->excel->getActiveSheet()
                    ->getStyle("I4:I$i")
                    ->getProtection()->setLocked(
                    \PHPExcel_Style_Protection::PROTECTION_UNPROTECTED
            );

            $this->aplicaEstilo(8, 3, 8, $i, $style_transparente);
            $this->aplicaEstilo(-1, 2, 0, 2, $style_transparente);
        }
        $this->excel->setActiveSheetIndex(0);

// Redirect output to a client’s web browser (Excel2007)
        $nome = 'Pagamento de Quota - USOKO' . date('YmdHis') . '.xlsx';
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $nome . '"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');


// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = \PHPExcel_IOFactory::createWriter($this->excel, 'Excel2007');
        $objWriter->save('php://output');
        die;
    }

    public function importacaoAction($array = array('accao' => 0)) {
        return $this->render('UsokoSIGBundle:Associado:importacao.html.twig', $array);
    }

    public function banco_importarAction(Request $request) {

        if (!isset($_FILES['ficheiro'])) {
            echo "Nenhum Ficheiro de Importação foi Identificado!";
            return;
        }

        $ficheiro = $_FILES['ficheiro'];

        $inputFileType = 'Excel2007';
        $inputFileName = $ficheiro['tmp_name']; // '../web/uploads/example1.xlsx';

        /**  Create a new Reader of the type defined in $inputFileType  * */
        $objReader = \PHPExcel_IOFactory::createReader($inputFileType);
        /**  Load $inputFileName to a PHPExcel Object  * */
        $objPHPExcel = $objReader->load($inputFileName);

        $num_folhas = $objPHPExcel->getSheetCount();
        $this->em = $this->getDoctrine()->getManager();

        $joia_total = 0;
        $joia_paga = 0;
        $joia_total_valor = 0;

        $credito_total = 0;
        $credito_pago = 0;
        $credito_total_valor = 0;

        $quota_total = 0;
        $quota_paga = 0;
        $quota_total_valor = 0;

        $pp_total = 0;
        $pp_pago = 0;
        $pp_total_valor = 0;

        for ($n = 0; $n < $num_folhas; $n++) {
            $dados = $objPHPExcel->setActiveSheetIndex($n)->toArray(null, true, true, true);

            $cc = 0;
            foreach ($dados as $d) {
                $this->posActual = 0;
                if ($cc == 1) {
                    $tipo = $d[$this->getPosicaoProxima()]; //$d['A'];
                    $this->posActual = 8;
                    $mes = $d[$this->getPosicaoProxima()]; //$d['H'];
                } elseif ($cc > 2) {
                    if ($tipo == 'J') {
                        $joia_total++;
                        $mes = '00-0000';
                    } elseif ($tipo == 'Q') {
                        $quota_total++;
                    } elseif ($tipo == 'C') {
                        $credito_total++;
                    } elseif ($tipo == 'PP') {
                        $pp_total++;
                    }
                    $numMecanog = $d[$this->getPosicaoProxima()]; //$d['A'];
                    $this->posActual = 7;
                    $valor = $d[$this->getPosicaoProxima()]; //$d['H'];
                    $descont = strtoupper($d[$this->getPosicaoProxima()]); //$d['H'];
                    $registo = $d[$this->getPosicaoProxima()]; //$d['H'];
                    // echo "<br/>$mes - $tipo - $numMecanog - $valor - $descont"; die;
                    $associado = $this->em->getRepository('UsokoSIGBundle:Associado')->findOneByNMecanografico($numMecanog);
                    $tipopagamento = $this->em->getRepository('UsokoSIGBundle:Tipopagamento')->findOneByTipo($tipo);
                    $bancoConta = $this->em->getRepository('UsokoSIGBundle:BancoConta')->findOneByTipo('U');
                    if ($descont == 'SIM' | $descont == 'S') {
                        $pagamento = $this->em->getRepository('UsokoSIGBundle:Pagamento')->findOneBy(array('associado' => $associado, 'tipopagamento' => $tipopagamento, 'mesAno' => $mes));

                        if (!$pagamento) {
                            $pagamento = new \Usoko\SIGBundle\Entity\Pagamento();
                        }

                        $pagamento->setAssociado($associado)
                                ->setBancoConta($bancoConta)
                                ->setDataActual(new \DateTime())
                                ->setEstado('L')
                                ->setMesAno($mes)
                                ->setTipopagamento($tipopagamento)
                                ->setValor($valor)
                                ->setRegisto($registo);

                        $this->em->persist($pagamento);
                        $this->em->flush();

                        $pagamentos_feitos = $this->em->getRepository("UsokoSIGBundle:Pagamento")->creditoPagamentos($registo);
                        //echo 'Tem: '.count($pagamentos_feitos).' registo. '.$registo;
                        foreach ($pagamentos_feitos as $pf) {
                            $cr = $this->em->getRepository("UsokoSIGBundle:CreditoResposta")->find($pf['id']);
                            $cr->setResposta('C');
                            $this->em->persist($cr);
                        }
                        //    die;
                        if ($tipo == 'J') {
                            $joia_paga++;
                            $joia_total_valor += $valor;
                        } elseif ($tipo == 'Q') {
                            $quota_paga++;
                            $quota_total_valor += $valor;
                        } elseif ($tipo == 'C') {
                            $credito_pago++;
                            $credito_total_valor += $valor;
                        } elseif ($tipo == 'PP') {
                            $pp_pago++;
                            $pp_total_valor += $valor;
                        }
                    }
                }
                $cc++;
            }
            $this->em->flush();
        }

        return $this->importacao_bancoAction(array(
                    'accao' => 1,
                    'joia_total' => $joia_total,
                    'joia_paga' => $joia_paga,
                    'joia_total_valor' => $joia_total_valor,
                    'quota_total' => $quota_total,
                    'quota_paga' => $quota_paga,
                    'quota_total_valor' => $quota_total_valor,
                    'credito_total' => $credito_total,
                    'credito_pago' => $credito_pago,
                    'credito_total_valor' => $credito_total_valor,
                    'pp_total' => $pp_total,
                    'pp_pago' => $pp_pago,
                    'pp_total_valor' => $pp_total_valor,
        ));
    }

    public function importacao_bancoAction($array = array('accao' => 0)) {
        return $this->render('UsokoSIGBundle:Associado:importacao_banco.html.twig', $array);
    }

    private function insereImagem($path, $tamanho, $coord, $nome = '', $descricao = '') {
        try {
            $objDrawing = new \PHPExcel_Worksheet_Drawing();
            $objDrawing->setName($nome);
            $objDrawing->setDescription($descricao);
            $objDrawing->setPath($path);
            $objDrawing->setHeight($tamanho);
            $objDrawing->setCoordinates($coord);
            $objDrawing->setWorksheet($this->excel->getActiveSheet());
        } catch (\Exception $e) {
            echo "erroooo";
            print_r($e->getMessage());
            die;
        }
    }

    public function perfilAssociadoAction($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        return $this->render('UsokoSIGBundle:Associado:PA_Dados.html.twig', array(
                    'entity' => $entity
        ));
    }

    public function perfilAssociadoAtAction($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        return $this->render('UsokoSIGBundle:Associado:Atendente/PA_Dados2.html.twig', array(
                    'entity' => $entity
        ));
    }
    
    #Lista todos assciados que estao nesta lista de id 

    public function listaPerfilAssociadosAction($id, Request $request) {
        $cod = 'A';
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("
        SELECT a FROM UsokoSIGBundle:Associado a,
        UsokoSIGBundle:Pessoa p 
        WHERE a.pessoa=p.id 
          AND p.nome LIKE :nome
          ORDER BY p.nome"
                )
                ->setParameter('nome', '%' . $id . '%');
        $entities = $query->getResult();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Associado:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
                    'tipo' => $cod,
        ));
    }


    public function pA_DadosAction($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        return $this->render('UsokoSIGBundle:Associado:PA_Dados.html.twig', array(
                    'entity' => $entity,
        ));
    }

    public function perfilAssociado_ADAction($play, $id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $entity->setAnexo(null);
        $entity->getPessoa()->setFoto(null);

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        $idC = $this->get('nzo_url_encryptor')->encrypt($entity->getId());
        $action = $this->generateUrl('associado_update', array('id' => $idC));
        return $this->render('UsokoSIGBundle:Associado:PA_AlterDados.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
                    'action' => $action
        ));
    }

    public function consultarAssociadoAction($mec) {

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('nMecanografico' => $mec));
        if (!$entity) {
            $json = json_encode(array("codigo" => 400, "resposta" => null));
        } else {
            $json = json_encode(array("codigo" => 200, "resposta" => $this->get('nzo_url_encryptor')->encrypt($entity->getId())));
        }

        $resposta = new Response($json);
        $resposta->headers->set('Content-Type', 'application/json');
        return $resposta;
    }

    public function consultarAssocAction($mec, $chave) {

        $em = $this->getDoctrine()->getManager();
        $chave = base64_decode($chave);
        $mec = base64_decode($mec);
        if ($mec == $chave) {
            $entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('nMecanografico' => $mec));

            if (!$entity) {
                $json = json_encode(array("codigo" => 400, "resposta" => null));
            } else {
                $json = json_encode(array("codigo" => 200, "resposta" => $this->get('nzo_url_encryptor')->encrypt($entity->getId())));
            }
        } else {
            $json = json_encode(array("codigo" => 400, "resposta" => $chave));
        }

        $resposta = new Response($json);
        $resposta->headers->set('Content-Type', 'application/json');
        return $resposta;
    }

    public function associadoAction() {
        $endereco = $_SERVER['HTTP_HOST'];
        return $this->render('UsokoSIGBundle:Associado:consultar.html.twig', array('endereco' => $endereco));
    }
    
      public function consultarPorNumAction() {
        $endereco = $_SERVER['HTTP_HOST'];
        return $this->render('UsokoSIGBundle:Associado:consultarPorNum.html.twig', array('endereco' => $endereco));
    }

    public function consultarPorNomeAction() {
        $endereco = $_SERVER['HTTP_HOST'];
        return $this->render('UsokoSIGBundle:Associado:consultarPorNome.html.twig', array('endereco' => $endereco));
    }

    public function declaracaoAction() {

        $html = $this->renderView('UsokoSIGBundle:PDF:declaracao.html.twig');

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('declaracao.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function cartonAction() {

        $mecanografico = $this->get('request')->request->get('cartao');

        if (!is_null($mecanografico)) {
            $em = $this->getDoctrine()->getManager();

            $query = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('nMecanografico' => $mecanografico));

            if ($query) {
                $nome = $query->getPessoa();

                $html = $this->renderView('UsokoSIGBundle:PDF:cartao.html.twig', array('nome' => $nome));


                $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

                $html2pdf->pdf->SetAuthor('Nasa');
                $html2pdf->pdf->SetTitle('Nasa');

                $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $html2pdf->pdf->SetFont('helvetica', '', 11);
                $html2pdf->pdf->setPrintHeader('Ola Mundo');
                $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

                $html2pdf->pdf->SetDisplayMode('real');

                $html2pdf->writeHTML($html);
                $html2pdf->Output('cartao.pdf', 'I');

                $resposta = new Response();
                $resposta->headers->set('Content-Type', 'application/pdf');

                return $resposta;
            } else {
                return $this->redirect($this->generateUrl('home_atendente'));
            }
        }
    }

    public function validacaoAction() {

        return $this->render('UsokoSIGBundle:PDF:validacaoMascara.html.twig');
    }

    public function procurarPagamentoAction($id) {
        $em = $this->getDoctrine()->getManager();

        $id = base64_decode($id);
        $query = $em->createQuery(
                        'SELECT a
                         FROM UsokoSIGBundle:Pagamento p,
                         sicopasicopaBundle:Aluno a
                         WHERE p.aluno = a.id
                         AND a.ddi = :price
                         OR a.numero = :price
                               ')->setParameter('price', "$id");

        $entity = $query->getResult();

        if (!$entity) {
            $json = json_encode(array("codigo" => 400, "resposta" => null));
        } else {
            $json = json_encode(array("codigo" => 200, "resposta" => 'sucesso'));
        }

        $resposta = new Response($json);
        $resposta->headers->set('Content-Type', 'application/json');
        return $resposta;
    }

    private function salario($request) {
        $valor = $request->request->get('usoko_sigbundle_associado')['salario'];
        $valor = NumeroReal::converter($valor);
        return $valor;
    }

    public function ajaxPesquisaEstudanteAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $bi = $request->query->get('a');

        $result = array();
        $em = $this->getDoctrine()->getManager();

        $docIdent = $em->getRepository('UsokoSIGBundle:Documentoidentificacao')->findOneBy(array('numero' => $bi));
        if ($docIdent) {
            $pessDoc = $em->getRepository('Usoko\SIGBundle\Entity\PessoaDocumento')->findOneBy(array('documentoidentificacao' => $docIdent->getId()));
            if ($pessDoc) {
                $pessoa = $em->getRepository('UsokoSIGBundle:Pessoa')->findOneBy(array('id' => $pessDoc->getPessoa()));
                if ($pessoa) {
                    $estudante = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('pessoa' => $pessoa->getId()));
                } else {
                    $result['rs'] = 0;
                    $result['vl'] = 0;
                    return new JsonResponse($result);
                }
            } else {
                $result['rs'] = 0;
                $result['vl'] = 0;
                return new JsonResponse($result);
            }
        } else {
            $result['rs'] = 0;
            $result['vl'] = 0;
            return new JsonResponse($result);
        }


        if (!$estudante) {
            $result['rs'] = 0;
            $result['vl'] = 0;
            return new JsonResponse($result);
        }

        $result['rs'] = 1;
        $result['vl'] = $this->get('nzo_url_encryptor')->encrypt($estudante->getId());
        return new JsonResponse($result);
    }
    
    //Feito pelo numero do associado
    public function ajaxPesquisaPorNumAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $dado = $request->query->get('a');

        $result = array();


        $em = $this->getDoctrine()->getManager();
        $estudante = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('numero' => $dado));


        if (!$estudante) {
            $result['rs'] = 0;
            $result['vl'] = 0;
            return new JsonResponse($result);
        }

        $result['rs'] = 1;
        $result['vl'] = $this->get('nzo_url_encryptor')->encrypt($estudante->getId());
        return new JsonResponse($result);
    }

    //Feito pelo numero do associado
    public function ajaxPesquisaPorNomeAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $dado = $request->query->get('a');

        $result = array();


        $em = $this->getDoctrine()->getManager();

        $query = $em->createQuery("
        SELECT p FROM UsokoSIGBundle:Associado a,
        UsokoSIGBundle:Pessoa p
        WHERE a.pessoa=p.id
          AND p.nome LIKE :nome
          ORDER BY p.nome"
                )
                ->setParameter('nome', '%' . $dado . '%');

        $estudante = $query->getResult();

        if (!$estudante) {
            $result['rs'] = 0;
            $result['vl'] = 0;
            return new JsonResponse($result);
        }
//Retornara o nome do associado
        $result['rs'] = 1;
        //$result['vl'] = $this->get('nzo_url_encryptor')->encrypt($estudante->getId());
        $result['vl'] = $this->get('nzo_url_encryptor')->encrypt($dado);

        return new JsonResponse($result);
    }


//Feito pelo numero mecanografico
    public function ajaxPesquisaEstudanteAntesAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $dado = $request->query->get('a');

        $result = array();


        $em = $this->getDoctrine()->getManager();
        $estudante = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('nMecanografico' => $dado));


        if (!$estudante) {
            $result['rs'] = 0;
            $result['vl'] = 0;
            return new JsonResponse($result);
        }

        $result['rs'] = 1;
        $result['vl'] = $this->get('nzo_url_encryptor')->encrypt($estudante->getId());
        return new JsonResponse($result);
    }

    private function valor($request) {
        $valorLimite = $request->request->get('usoko_sigbundle_associado')['salario'];
        $valorLimite = NumeroReal::converter($valorLimite);
        return $valorLimite;
    }

}
