<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\AssociadoDependentes;
use Usoko\SIGBundle\Form\AssociadoDependentesType;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\UploadGeneral;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\DataGeneral;
use Symfony\Component\Form\FormError;

/**
 * AssociadoDependentes controller.
 *
 */
class AssociadoDependentesController extends Controller {

    /**
     * Lists all AssociadoDependentes entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:AssociadoDependentes:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new AssociadoDependentes entity.
     *
     */
    public function createAction(Request $request, $associado) {

        $associadoCR = $associado;
        $entity = new AssociadoDependentes();
        $form = $this->createCreateForm($entity, $associado);
        $form->handleRequest($request);
        //$entity = $form->getData();

        $em = $this->getDoctrine()->getManager();
        $associado = $this->get('nzo_url_encryptor')->decrypt($associadoCR);
        $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($associado);
        if (!$associado) {
            throw $this->createNotFoundException('Associado Não Existe');
        }

        $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setLocalEmissao('Teste');
        $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataEmissao(DataGeneral::tempoGeral());
        $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataExpiracao(DataGeneral::tempoGeral());

        $dependentes = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findByAssociado($associado);
        $percentagem = 0;
        foreach ($dependentes as $dependente) {
            $percentagem += $dependente->getPercentagem();
        }

        $percentagem += $entity->getPercentagem();
        $percentagemOK = true;
        if ($percentagem > 100) {
            $disponivel = 100 - ($percentagem - $entity->getPercentagem());
            $form->get('percentagem')->addError(new FormError("O Total de Percetagens dos Dependentes excede 100%, disponivel $disponivel% "));
            $percentagemOK = false;
        }

        if (Validacao::validar($this, $entity) & $percentagemOK) {
            $em->getConnection()->beginTransaction();

            $entity->setAssociado($associado);

            $entity->getDependentes()->getPessoa()->setTipo(VarsGeneral::CONS_PESSOA_TIPO_DEPENDENTE);
            $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setLocalEmissao(null);
            $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataEmissao(null);
            $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataExpiracao(null);

            // pessoa
            $temp_fotoPessoa = $entity->getDependentes()->getPessoa()->getFoto();
            $entity->getDependentes()->getPessoa()->setFoto(null);

            $em->persist($entity);
            $em->flush();

            // uploads
            if ($temp_fotoPessoa) {
                $file_name = md5($entity->getDependentes()->getPessoa()->getId()) . VarsGeneral::CONS_UPLOAD_EXTENCTION;
                $answer = UploadGeneral::upload($temp_fotoPessoa, VarsGeneral::CONS_UPLOAD_DEPENDENTE_FOTO, $file_name);
                $entity->getDependentes()->getPessoa()->setFoto($file_name);
            }

            $em->flush();   // update 

            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoDependente", "I", "Registo de Um Novo Dependente");
            $em->getConnection()->commit();

            $utilizador = $this->get('security.context')->getToken()->getUser();

            foreach ($utilizador->getRoles() as $funcao) {
                if ($funcao->getNome() == 'GESTOR') {

                    $url = "myDependentes_AS";
                } else {
                    $url = "meuDependentes_AS";
                }
                break;
            }

            return $this->redirect($this->generateUrl($url, array('id' => $associadoCR, 'play' => '19')));
        }

        $msg = "";
        $errors = Validacao::validar($this, $entity, false);

        foreach ($errors as $erro) {
            if ($erro->getCode() === 27) {
                $msg = VarsGeneral::MESSAGE_DOC_ERROR;
                break;
            }
        }
        return $this->render('UsokoSIGBundle:AssociadoDependentes:PA_NovoDep.html.twig', array
                    (
                    'entity' => $associado,
                    'form' => $form->createView(), 'msg' => $msg
        ));
    }

    public function createAtAction(Request $request, $associado) {

        $associadoCR = $associado;
        $entity = new AssociadoDependentes();
        $form = $this->createCreateForm($entity, $associado);
        $form->handleRequest($request);
        //$entity = $form->getData();

        $em = $this->getDoctrine()->getManager();
        $associado = $this->get('nzo_url_encryptor')->decrypt($associadoCR);
        $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($associado);
        if (!$associado) {
            throw $this->createNotFoundException('Associado Não Existe');
        }

        $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setLocalEmissao('Teste');
        $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataEmissao(DataGeneral::tempoGeral());
        $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataExpiracao(DataGeneral::tempoGeral());

        $dependentes = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findByAssociado($associado);
        $percentagem = 0;
        foreach ($dependentes as $dependente) {
            $percentagem += $dependente->getPercentagem();
        }

        $percentagem += $entity->getPercentagem();
        $percentagemOK = true;
        if ($percentagem > 100) {
            $disponivel = 100 - ($percentagem - $entity->getPercentagem());
            if ($disponivel <= 0) {
                $disponivel = 0;
                $form->get('percentagem')->addError(new FormError("O Total de Percetagens dos Dependentes excede 100%, disponivel $disponivel% "));
            }
            $percentagemOK = false;
        }

        if (Validacao::validar($this, $entity) & $percentagemOK) {
            $em->getConnection()->beginTransaction();

            $entity->setAssociado($associado);

            $entity->getDependentes()->getPessoa()->setTipo(VarsGeneral::CONS_PESSOA_TIPO_DEPENDENTE);
            $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setLocalEmissao(null);
            $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataEmissao(null);
            $entity->getDependentes()->getPessoa()->getDocumentoidentificacao()[0]->setDataExpiracao(null);

            // pessoa
            $temp_fotoPessoa = $entity->getDependentes()->getPessoa()->getFoto();
            $entity->getDependentes()->getPessoa()->setFoto(null);

            $em->persist($entity);
            $em->flush();

            // uploads
            if ($temp_fotoPessoa) {
                $file_name = md5($entity->getDependentes()->getPessoa()->getId()) . VarsGeneral::CONS_UPLOAD_EXTENCTION;
                $answer = UploadGeneral::upload($temp_fotoPessoa, VarsGeneral::CONS_UPLOAD_DEPENDENTE_FOTO, $file_name);
                $entity->getDependentes()->getPessoa()->setFoto($file_name);
            }

            $em->flush();   // update 
            //echo($entity->getId()); die;
            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoDependente", "I", "Registo de um novo dependente");
            //AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoDependente", "I", "Registo de Um Novo Dependente");
            $em->getConnection()->commit();
            $url = "meuDependentes_AS";

            return $this->redirect($this->generateUrl($url, array('id' => $associadoCR, 'play' => '19')));
        } else {

            $msg = "";
            $errors = Validacao::validar($this, $entity, false);

            foreach ($errors as $erro) {
                if ($erro->getCode() === 27) {
                    $msg = VarsGeneral::MESSAGE_DOC_ERROR;
                    break;
                }
            }
            return $this->render('UsokoSIGBundle:AssociadoDependentes:Atendente/PA_NovoDep.html.twig', array
                        (
                        'entity' => $associado,
                        'form' => $form->createView(), 'msg' => $msg
            ));
        }
    }

    /**
     * Creates a form to create a AssociadoDependentes entity.
     *
     * @param AssociadoDependentes $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(AssociadoDependentes $entity, $associado) {
        $form = $this->createForm(new AssociadoDependentesType(), $entity, array('action' => $this->generateUrl('associadodependentes_create', array(
                'associado' => $associado)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        return $form;
    }

    /**
     * Displays a form to create a new AssociadoDependentes entity.
     *
     */
    public function newAction($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity. New Action'
            );
        }

        $dependente = new AssociadoDependentes();
        $form = $this->createCreateForm($dependente, $id);

        return $this->render('UsokoSIGBundle:AssociadoDependentes:PA_NovoDep.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
                    'msg' => ''
        ));
    }

    public function new2Action($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity. New Action');
        }

        $dependente = new AssociadoDependentes();
        $form = $this->createCreateForm($dependente, $id);

        return $this->render('UsokoSIGBundle:AssociadoDependentes:Atendente/PA_NovoDep.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a AssociadoDependentes entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->find($id);


        if (!$entity) {
            throw $this->createNotFoundException(
                    'Unable to find AssociadoDependentes entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:AssociadoDependentes:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing AssociadoDependentes entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find AssociadoDependentes entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:AssociadoDependentes:edit.html.twig', array
                    (
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(), 'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a AssociadoDependentes entity.
     *
     * @param AssociadoDependentes $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(AssociadoDependentes $entity) {
        $form = $this->createForm(new AssociadoDependentesType(), $entity, array('action' => $this->generateUrl('associadodependentes_update', array(
                'id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing AssociadoDependentes entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find AssociadoDependentes entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);

        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoDependente", "U", "Actualização de Um Associado Dependente");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl(
                                    'associadodependentes_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:AssociadoDependentes:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a AssociadoDependentes entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find AssociadoDependentes entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoDependente", "D", "REmoção de Um Associado Dependente");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('associadodependentes'));
    }

    /**
     * Creates a form to delete a AssociadoDependentes entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('associadodependentes_delete', array
                                    ('id' => $id)))
                        ->setMethod('DELETE')->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    public function myDependentesAction($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw

            $this->createNotFoundException('Unable to find Associado entity.');
        }

        $entities = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findByAssociado($id);

        return $this->render('UsokoSIGBundle:AssociadoDependentes:PA_ListaDep.html.twig', array(
                    'entity' => $entity,
                    'entities' => $entities,
        ));
    }

    public function myDependentesAtAction($id) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->
                    createNotFoundException('Unable to find Associado entity.');
        }

        $entities = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findByAssociado($id);

        return $this->render('UsokoSIGBundle:AssociadoDependentes:Atendente/PA_ListaDep.html.twig', array(
                    'entity' => $entity,
                    'entities' => $entities,
        ));
    }

    public function showMyAction($id, $beneficiario) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $beneficiario = $this->get('nzo_url_encryptor')->decrypt($beneficiario);

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $beneficiario = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findOneBy(
                array('associado'
                    => $id, 'dependentes' => $beneficiario));

        if (!$beneficiario) {
            throw $this->createNotFoundException('Unable to find AssociadoDependentes entity.');
        }

        return $this->render('UsokoSIGBundle:AssociadoDependentes:PA_DadosDep.html.twig', array(
                    'entity' => $entity,
                    'assoDep' => $beneficiario
        ));
    }

    public function showMyAtAction($id, $beneficiario) {

        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $beneficiario = $this->get('nzo_url_encryptor')->decrypt($beneficiario);

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $beneficiario = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findOneBy(
                array('associado' => $id, 'dependentes' => $beneficiario));

        if (!$beneficiario) {
            throw $this->createNotFoundException('Unable to find AssociadoDependentes entity.');
        }

        return $this->render('UsokoSIGBundle:AssociadoDependentes:Atendente/PA_DadosDep.html.twig', array(
                    'entity' => $entity,
                    'assoDep' => $beneficiario
        ));
    }

}
