<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\BancoConta;
use Usoko\SIGBundle\Form\BancoContaType;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * BancoConta controller.
 *
 */
class BancoContaController extends Controller {

    /**
     * Lists all BancoConta entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:BancoConta')->findByTipo(\Usoko\SIGBundle\General\VarsGeneral::CONS_CONTABAN_TIPO_USOKO);

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:BancoConta:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new BancoConta entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new BancoConta();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();

            $entity->setTipo(\Usoko\SIGBundle\General\VarsGeneral::CONS_CONTABAN_TIPO_USOKO);
            $em->persist($entity);
            $em->flush();

            //Inicio da operação
            AuditoriaGeneral::auditar($this, $em, $entity, "BancoConta", "I", "Registo de Uma Nova Conta Banco");
            $em->getConnection()->commit();
            //Fim da operação

            return $this->redirect($this->generateUrl('bancoconta_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:BancoConta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a BancoConta entity.
     *
     * @param BancoConta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(BancoConta $entity) {
        $form = $this->createForm(new BancoContaType(), $entity, array(
            'action' => $this->generateUrl('bancoconta_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new BancoConta entity.
     *
     */
    public function newAction() {
        $entity = new BancoConta();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:BancoConta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a BancoConta entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:BancoConta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BancoConta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BancoConta:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing BancoConta entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:BancoConta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BancoConta entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BancoConta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a BancoConta entity.
     *
     * @param BancoConta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(BancoConta $entity) {
        $form = $this->createForm(new BancoContaType(), $entity, array(
            'action' => $this->generateUrl('bancoconta_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing BancoConta entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:BancoConta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BancoConta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "BancoConta", "U", "Actualização de Uma Conta Bancaria");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('bancoconta_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:BancoConta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a BancoConta entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:BancoConta')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find BancoConta entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "BancoConta", "D", "Remoção de Uma Conta Bancaria");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('bancoconta'));
    }

    /**
     * Creates a form to delete a BancoConta entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('bancoconta_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
