<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\BancoInstituicao;
use Usoko\SIGBundle\Form\BancoInstituicaoType;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * BancoInstituicao controller.
 *
 */
class BancoInstituicaoController extends Controller {

    /**
     * Lists all BancoInstituicao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:BancoInstituicao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:BancoInstituicao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new BancoInstituicao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new BancoInstituicao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            //Inicio da operação
            AuditoriaGeneral::auditar($this, $em, $entity, "BancoInstituicao", "I", "Registo de Uma Nova Instituição Bancária");

            $em->getConnection()->commit();
            //Fim da operação

            return $this->redirect($this->generateUrl('bancoinstituicao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:BancoInstituicao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a BancoInstituicao entity.
     *
     * @param BancoInstituicao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(BancoInstituicao $entity) {
        $form = $this->createForm(new BancoInstituicaoType(), $entity, array(
            'action' => $this->generateUrl('bancoinstituicao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new BancoInstituicao entity.
     *
     */
    public function newAction() {
        $entity = new BancoInstituicao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:BancoInstituicao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a BancoInstituicao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:BancoInstituicao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BancoInstituicao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BancoInstituicao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing BancoInstituicao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:BancoInstituicao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BancoInstituicao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BancoInstituicao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a BancoInstituicao entity.
     *
     * @param BancoInstituicao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(BancoInstituicao $entity) {
        $form = $this->createForm(new BancoInstituicaoType(), $entity, array(
            'action' => $this->generateUrl('bancoinstituicao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing BancoInstituicao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:BancoInstituicao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BancoInstituicao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "BancoInstituicao", "U", "Actualização de uma Instituição Bancária");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('bancoinstituicao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:BancoInstituicao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a BancoInstituicao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:BancoInstituicao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find BancoInstituicao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "BancoInstituicao", "D", "Remoção de uma Instituição Bancária");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('bancoinstituicao'));
    }

    /**
     * Creates a form to delete a BancoInstituicao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('bancoinstituicao_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
