<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\BeneficioPedido;
use Usoko\SIGBundle\Form\BeneficioPedidoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\CryptGeneral;
use Usoko\SIGBundle\General\DataGeneral;

/**
 * BeneficioPedido controller.
 *
 */
class BeneficioPedidoController extends Controller {

    /**
     * Lists all BeneficioPedido entities.
     *
     */
    public function indexAction($cod, Request $request) {

        $em = $this->getDoctrine()->getManager();

        if ($cod == 'P') {
            $estado = 'A';
        } elseif ($cod == 'E') {
            $estado = 'R';
        } elseif ($cod == 'PX') {
            $estado = 'A';  // Aprovado 
        } else {
            $estado = 'P';
        }

        $entities = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->findBy(array('estado' => $estado));

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:BeneficioPedido:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
                    'estado' => $estado,
        ));
    }

    /**
     * Creates a new BeneficioPedido entity.
     *
     */
    public function createAction(Request $request, $pp) {

        $ppCR = $pp;
        $pp = CryptGeneral::decrypt($this, $ppCR);
        $entity = new BeneficioPedido();
        $form = $this->createCreateForm($entity, $pp);
        $form->handleRequest($request);

        $em = $this->getDoctrine()->getManager();

        $pp = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($pp);
        if (!$pp) {
            throw $this->createNotFoundException('Plano de Pensão Não Existe');
        }

        $entity->setPlanoPensao($pp);
        $entity->setAnexo(null);
        $entity->setEstado('P');
        $entity->setData(\Usoko\SIGBundle\General\DataGeneral::tempoGeral());
        $entity->setCodigo($this->codigoGerador());
        $entity->setFpagamento($request->request->get('usoko_sigbundle_beneficiopedido')['fpagamento']);

        if (Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "BeneficioPedido", "I", "Registo de Um Novo Pedido de Beneficio");
            $em->getConnection()->commit();
            $associado = CryptGeneral::encrypt($this, $entity->getPlanoPensao()->getAssociado()->getId());
            return $this->redirect($this->generateUrl('planopensao_pp', array('associado' => $associado)));
        }

        $anos = DataGeneral::diference($pp->getData(), null, 'y');

        return $this->render('UsokoSIGBundle:BeneficioPedido:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
                    'anos' => $anos,
        ));
    }

    /**
     * Creates a form to create a BeneficioPedido entity.
     *
     * @param BeneficioPedido $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(BeneficioPedido $entity, $pp) {
        $form = $this->createForm(new BeneficioPedidoType(), $entity, array(
            'action' => $this->generateUrl('beneficiopedido_create', array('pp' => $pp)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new BeneficioPedido entity.
     *
     */
    public function newAction($id) {
        $entity = new BeneficioPedido();
        $form = $this->createCreateForm($entity, $id);

        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine();
        $planopensao = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($id);

        if (!$planopensao) {
            throw $this->createNotFoundException('Unable to find BeneficioPedido entity.');
        }

        $anos = DataGeneral::diference($planopensao->getData(), null, 'y');

        return $this->render('UsokoSIGBundle:BeneficioPedido:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
                    'anos' => $anos,
        ));
    }

    /**
     * Finds and displays a BeneficioPedido entity.
     *
     */
    public function showAction($id) {

        $idR = $id;
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = new BeneficioPedido();
        $entity = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BeneficioPedido entity.');
        }

        //$associado = $entity->getPlanoPensao()->getAssociado()->getId();
        //$valortotal = $this->calcBeneficio($associado);
        $valortotal = $entity->getPlanoPensao()->getAssociado()->getSaldoliquido();

        $tempopp = DataGeneral::diference($entity->getPlanoPensao()->getData());

        $bpRespEntity = new \Usoko\SIGBundle\Entity\BeneficioResposta();
        $bpR = new BeneficioRespostaController();

        $formResposta = $bpR->createCreateForm($bpRespEntity, $idR, $this);
        $formRespostaB = $bpR->createCreateFormB($bpRespEntity, $idR, $this);

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BeneficioPedido:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
                    'formResposta' => $formResposta->createView(),
                    'formRespostaB' => $formRespostaB->createView(),
                    'valortotal' => $valortotal,
                    'tempopp' => $tempopp,
        ));
    }

    public function calcBeneficio($associado) {

        $em = $this->getDoctrine()->getManager();

        $dql = "SELECT sum(p.valor) as total "
                . "FROM UsokoSIGBundle:Pagamento p "
                . "JOIN p.associado a "
                . "JOIN p.tipopagamento t "
                . "WHERE a.id ='$associado' AND "
                . "t.tipo = 'PP' ";

        $query = $em->createQuery($dql);
        $valorTotal = isset($query->getResult()[0]['total']) ? $query->getResult()[0]['total'] : 0;
        return $valorTotal;
    }

    /**
     * Displays a form to edit an existing BeneficioPedido entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BeneficioPedido entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BeneficioPedido:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a BeneficioPedido entity.
     *
     * @param BeneficioPedido $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(BeneficioPedido $entity) {
        $form = $this->createForm(new BeneficioPedidoType(), $entity, array(
            'action' => $this->generateUrl('beneficiopedido_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing BeneficioPedido entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BeneficioPedido entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "BeneficioPedido", "U", "Actualização de Pedido de Beneficio.");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('beneficiopedido_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:BeneficioPedido:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a BeneficioPedido entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find BeneficioPedido entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "BeneficioPedido", "D", "Remoção de Um Beneficio Pedido");

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('beneficiopedido'));
    }

    /**
     * Creates a form to delete a BeneficioPedido entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('beneficiopedido_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    public function codigoGerador() {

        $mes = $this->mesSigla(DataGeneral::tempoParam("m"));
        $ano = DataGeneral::tempoParam("y");

        $data = 'BPP' . $mes . $ano;
        $repository = $this->getDoctrine()->getRepository('UsokoSIGBundle:BeneficioPedido');

        $query = $repository->createQueryBuilder('c')
                ->where('c.codigo like :cod')
                ->setParameter('cod', "$data%")
                ->getQuery();
        $comparticipacao = $query->getResult();

        $total = count($comparticipacao) + 1;

        $rand = rand(0, 9);
        $rand2 = rand(0, 9);
        $rand3 = rand(0, 9);
        return $data . $rand . $total . $rand2 . $rand3;
    }

    public function mesSigla($cod) {

        $cod--;
        $sigla = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'];
        return $sigla[$cod];
    }

}
