<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\BeneficioResposta;
use Usoko\SIGBundle\Form\BeneficioRespostaType;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\CryptGeneral;
use Usoko\SIGBundle\General\VarsGeneral;
use Symfony\Component\Form\FormError;

/**
 * BeneficioResposta controller.
 *
 */
class BeneficioRespostaController extends Controller {

    /**
     * Lists all BeneficioResposta entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:BeneficioResposta')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:BeneficioResposta:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new BeneficioResposta entity.
     *
     */
    public function createAction(Request $request, $pedido, $op) {

        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $pedidoCR = $pedido;
        $pedido = CryptGeneral::decrypt($this, $pedido);
        $pedido = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->find($pedido);

        if (!$pedido) {
            throw $this->createNotFoundException('Unable to find Beneficio Pedido entity.');
        }

        $entity = new BeneficioResposta();
        $go = true;
        $planopensao = $pedido->getPlanoPensao();

        if ($op == 'aprove') {
            $form = $this->createCreateForm($entity, $pedidoCR, $this);
            $form->handleRequest($request);

            $planopensao->setEstado('B');
            $associado = $planopensao->getAssociado();
            $associado->setPlanopensao('N');
            $em->persist($associado);

            $entity->setFpagamento($pedido->getFpagamento());
            $entity->setValorMensal($pedido->getValormensal());

            if ($entity->getValorTotal() > $associado->getSaldoliquido()) {
                $form->get('valorTotal')->addError(new FormError("Valor Total maior que o saldo Acumulado do Associado"));
                $go = false;
            }
            $passa = false;
            $tipo = VarsGeneral::CONS_COMP_RESPOSTA_APROVADO;
        } elseif ($op == 'deny') {
            $passa = true;
            $form = $this->createCreateFormB($entity, $pedidoCR, $this);
            $form->handleRequest($request);
            $tipo = VarsGeneral::CONS_COMP_RESPOSTA_REPROVADO;
        }

        $pedido->setEstado($tipo);
        $entity->setResposta($tipo);
        $entity->setData(\Usoko\SIGBundle\General\DataGeneral::tempoGeral());
        $entity->setBeneficioPedido($pedido);

        if ($passa || ($go && Validacao::validar($this, $entity))) {

            $em->persist($pedido);
            $em->persist($planopensao);
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "BeneficioResposta", "I", "Registo de Uma Nova Resposta de Beneficio.");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('beneficiopedido_list'));
        }


        return $this->render('UsokoSIGBundle:BeneficioResposta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    public function validIN($entity) {
        
    }

    public function calcBeneficio($associado) {

        $em = $this->getDoctrine()->getManager();

        $dql = "SELECT sum(p.valor) as total "
                . "FROM UsokoSIGBundle:Pagamento p "
                . "JOIN p.associado a "
                . "JOIN p.tipopagamento t "
                . "WHERE a.id ='$associado' AND "
                . "t.tipo = 'PP' ";

        $query = $em->createQuery($dql);
        $valorTotal = isset($query->getResult()[0]['total']) ? $query->getResult()[0]['total'] : 0;
        return $valorTotal;
    }

    /**
     * Creates a form to create a BeneficioResposta entity.
     *
     * @param BeneficioResposta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    public function createCreateForm(BeneficioResposta $entity, $pedido, $obj = null, $op = 'aprove') {
        if ($obj != null) {
            $form = $obj->createForm(new BeneficioRespostaType(), $entity, array(
                'action' => $obj->generateUrl('beneficioresposta_create', array('pedido' => $pedido, 'op' => $op)),
                'method' => 'POST',
            ));
        } else {
            $form = $this->createForm(new BeneficioRespostaType(), $entity, array(
                'action' => $obj->generateUrl('beneficioresposta_create', array('pedido' => $pedido, 'op' => $op)),
                'method' => 'POST',
            ));
        }

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    public function createCreateFormB(BeneficioResposta $entity, $pedido, $obj = null, $op = 'deny') {
        if ($obj == null) {
            $obj = $this;
        }
        $form = $obj->createForm(new \Usoko\SIGBundle\Form\BeneficioRespostaBType(), $entity, array(
            'action' => $obj->generateUrl('beneficioresposta_create', array('pedido' => $pedido, 'op' => $op)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new BeneficioResposta entity.
     *
     */
    public function newAction() {
        $entity = new BeneficioResposta();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:BeneficioResposta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a BeneficioResposta entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = CryptGeneral::decrypt($this, $id);

        $entity = $em->getRepository('UsokoSIGBundle:BeneficioResposta')->findBy(array('beneficioPedido' => $id));

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BeneficioResposta entity.');
        }

        //print_r($entity);
        //die;
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BeneficioResposta:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing BeneficioResposta entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:BeneficioResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BeneficioResposta entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:BeneficioResposta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a BeneficioResposta entity.
     *
     * @param BeneficioResposta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(BeneficioResposta $entity) {
        $form = $this->createForm(new BeneficioRespostaType(), $entity, array(
            'action' => $this->generateUrl('beneficioresposta_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing BeneficioResposta entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:BeneficioResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find BeneficioResposta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "BeneficioResposta", "U", "Actualização de Uma Resposta de Beneficio");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('beneficioresposta_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:BeneficioResposta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a BeneficioResposta entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:BeneficioResposta')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find BeneficioResposta entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "BeneficioResposta", "D", "Remoção de Uma Resposta de Beneficio.");
            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('beneficioresposta'));
    }

    /**
     * Creates a form to delete a BeneficioResposta entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('beneficioresposta_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
