<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Dependente;
use Usoko\SIGBundle\Form\DependenteType;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * Dependente controller.
 *
 */
class DependenteController extends Controller {

    /**
     * Lists all Dependente entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Dependente')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );


        return $this->render('UsokoSIGBundle:Dependente:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Dependente entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Dependente();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Dependente", "I", "Registo de Um Novo Dependente");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('dependente_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:Dependente:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Dependente entity.
     *
     * @param Dependente $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Dependente $entity) {
        $form = $this->createForm(new DependenteType(), $entity, array(
            'action' => $this->generateUrl('dependente_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new Dependente entity.
     *
     */
    public function newAction() {
        $entity = new Dependente();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Dependente:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Dependente entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Dependente')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Dependente entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Dependente:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Dependente entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Dependente')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Dependente entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Dependente:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Dependente entity.
     *
     * @param Dependente $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Dependente $entity) {
        $form = $this->createForm(new DependenteType(), $entity, array(
            'action' => $this->generateUrl('dependente_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing Dependente entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:Dependente')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Dependente entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Dependente", "U", "Actualização de Um Dependente");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('dependente_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Dependente:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Dependente entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Dependente')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Dependente entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Dependente", "D", "Remoção de Um Dependente");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('dependente'));
    }

    /**
     * Creates a form to delete a Dependente entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('dependente_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

}
