<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Distribuicaorendimento;
use Usoko\SIGBundle\Form\DistribuicaorendimentoType;
use Usoko\SIGBundle\General\DataGeneral;
use Usoko\SIGBundle\Entity\BeneficioPagamento;
use Usoko\SIGBundle\General\NumeroReal;

/**
 * Distribuicaorendimento controller.
 *
 */
class DistribuicaorendimentoController extends Controller {

    /**
     * Lists all Distribuicaorendimento entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Distribuicaorendimento')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Distribuicaorendimento:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Distribuicaorendimento entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Distribuicaorendimento();
        $entity->setValorrendimento((double) $this->valor($request));
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entities = $em->getRepository('UsokoSIGBundle:PlanoPensao')->findBy(array('estado' => 'A'));
        $totalplanopensao = count($entities);
        $valorplanopensao = ((double) $this->valor($request)) / $totalplanopensao;

        $entity->setTotalplanopensao($totalplanopensao);
        $entity->setValorplanopensao($valorplanopensao);

        $planopensao = new \Usoko\SIGBundle\Entity\PlanoPensao();

        foreach ($entities as $planopensao) {

            $associado = $planopensao->getAssociado();
            $associado->setSaldoliquido($associado->getSaldoliquido() + $valorplanopensao);

            $beneficio = new BeneficioPagamento();
            $beneficio->setMesAno(date('m') . '-' . date('Y'));
            $beneficio->setEstado('L');
            $beneficio->setPlanopensao($planopensao);
            $beneficio->setTipo('D');
            $beneficio->setValor($valorplanopensao);
            $beneficio->setDataActual(DataGeneral::tempoGeral());

            $em->persist($associado);
            $em->persist($beneficio);
            $em->flush();
        }

        if ($form->isValid()) {
            $entity->setValorrendimento((double) $this->valor($request));
            $em->persist($entity);
            $em->flush();

            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('distribuicaorendimento_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:Distribuicaorendimento:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Distribuicaorendimento entity.
     *
     * @param Distribuicaorendimento $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Distribuicaorendimento $entity) {
        $form = $this->createForm(new DistribuicaorendimentoType(), $entity, array(
            'action' => $this->generateUrl('distribuicaorendimento_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Distribuicaorendimento entity.
     *
     */
    public function newAction() {
        $entity = new Distribuicaorendimento();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Distribuicaorendimento:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Distribuicaorendimento entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Distribuicaorendimento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Distribuicaorendimento entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Distribuicaorendimento:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Distribuicaorendimento entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Distribuicaorendimento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Distribuicaorendimento entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Distribuicaorendimento:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Distribuicaorendimento entity.
     *
     * @param Distribuicaorendimento $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Distribuicaorendimento $entity) {
        $form = $this->createForm(new DistribuicaorendimentoType(), $entity, array(
            'action' => $this->generateUrl('distribuicaorendimento_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Distribuicaorendimento entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Distribuicaorendimento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Distribuicaorendimento entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            return $this->redirect($this->generateUrl('distribuicaorendimento_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Distribuicaorendimento:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Distribuicaorendimento entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:Distribuicaorendimento')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Distribuicaorendimento entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('distribuicaorendimento'));
    }

    /**
     * Creates a form to delete a Distribuicaorendimento entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('distribuicaorendimento_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    private function valor($request) {
        $valor = $request->request->get('usoko_sigbundle_distribuicaorendimento')['valorrendimento'];
        $valor = NumeroReal::converter($valor);
        return $valor;
    }

}
