<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
//use PHPExcel;
//use PHPExcel_IOFactory;
use PHPExcel_Worksheet_PageSetup;
use PHPExcel_Style_Alignment;
use PHPExcel_CachedObjectStorageFactory;
use PHPExcel_Settings;
use PHPExcel_Worksheet_Drawing;
use PHPExcel_Style_Border;
use PHPExcel_Style_Fill;
use Usoko\SIGBundle\General\DataGeneral;
use Usoko\SIGBundle\General\FuncaoGeneral;
use Usoko\SIGBundle\General\VarsGeneral;

class ExcelController extends Controller {

    public function registoNovosAssociadosExcelAction(Request $request) {

        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');

            $Cdata1 = (string) ($data1);
            $Cdata2 = (string) ($data2);

            $ano1 = substr($Cdata1, 0, 4);
            $mes1 = substr($Cdata1, 5, 2);

            $Cdata1 = $mes1 . "-" . $ano1;

            $ano2 = substr($Cdata2, 0, 4);
            $mes2 = substr($Cdata2, 5, 2);

            $Cdata2 = $mes2 . "-" . $ano2;

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'SEIES-RA');

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Nome e Codigo IES');

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Universidade Agostinho Neto');
            //$objPHPExcel->getActiveSheet()->getStyle("K" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('76933C'); //COR DO FUNDO

            $l++;
            //$objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'GABINETE DE ESTUDOS PLANEAMENTO E ESTATÍSTICA');

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("H" . $l, '' . "Waka waka");
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setSize(14);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":G" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de novos Associados');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */

            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Província');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Data de Ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Valor Jóia');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Valor Quota');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Status do Pagamento');

            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":K" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":K" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    registoNovosAssociadosExcel($data1, $data2);

            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]['MECANOGR']);
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]->getAssociado()->getPessoa()->getNome());

                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $pagamentos[$i]->getAssociado()->getOrgao()->getNome());


                //$objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, DataGeneral::idadeValida($pagamentos[$i]['DataNascimento']));
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $pagamentos[$i]->getAssociado()->getCargo()->getCargo());

                $provincia = "";
                foreach ($pagamentos[$i]->getAssociado()->getPessoa()->getEndereco() as $ende) {
                    $provincia = $ende->getProvincia()->getNome();
                    break;
                }

                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, $provincia);

                $data = FuncaoGeneral::object2Array($pagamentos[$i]->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($data)));

                if ($pagamentos[$i]->getTipopagamento()->getTipo() == 'J') {
                    $pagamJoia = $pagamentos[$i]->getValor();
                    $pagamQuota = "";
                }


                if ($pagamentos[$i]->getTipopagamento()->getTipo() == 'Q') {
                    $pagamQuota = $pagamentos[$i]->getValor();
                    $pagamJoia = "";
                }

                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, $pagamentos[$i]->getTipopagamento()->getTipo() == 'J' ?
                                number_format($pagamentos[$i]->getValor(), 2, ',', '.') : "--");

                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, $pagamentos[$i]->getTipopagamento()->getTipo() == 'Q' ?
                                number_format($pagamentos[$i]->getValor(), 2, ',', '.') : "--");
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, $pagamentos[$i]->getMesAno());

                $estad = $pagamentos[$i]->getEstado();
                if ($estad == 'L') {
                    $estad = "Liquidado";
                } else {
                    $estad = "Não Liquidado";
                }
                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, $estad);

                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":K" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":K" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            }

            $nome = 'registoNovosAssociados - ' . date('Y') . '.xls';
            header('Content-Type: application/xlsx');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');


// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0

            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");

            ob_end_clean();
            $objWriter->save('php://output');
            exit;
        } else {
            return $this->render("UsokoSIGBundle:Excel:registoNovosAssociadosExcel.html.twig");
        }
    }

    public function associadosExistentesExcelAction(Request $request) {


        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;
// Set document properties
            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('associadosExistentesExcel');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 14,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'SEIES-RA');

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Nome e Codigo IES');

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Universidade Agostinho Neto');
            //$objPHPExcel->getActiveSheet()->getStyle("K" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('76933C'); //COR DO FUNDO

            $l++;
            //$objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'GABINETE DE ESTUDOS PLANEAMENTO E ESTATÍSTICA');

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("H" . $l, '' . "Waka waka");
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":G" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Associados Existentes ');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */

            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");


//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Data de Nascimento');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Sexo');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Data de ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Local de Trabalho');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Habilitações Literárias');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Salário');
            $objPHPExcel->getActiveSheet()->setCellValue("L" . $l, 'Quota');
            $objPHPExcel->getActiveSheet()->setCellValue("M" . $l, 'Total de Outros rend.');
            $objPHPExcel->getActiveSheet()->setCellValue("N" . $l, 'Nº. de agregados');
            $objPHPExcel->getActiveSheet()->setCellValue("O" . $l, 'Nº. de beneficios usufruidos');
            $objPHPExcel->getActiveSheet()->setCellValue("P" . $l, 'Participante do Plano de Pensão');
            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":P" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":P" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23b7de'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(11);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();



            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->associadosExistentesExcel($data1, $data2);
            //$pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->findAll();



            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]['MECANOGR']);
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]['NOMEDELE']);
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime(FuncaoGeneral::object2Array($pagamentos[$i]['DATANASCIMENTO']))));
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $pagamentos[$i]['GENERO'] == 'F' ? "Feminino" : "Masculino");
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime(FuncaoGeneral::object2Array($pagamentos[$i]['DATAADMISSAO']))));
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, $pagamentos[$i]['CARGO']);
                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, $pagamentos[$i]['ORGAO']);
                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, is_null($pagamentos[$i]['SALARIOLIQUIDO']) ? "0" : number_format($pagamentos[$i]['SALARIOLIQUIDO'], 2, ',', '.'));

                $quota = $em->getRepository('UsokoSIGBundle:Pagamento')->QuotaAssociado($pagamentos[$i]['CODIGOASSOCIADO']);

                $objPHPExcel->getActiveSheet()->setCellValue("L" . $pos, is_null($quota) ? "0" : number_format($quota, 2, ',', '.'));

                $totalOutrosRend = $em->getRepository('UsokoSIGBundle:Pagamento')->pagamentosExtra($pagamentos[$i]['CODIGOASSOCIADO']);
                $objPHPExcel->getActiveSheet()->setCellValue("M" . $pos, is_null($totalOutrosRend) ? "0" : $totalOutrosRend);

                $totalAgregado = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findBy(array('associado' => $pagamentos[$i]['CODIGOASSOCIADO']));
                $objPHPExcel->getActiveSheet()->setCellValue("N" . $pos, count($totalAgregado));


                $numBeneficios = $em->getRepository('UsokoSIGBundle:Pagamento')->numeroDeBeneficiosUsufruidoAssociado($pagamentos[$i]['CODIGOASSOCIADO']);

                $objPHPExcel->getActiveSheet()->setCellValue("O" . $pos, is_null($numBeneficios) ? "0" : $numBeneficios);



                $objPHPExcel->getActiveSheet()->setCellValue("P" . $pos, $pagamentos[$i]['PLANOPENSAO'] == 'N' ? "Não" : "Sim");

                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":P" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":P" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":P" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            }

            $nome = 'associadosExistentes - ' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');


// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:associadosExistentesExcel.html.twig");
        }

    }

    public function registoQuotasExcelAction(Request $request) {


        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;
// Set document properties
            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 14,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'SEIES-RA');

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Nome e Codigo IES');

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Universidade Agostinho Neto');
            //$objPHPExcel->getActiveSheet()->getStyle("K" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('76933C'); //COR DO FUNDO

            $l++;
            //$objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'GABINETE DE ESTUDOS PLANEAMENTO E ESTATÍSTICA');

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("H" . $l, '' . "Waka waka");
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":G" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de quotas');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":M" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(35);

            /* INICIO DA TABELA */

            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecan.');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Nº. da conta bancária');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Província');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Data de Ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Valor da Quota');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("L" . $l, 'Natureza');
            $objPHPExcel->getActiveSheet()->setCellValue("M" . $l, 'Status do Pagamento');

            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":M" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":M" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(21);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(11);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();


            $registoQuot = $em->getRepository('UsokoSIGBundle:Pagamento')->todasQuotaAssociado($data1, $data2);
            //todasQuotaAssociado
            //$registoQuot = $em->getRepository('UsokoSIGBundle:Pagamento')->registoQuotas($data1, $data2);

            $totalQPagas = 0;

            for ($i = 0, $pos = $l + 1; $i < count($registoQuot); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $registoQuot[$i]->getAssociado()->getNmecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $registoQuot[$i]->getAssociado()->getPessoa()->getNome());


                $contaBancaria = "";

                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $registoQuot[$i]->getAssociado()->getConta() ? $registoQuot[$i]->getAssociado()->getConta()->getNumero() : " ");
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $registoQuot[$i]->getAssociado()->getCargo()->getCargo());
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, $registoQuot[$i]->getAssociado()->getOrgao()->getNome());


                $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($registoQuot[$i]->getAssociado()->getId());
                $provincia = "";
                foreach ($associado->getPessoa()->getEndereco() as $ende) {
                    $provincia = $ende->getProvincia()->getNome();
                    break;
                }

                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, $provincia);


                $data = FuncaoGeneral::object2Array($registoQuot[$i]->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos,FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($data)));

                if ($registoQuot[$i]->getAssociado()->getStatus() == 'A') {
                    $status = "Activo";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'R') {
                    $status = "Reformado";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'I') {
                    $status = "Inactivo";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'F') {
                    $status = "Falecido";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'D') {
                    $status = "Desvinculado";
                }


                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, $status);
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, number_format($registoQuot[$i]->getValor(), 2, ',', '.'));

                $totalQPagas = $totalQPagas + $registoQuot[$i]->getValor();
                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, $registoQuot[$i]->getMesAno());
                $objPHPExcel->getActiveSheet()->setCellValue("L" . $pos, "Normal");
                $objPHPExcel->getActiveSheet()->setCellValue("M" . $pos, ($registoQuot[$i]->getEstado() == 'L') ? "Liquidado" : "Não liquidado");

                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":M" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("M1:M6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":M" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":C" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
//RODAPE
                $l = $pos + 1;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'TOTAL DE QUOTAS PAGAS: ' . number_format($totalQPagas, 2, ',', '.') . " Akz");
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'VALOR POR EXTENSO: ' . FuncaoGeneral::valorPorExtenso($totalQPagas, FALSE) . " Kwanzas");
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'TOTAL DE QUOTAS AVULSO PAGAS: ');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'VALOR POR EXTENSO: ');
                $l++;
                // Redirect output to a client’s web browser (Excel2007)
            }

            $nome = 'registoQuotas - ' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');


// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {

            return $this->render("UsokoSIGBundle:Excel:registoQuotasExcel.html.twig");
        }
    }

    public function controlodeQuotasExcelAction(Request $request) {

        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;
// Set document properties
            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 14,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'SEIES-RA');

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Nome e Codigo IES');

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Universidade Agostinho Neto');
            //$objPHPExcel->getActiveSheet()->getStyle("K" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('76933C'); //COR DO FUNDO

            $l++;
            //$objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'GABINETE DE ESTUDOS PLANEAMENTO E ESTATÍSTICA');

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("H" . $l, '' . "Waka waka");
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":G" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Controlo de quotas pagas');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":M" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(35);


			$objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");



            /* INICIO DA TABELA */

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecan.');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Nº. da conta bancária');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Província');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Data de Ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Valor da Quota');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("L" . $l, 'Natureza');
            $objPHPExcel->getActiveSheet()->setCellValue("M" . $l, 'Data de Pagamento');

            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":M" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":M" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(21);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(11);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();


            $registoQuot = $em->getRepository('UsokoSIGBundle:Pagamento')->controloQuotas($data1, $data2);
            //todasQuotaAssociado
            //$registoQuot = $em->getRepository('UsokoSIGBundle:Pagamento')->registoQuotas($data1, $data2);

            $totalQPagas = 0;

            for ($i = 0, $pos = $l + 1; $i < count($registoQuot); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $registoQuot[$i]->getAssociado()->getNmecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $registoQuot[$i]->getAssociado()->getPessoa()->getNome());


                $contaBancaria = "";

                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $registoQuot[$i]->getAssociado()->getConta() ? $registoQuot[$i]->getAssociado()->getConta()->getNumero() : " ");
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $registoQuot[$i]->getAssociado()->getCargo()->getCargo());
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, $registoQuot[$i]->getAssociado()->getOrgao()->getNome());


                $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($registoQuot[$i]->getAssociado()->getId());
                $provincia = "";
                foreach ($associado->getPessoa()->getEndereco() as $ende) {
                    $provincia = $ende->getProvincia()->getNome();
                    break;
                }

                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, $provincia);


                $data = FuncaoGeneral::object2Array($registoQuot[$i]->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($data)));

                if ($registoQuot[$i]->getAssociado()->getStatus() == 'A') {
                    $status = "Activo";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'R') {
                    $status = "Reformado";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'I') {
                    $status = "Inactivo";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'F') {
                    $status = "Falecido";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'D') {
                    $status = "Desvinculado";
                }


                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, $status);
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, number_format($registoQuot[$i]->getValor(), 2, ',', '.'));

                $totalQPagas = $totalQPagas + $registoQuot[$i]->getValor();
                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, $registoQuot[$i]->getMesAno());
                $objPHPExcel->getActiveSheet()->setCellValue("L" . $pos, "Normal");



                $dataPagamentoQuota = FuncaoGeneral::object2Array($registoQuot[$i]->getDataActual());
                $objPHPExcel->getActiveSheet()->setCellValue("M" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataPagamentoQuota)));


                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":K" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":M" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("M1:M6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":M" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//RODAPE
                $l = $pos + 1;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'TOTAL DE QUOTAS PAGAS: ' . number_format($totalQPagas, 2, ',', '.') . " Akz");
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'VALOR POR EXTENSO: ' . FuncaoGeneral::valorPorExtenso($totalQPagas, FALSE) . " Kwanzas");
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'TOTAL DE QUOTAS AVULSO PAGAS: ');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'VALOR POR EXTENSO: ');
                $l++;
                // Redirect output to a client’s web browser (Excel2007)
            }

            $nome = 'controlodeQuotas - ' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');


// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {

            return $this->render("UsokoSIGBundle:Excel:controlodeQuotasExcel.html.twig");
        }
    }

    public function registoSubsidiosExcelAction(Request $request) {



        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;
// Set document properties
            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 14,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'SEIES-RA');

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;
            //$objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'GABINETE DE ESTUDOS PLANEAMENTO E ESTATÍSTICA');

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            //$objPHPExcel->getActiveSheet()->setCellValue("H" . $l, '' . "Waka waka");
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":G" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);


            //
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de subsídios concedidos');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":N" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(35);

			$objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");


            /* INICIO DA TABELA */

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecan.');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Nº. da conta bancária');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Data de Ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Valor do Subsídio');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Natureza do Subsídio');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Data da concessão');
            $objPHPExcel->getActiveSheet()->setCellValue("L" . $l, 'Tipo de Beneficiário');
            $objPHPExcel->getActiveSheet()->setCellValue("M" . $l, 'Nome do Beneficiário');
            $objPHPExcel->getActiveSheet()->setCellValue("N" . $l, 'Grau de Parentesco com o Associado');

            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":N" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":N" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(22);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(38);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(24);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $registoQuot = $em->getRepository('UsokoSIGBundle:Pagamento')->registoSubsidiosExcel($data1, $data2);

            $totalQPagas = 0;

            for ($i = 0, $pos = $l + 1; $i < count($registoQuot); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $registoQuot[$i]->getAssociado()->getNmecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $registoQuot[$i]->getAssociado()->getPessoa()->getNome());


                $contaBancaria = "";


                if ($registoQuot[$i]->getAssociado()->getStatus() == 'A') {
                    $status = "Activo";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'R') {
                    $status = "Reformado";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'I') {
                    $status = "Inactivo";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'F') {
                    $status = "Falecido";
                } else if ($registoQuot[$i]->getAssociado()->getStatus() == 'D') {
                    $status = "Desvinculado";
                }

                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $status);
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $registoQuot[$i]->getAssociado()->getCargo()->getCargo());
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, $registoQuot[$i]->getAssociado()->getConta()->getNumero());


                $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($registoQuot[$i]->getAssociado()->getId());
                $provincia = "";
                foreach ($associado->getPessoa()->getEndereco() as $ende) {
                    $provincia = $ende->getProvincia()->getNome();
                    break;
                }

                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, $provincia);


                $data = FuncaoGeneral::object2Array($registoQuot[$i]->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($data)));



                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, number_format($registoQuot[$i]->getValor(), 2, ',', '.'));
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, $registoQuot[$i]->getSubsidio()->getCategoria()->getNome());


                $dataConcessao = FuncaoGeneral::object2Array($registoQuot[$i]->getDataActual());

                $totalQPagas = $totalQPagas + $registoQuot[$i]->getValor();
                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataConcessao)));

                if ($registoQuot[$i]->getDependente()) {
                    $nomeDependente = $registoQuot[$i]->getDependente()->getPessoa()->getNome();
                    $grau = "Agregado";
                    $assocDepObj = $em->getRepository("UsokoSIGBundle:AssociadoDependentes")->findBy(array('dependentes' => $registoQuot[$i]->getDependente()->getId()));
                    $assocDep = $assocDepObj[0]->getGrauparentesco()->getNome();
                } else {
                    $nomeDependente = "";
                    $grau = "Associado";
                    $assocDep = "";
                }

                $objPHPExcel->getActiveSheet()->setCellValue("L" . $pos, $grau);

                $objPHPExcel->getActiveSheet()->setCellValue("M" . $pos, $nomeDependente);
                $objPHPExcel->getActiveSheet()->setCellValue("N" . $pos, $assocDep);

                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":K" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":N" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("M1:M6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":M" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->setActiveSheetIndex()->getStyle("B" . $lin . ":B" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				$objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":C" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				$objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":M" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
//RODAPE
                $l = $pos + 1;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'TOTAL DE QUOTAS PAGAS: ' . number_format($totalQPagas, 2, ',', '.') . " Akz");
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'VALOR POR EXTENSO: ' . FuncaoGeneral::valorPorExtenso($totalQPagas, FALSE) . " Kwanzas");
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, '');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'TOTAL DE QUOTAS AVULSO PAGAS: ');
                $l++;
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'VALOR POR EXTENSO: ');
                $l++;
                // Redirect output to a client’s web browser (Excel2007)
            }

            $nome = 'registoSubsidios - ' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');


// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {

            return $this->render("UsokoSIGBundle:Excel:registoSubsidiosExcel.html.twig");
        }
    }

    public function listaVencimentoPlanoExcelAction(Request $request) {
        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');


            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":G" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de Vencimento de planos');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

			$objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");

            /* INICIO DA TABELA */

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Sexo');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Data de Nascimento');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Data de Admissão');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Data de vencimento');

            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(18);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(18);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    listaVencimentoPlano($data1, $data2);

            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]->getPlanoPensao()->getAssociado()->getNMecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]->getPlanoPensao()->getAssociado()->getPessoa()->getNome());
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, ($pagamentos[$i]->getPlanoPensao()->getAssociado()->getPessoa()->getGenero() == 'M') ? " Masculino" : "Feminino");

                $dataNasc = FuncaoGeneral::object2Array($pagamentos[$i]->getPlanoPensao()->getAssociado()->getPessoa()->getDataNascimento());
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataNasc)));

                $dataAdmissao = FuncaoGeneral::object2Array($pagamentos[$i]->getPlanoPensao()->getData());
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataAdmissao)));

                $data = FuncaoGeneral::object2Array($pagamentos[$i]->getPlanoPensao()->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($data)));

                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":G" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":G" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            }

            $nome = 'listaVencimentoPlanoExcel - ' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');

            header('Cache-Control: max-age=1');

            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:pp/listaVencimentoPlanoExcel.html.twig");
        }
    }

    public function listaParticipantesReformadosExcelAction(Request $request) {
        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');


            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":J" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de Participantes Reformados ');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */

			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

			$objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");


//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Sexo');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Data de Nascimento');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Data de Admissão');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Data de Reforma');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Natureza');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Capital acumulado na data da reforma');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Moeda');

            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(14);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    listaParticipantesReformados($data1, $data2);

            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]->getNMecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]->getPessoa()->getNome());
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, ($pagamentos[$i]->getPessoa()->getGenero() == 'M') ? "Masculino" : "Feminino");

                $dataNasc = FuncaoGeneral::object2Array($pagamentos[$i]->getPessoa()->getDataNascimento());
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataNasc)));

                $dataAdmissao = FuncaoGeneral::object2Array($pagamentos[$i]->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataAdmissao)));

                //$dataReforma = FuncaoGeneral::object2Array($pagamentos[$i]->getDataAdmissao());
                //$objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataReforma)));
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, "...");
                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, "Velhice");


                $capitalAcum = $em->getRepository("UsokoSIGBundle:Pagamento")->capitalAcumulado($pagamentos[$i]->getId());
                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, number_format($capitalAcum, 2, ',', '.'));
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, "AKZ");


                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":J" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":J" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->setActiveSheetIndex()->getStyle("B" . $lin . ":B" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            }

            $nome = 'listaParticipantesReformadosExcel - ' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');

            header('Cache-Control: max-age=1');

            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:pp/listaParticipantesReformadosExcel.html.twig");
        }
    }

    public function registoBeneficioPagoExcelAction(Request $request) {
        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');


            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":J" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de Benefícios Pagos ');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */
			$objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");


//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Data de Ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Data de Pagamento');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Descrição do Pagamento');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Valor');


            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":I" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":I" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(16);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    registoBeneficioPago($data1, $data2, 'PP');

            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]->getAssociado()->getNMecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]->getAssociado()->getPessoa()->getNome());
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $pagamentos[$i]->getAssociado()->getStatus() == 'A' ? " Activo " : " Reformado ");

                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $pagamentos[$i]->getAssociado()->getOrgao()->getNome());
                $dataAdmissao = FuncaoGeneral::object2Array($pagamentos[$i]->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataAdmissao)));

                $dataPagamento = FuncaoGeneral::object2Array($pagamentos[$i]->getDataActual());
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataPagamento)));

                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, "...");

                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, number_format($pagamentos[$i]->getValor(), 2, ',', '.'));
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":I" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":I" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				$objPHPExcel->setActiveSheetIndex()->getStyle("B" . $lin . ":B" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				$objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":C" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            }

            $nome = 'registoBeneficioPagoExcel-' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');

            header('Cache-Control: max-age=1');

            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:registoBeneficioPagoExcel.html.twig");
        }
    }

    public function registoContribuicoesExcelAction(Request $request) {
        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');


            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":J" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de Contribuições ');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */
			$objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");
			$objPHPExcel->getActiveSheet()->setCellValue("I" . 8, "  ");
			$objPHPExcel->getActiveSheet()->setCellValue("J" . 8, "  ");
			$objPHPExcel->getActiveSheet()->setCellValue("K" . 8, "  ");

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Data de Ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Descrição do movimento');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Valor');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Data de Pagamento');


            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":K" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":K" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(14);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    registoContribuicoes($data1, $data2, 'PP', 'L');

            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]->getAssociado()->getNMecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]->getAssociado()->getPessoa()->getNome());
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, !($pagamentos[$i]->getAssociado()->getCargo()) ? "" : $pagamentos[$i]->getAssociado()->getCargo()->getCargo());
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, $pagamentos[$i]->getAssociado()->getStatus() == 'A' ? " Activo " : " Reformado ");
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, $pagamentos[$i]->getAssociado()->getOrgao()->getNome());

                $dataAdmissao = FuncaoGeneral::object2Array($pagamentos[$i]->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataAdmissao)));

                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, "...");
                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, number_format($pagamentos[$i]->getValor(), 2, ',', '.'));
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, $pagamentos[$i]->getMesAno());

                $dataPagamento = FuncaoGeneral::object2Array($pagamentos[$i]->getDataActual());
                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataPagamento)));




                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":K" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":K" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->setActiveSheetIndex()->getStyle("B" . $lin . ":B" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				$objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":C" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            }

            $nome = 'registoContribuicoesExcel-' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');

            header('Cache-Control: max-age=1');

            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:pp/registoContribuicoesExcel.html.twig");
        }
    }

    public function registoDeAmortizacaoCreditoExcelAction(Request $request) {
        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');


            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setSize(16);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":J" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de Amortização de Créditos Internos ');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setBold(true);



//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */

             $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");

//Cabeçalho da Tabela
            $l = 9;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Nº. da Conta Bancária');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Categoria');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Data de ingresso');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Valor do Crédito');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Tipo do Crédito');
            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Valor da Amortização');
            $objPHPExcel->getActiveSheet()->setCellValue("L" . $l, 'Natureza da Amortização');
            $objPHPExcel->getActiveSheet()->setCellValue("M" . $l, 'Juros');
            $objPHPExcel->getActiveSheet()->setCellValue("N" . $l, 'Valor da Prestação Mensal');
            $objPHPExcel->getActiveSheet()->setCellValue("O" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("P" . $l, 'Valor em dívida');


            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":P" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":P" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('23B7DE'); //COR DO FUNDO

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(16);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(24);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(14);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamentos = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    registoDeAmortizacoes($data1, $data2);

            for ($i = 0, $pos = $l + 1; $i < count($pagamentos); $i++, $pos++) {
                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamentos[$i]->getCreditoPedido()->getAssociado()->getNMecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamentos[$i]->getCreditoPedido()->getAssociado()->getPessoa()->getNome());
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $pagamentos[$i]->getCreditoPedido()->getAssociado()->getStatus() == 'A' ? " Activo " : " Reformado ");
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, ($pagamentos[$i]->getCreditoPedido()->getAssociado()->getConta()) ? $pagamentos[$i]->getCreditoPedido()->getAssociado()->getConta()->getNumero() : " ");
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, !($pagamentos[$i]->getCreditoPedido()->getAssociado()->getCargo()) ? "" : $pagamentos[$i]->getCreditoPedido()->getAssociado()->getCargo()->getCargo());
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, ($pagamentos[$i]->getCreditoPedido()->getAssociado()->getOrgao()) ? $pagamentos[$i]->getCreditoPedido()->getAssociado()->getOrgao()->getNome() : " ");

                $dataIngresso = FuncaoGeneral::object2Array($pagamentos[$i]->getCreditoPedido()->getAssociado()->getDataAdmissao());
                $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime($dataIngresso)));

                $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, number_format($pagamentos[$i]->getValorpagar(), 2, ',', '.'));
                $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, $pagamentos[$i]->getCreditoPedido()->getTipoCredito()->getNome());

                $paym = "";
                $mese = "";

                $tipopagamento = $em->getRepository("UsokoSIGBundle:Tipopagamento")->findBy(array("tipo" => "C"));

                $pagaCredAssoc = $em->getRepository("UsokoSIGBundle:Pagamento")->findBy(
                        array("tipopagamento" => $tipopagamento[0]->getId(),
                            "associado" => $pagamentos[$i]->getCreditoPedido()->getAssociado()->getId()));

                $qtdPagamentoCredito = count($pagaCredAssoc);


                if ($pagaCredAssoc) {
                    foreach ($pagaCredAssoc as $payments) {
                        $paym = $payments->getValor();
                        $mese = $payments->getMesAno();
                        break;
                    }
                }

                $taxa = $em->getRepository("UsokoSIGBundle:CreditoPlafond")->findOneBy(array('ano' => date('Y')));

                $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, number_format((($pagamentos[$i]->getValorpagar() / $pagamentos[$i]->getTempoAmortizacao()) + ($taxa->getTaxajuros() / 100) * ($pagamentos[$i]->getValorpagar() - $qtdPagamentoCredito * $pagamentos[$i]->getCreditoPedido()->getValorMensal())), 2, ',', '.'));
                // $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, $paym);
                $objPHPExcel->getActiveSheet()->setCellValue("L" . $pos, "Crédito Interno Normal");
                $objPHPExcel->getActiveSheet()->setCellValue("M" . $pos, $taxa->getTaxajuros());
                $objPHPExcel->getActiveSheet()->setCellValue("N" . $pos, number_format($pagamentos[$i]->getCreditoPedido()->getValorMensal(), 2, ',', '.'));
                $objPHPExcel->getActiveSheet()->setCellValue("O" . $pos, $mese);
                $objPHPExcel->getActiveSheet()->setCellValue("P" . $pos, number_format($pagamentos[$i]->getValorpagar() - (($pagamentos[$i]->getValorpagar() / $pagamentos[$i]->getTempoAmortizacao()) + ($taxa->getTaxajuros() / 100) * ($pagamentos[$i]->getValorpagar() - $qtdPagamentoCredito * $pagamentos[$i]->getCreditoPedido()->getValorMensal())), 2, ',', '.'));



                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":P" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":P" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            }

            $nome = 'registoDeAmortizacaoCreditoExcel-' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');

            header('Cache-Control: max-age=1');

            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:credito/registoDeAmortizacaoCreditoExcel.html.twig");
        }
    }

    public function registoDeBeneficiosConcedidosExcelAction(Request $request) {
        if ($request->getMethod() == 'POST') {

            $data1 = $request->request->get('dtaini');
            $data2 = $request->request->get('dtafim');


            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod);
            $locale = 'pt';
            $validLocale = PHPExcel_Settings::setLocale($locale);
            if (!$validLocale) {
                PHPExcel_Settings::setLocale('en_us');
            }

            $objPHPExcel = new \PHPExcel;

            $objPHPExcel->getProperties()->setCreator("USOKO")
                    ->setLastModifiedBy("Usoko - " . date('Y-m-d'))
                    ->setTitle("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL ")
                    ->setSubject("REGISTO PRIMARIO DE BASE DE DADOS MATRICULA INICIAL  - Usoko")
                    ->setKeywords("Matricula registo base de dados inicial gepe ies")
                    ->setCategory("Usoko");

            // Rename worksheet
            $objPHPExcel->getActiveSheet(0);
            $objPHPExcel->getActiveSheet()->setTitle('Pagamentos');
            $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()->getProtection()->setSheet(FALSE);
            $objPHPExcel->getActiveSheet()->setShowGridlines(FALSE);
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Bookman Old Style');
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(11);

            $objImg = new PHPExcel_Worksheet_Drawing();
            $DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
            $objImg->setName('Logo');
            $objImg->setDescription('Logo');
            $objImg->SetPath($DOCUMENT_ROOT . '/gam/web/img/nossas/logo4.png');
            $objImg->setCoordinates('A3');
            $objImg->setHeight(65);
            $objImg->setOffsetX(10);

            $objImg->setWorksheet($objPHPExcel->getActiveSheet());
            $l = 2;

//Configuraçoes Iniciais

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G4")->getFont()->setSize(10); //tamanho da letra
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":T6")->getFont()->setName('Bookman Old Style'); //tipo de letra do cabeçalho
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":G5")->getFont()->setBold(true); //negritar o cabeçalho

            $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);


            $objPHPExcel->getActiveSheet()->getStyle('A2:J6')->applyFromArray(
                    array('borders' => array(
                            'outline' => array(
                                'style' => \PHPExcel_Style_Border::BORDER_THIN, 'color' => array('argb' => '000000'),
                            ),),
                        'font' => array(
                            'name' => 'Bookman Old Style',
                            'size' => 12,
                        ),
            ));

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":B" . $l);
            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  República de Angola');

            /* cabeçalho direito  */
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G" . $l . ":J" . $l);

            $l++;
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B" . $l . ":F" . $l);
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, '  Associação Mutualista');
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . $l . ":L" . $l);

            $l++;

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . $l . ":J" . $l);
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l)->getFont()->setBold(TRUE);

            $objPHPExcel->getActiveSheet()->getStyle("A" . ($l + 1) . ":J" . ($l + 1))->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A1:T" . $l)->getFont()->setItalic(FALSE);

            $l+=2;
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setSize(14);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . $l . ":J" . $l);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension($l)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Registo de Benefícios Concedidos aos Associados');
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":J" . $l)->getFont()->setBold(true);


//TAMANHO DAS COLUNAS
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

            /* INICIO DA TABELA */

            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . $l)->getFont()->setSize(18);
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":H" . 8);
            $objPHPExcel->setActiveSheetIndex(0)->getRowDimension(8)->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getStyle("A" . 8 . ":H" . 8)->getFont()->setBold(true);

//Cabeçalho da Tabela


            $objPHPExcel->getActiveSheet()->setCellValue("A" . 8, " Período : " . FuncaoGeneral::converteDataParaDiaMesAno($data1) . " à " . FuncaoGeneral::converteDataParaDiaMesAno($data2));
            $objPHPExcel->getActiveSheet()->setCellValue("B" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("C" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("D" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("E" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("F" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("G" . 8, "  ");
            $objPHPExcel->getActiveSheet()->setCellValue("H" . 8, "  ");

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A" . 8 . ":AN" . 8);


            $objPHPExcel->getActiveSheet()->getStyle("A" . 9 . ":AN" . 9)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A8:AN9")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
            $objPHPExcel->getActiveSheet()->getStyle("A8:AN9")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);



            $objPHPExcel->getActiveSheet()->setCellValue("H" . 9, "Quotas");
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H" . 9 . ":J" . 9);
            $objPHPExcel->setActiveSheetIndex()->getStyle("H" . 9 . ":J" . 9)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("H" . 9 . ":J" . 9)->getFill()->
                    setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('B8D189');


            $objPHPExcel->getActiveSheet()->setCellValue("K" . 9, "Subsídios");
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K" . 9 . ":P" . 9);
            $objPHPExcel->setActiveSheetIndex()->getStyle("K" . 9 . ":P" . 9)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("K" . 9 . ":P" . 9)->getFill()->
                    setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('98F5FF');

            $objPHPExcel->getActiveSheet()->setCellValue("Q" . 9, "Créditos");
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("Q" . 9 . ":Y" . 9);
            $objPHPExcel->setActiveSheetIndex()->getStyle("Q" . 9 . ":Y" . 9)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("Q" . 9 . ":Y" . 9)->getFill()->
                    setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('388E8E');

            $objPHPExcel->getActiveSheet()->setCellValue("Z" . 9, "Bolsas de Estudo");
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("Z" . 9 . ":AF" . 9);
            $objPHPExcel->setActiveSheetIndex()->getStyle("Z" . 9 . ":AF" . 9)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("Z" . 9 . ":AF" . 9)->getFill()->
                    setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('CDCD00');


            $objPHPExcel->getActiveSheet()->setCellValue("AG" . 9, "Rendas");
            $objPHPExcel->setActiveSheetIndex(0)->mergeCells("AG" . 9 . ":AN" . 9);
            $objPHPExcel->setActiveSheetIndex()->getStyle("AG" . 9 . ":AN" . 9)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("AG" . 9 . ":AN" . 9)->getFill()->
                    setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FF8C00');



            $l = 10;
            $objPHPExcel->getActiveSheet()->setCellValue("A" . $l, 'Nº. Ordem');
            $objPHPExcel->getActiveSheet()->setCellValue("B" . $l, 'Nº. Mecanográfico');
            $objPHPExcel->getActiveSheet()->setCellValue("C" . $l, 'Nome do Associado');
            $objPHPExcel->getActiveSheet()->setCellValue("D" . $l, 'Situação');
            $objPHPExcel->getActiveSheet()->setCellValue("E" . $l, 'Nº. de Conta Bancária');
            $objPHPExcel->getActiveSheet()->setCellValue("F" . $l, 'Órgão');
            $objPHPExcel->getActiveSheet()->setCellValue("G" . $l, 'Data de Ingresso na Associação');

            $objPHPExcel->getActiveSheet()->setCellValue("H" . $l, 'Valor');
            $objPHPExcel->getActiveSheet()->setCellValue("I" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("J" . $l, 'Status do Pagamento');

            $objPHPExcel->getActiveSheet()->setCellValue("K" . $l, 'Valor do Subsídio');
            $objPHPExcel->getActiveSheet()->setCellValue("L" . $l, 'Natureza do Subsídio');
            $objPHPExcel->getActiveSheet()->setCellValue("M" . $l, 'Data de concessão do subsídio');
            $objPHPExcel->getActiveSheet()->setCellValue("N" . $l, 'Tipo de Beneficiário');
            $objPHPExcel->getActiveSheet()->setCellValue("O" . $l, 'Nome do Beneficiário');
            $objPHPExcel->getActiveSheet()->setCellValue("P" . $l, 'Grau de Parentesco com o Associado');

            $objPHPExcel->getActiveSheet()->setCellValue("Q" . $l, 'Tipo de Crédito');
            $objPHPExcel->getActiveSheet()->setCellValue("R" . $l, 'Valor Total Concedido');
            $objPHPExcel->getActiveSheet()->setCellValue("S" . $l, 'Data de Concessão');
            $objPHPExcel->getActiveSheet()->setCellValue("T" . $l, 'Valor da amortização');
            $objPHPExcel->getActiveSheet()->setCellValue("U" . $l, 'Juros acrescidos');
            $objPHPExcel->getActiveSheet()->setCellValue("V" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("W" . $l, 'Amortizações pagas até a data');
            $objPHPExcel->getActiveSheet()->setCellValue("X" . $l, 'Remanescente por Liquidar');
            $objPHPExcel->getActiveSheet()->setCellValue("Y" . $l, 'Juros recebidos até a data');


            $objPHPExcel->getActiveSheet()->setCellValue("Z" . $l, 'Data de Concessão da Bolsa');
            $objPHPExcel->getActiveSheet()->setCellValue("AA" . $l, 'Valor Total da Bolsa');
            $objPHPExcel->getActiveSheet()->setCellValue("AB" . $l, 'Valor Períodico Pago');
            $objPHPExcel->getActiveSheet()->setCellValue("AC" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("AD" . $l, 'Tipo de Beneficiário');
            $objPHPExcel->getActiveSheet()->setCellValue("AE" . $l, 'Nome do Beneficiário');
            $objPHPExcel->getActiveSheet()->setCellValue("AF" . $l, 'Grau de Parentesco com o Associado');


            $objPHPExcel->getActiveSheet()->setCellValue("AG" . $l, 'Tipo de Renda');
            $objPHPExcel->getActiveSheet()->setCellValue("AH" . $l, 'Valor Total Concedido');
            $objPHPExcel->getActiveSheet()->setCellValue("AI" . $l, 'Data de Concessão');
            $objPHPExcel->getActiveSheet()->setCellValue("AJ" . $l, 'Valor a amortizar ');
            $objPHPExcel->getActiveSheet()->setCellValue("AK" . $l, 'Juros acrescidos');
            $objPHPExcel->getActiveSheet()->setCellValue("AL" . $l, 'Mês de Referência');
            $objPHPExcel->getActiveSheet()->setCellValue("AL" . $l, 'Amortizações pagas até a data');
            $objPHPExcel->getActiveSheet()->setCellValue("AM" . $l, 'Remanescente por Liquidar');
            $objPHPExcel->getActiveSheet()->setCellValue("AN" . $l, 'Juros recebidos até a data');


            /* Configuraçoes */

            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":AN" . $l)->getAlignment()->setWrapText(TRUE); //quebra texto
            $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":T" . $l)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A" . $l . ":AN" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFFFF'); //COR DO FUNDO(BRANCA)
            //Fundo do cabeçalho da tabelas
            $objPHPExcel->getActiveSheet()->getStyle("H" . $l . ":J" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('B8D189');
            $objPHPExcel->getActiveSheet()->getStyle("K" . $l . ":P" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('98F5FF');
            $objPHPExcel->getActiveSheet()->getStyle("Q" . $l . ":Y" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('388E8E');
            $objPHPExcel->getActiveSheet()->getStyle("Z" . $l . ":AF" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('CDCD00');
            $objPHPExcel->getActiveSheet()->getStyle("AG" . $l . ":AN" . $l)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FF8C00');




            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(16);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(18);

            $objPHPExcel->getActiveSheet()->getRowDimension('A7')->setRowHeight(6);

            $y = $l + 1;
            $x = 1;

            $lin = $l;

            $em = $this->getDoctrine()->getManager();

            $pagamento = $em->getRepository('UsokoSIGBundle:Pagamento')->
                    pagamentosAssociado($data1, $data2);

            for ($i = 0, $pos = $l + 1; $i < count($pagamento); $i++, $pos++) {


                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $pos . ":C" . $pos)->getAlignment()->setVertical(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

                $objPHPExcel->getActiveSheet()->setCellValue("A" . $pos, ($i + 1));
                $objPHPExcel->getActiveSheet()->setCellValue("B" . $pos, $pagamento[$i]->getAssociado()->getNMecanografico());
                $objPHPExcel->getActiveSheet()->setCellValue("C" . $pos, $pagamento[$i]->getAssociado()->getPessoa()->getNome());
                $objPHPExcel->getActiveSheet()->setCellValue("D" . $pos, $pagamento[$i]->getAssociado()->getStatus() == 'A' ? "Activo" : "Reformado");
                $objPHPExcel->getActiveSheet()->setCellValue("E" . $pos, ($pagamento[$i]->getAssociado()->getConta()) ? $pagamento[$i]->getAssociado()->getConta()->getNumero() : " ");
                $objPHPExcel->getActiveSheet()->setCellValue("F" . $pos, $pagamento[$i]->getAssociado()->getOrgao()->getNome());
                $dataIngresso = DataGeneral::dataINDatetime(FuncaoGeneral::object2Array($pagamento[$i]->getAssociado()->getDataAdmissao()));
                $objPHPExcel->getActiveSheet()->setCellValue("G" . $pos, FuncaoGeneral::converteDataParaDiaMesAno($dataIngresso));

                //Se o pagamento for de Quotas, então, preenche essas células abaixo
                //De H a J.
                $tipoPagamento = $pagamento[$i]->getTipopagamento()->getTipo();

                if ($tipoPagamento == VarsGeneral::CONS_TIPO_PAGAMENTO_QUOTA) {
                    $objPHPExcel->getActiveSheet()->setCellValue("H" . $pos, $pagamento[$i]->getValor());
                    $objPHPExcel->getActiveSheet()->setCellValue("I" . $pos, $pagamento[$i]->getMesAno());
                    $objPHPExcel->getActiveSheet()->setCellValue("J" . $pos, $pagamento[$i]->getEstado() == "L" ? "Liquidado" : "Não liquidado");
                } else if ($em->getRepository('UsokoSIGBundle:Pagamento')->
                                subsidiosAssociadoPeriodo($pagamento[$i]->getAssociado()->getId(), $data1, $data2)) {
                    $subsidios = $em->getRepository('UsokoSIGBundle:Pagamento')->subsidiosAssociadoPeriodo($pagamento[$i]->getAssociado()->getId(), $data1, $data2);

                    $dataConcessao = DataGeneral::dataINDatetime(FuncaoGeneral::object2Array($subsidios[0]->getDataActual()));
                    if ($subsidios[0]->getDependente()) {
                        $nomeDependente = $subsidios[0]->getDependente()->getPessoa()->getNome();
                        $grau = "Agregado";
                        $assocDepObj = $em->getRepository("UsokoSIGBundle:AssociadoDependentes")->findBy(array('dependentes' => $subsidios[0]->getDependente()->getId()));
                        $assocDep = $assocDepObj[0]->getGrauparentesco()->getNome();
                    } else {
                        $nomeDependente = "";
                        $grau = "Associado";
                        $assocDep = "";
                    }


                    $objPHPExcel->getActiveSheet()->setCellValue("K" . $pos, $subsidios[0]->getValor());
                    $objPHPExcel->getActiveSheet()->setCellValue("L" . $pos, $subsidios[0]->getSubsidio()->getTipo());
                    $objPHPExcel->getActiveSheet()->setCellValue("M" . $pos, FuncaoGeneral::converteDataParaDiaMesAno($dataConcessao));
                    $objPHPExcel->getActiveSheet()->setCellValue("N" . $pos, $grau);
                    $objPHPExcel->getActiveSheet()->setCellValue("O" . $pos, $nomeDependente);
                    $objPHPExcel->getActiveSheet()->setCellValue("P" . $pos, $assocDep);
                }

                //Se o pagamento for de créditos, então, preenche essas células abaixo
                //De Q a Y.
                else if ($tipoPagamento == VarsGeneral::CONS_TIPO_PAGAMENTO_CREDITO) {
                    $pagamAux = $em->getRepository("UsokoSIGBundle:Pagamento")->
                            registoDeAmortizacoesIndividual($data1, $data2, $pagamento[$i]->getAssociado()->getId());

                    $objPHPExcel->getActiveSheet()->setCellValue("Q" . $pos, $pagamAux[0]->getCreditoPedido()->getTipoCredito()->getNome());
                    $objPHPExcel->getActiveSheet()->setCellValue("R" . $pos, number_format($pagamAux[0]->getValorpagar(), 2, ',', '.'));
                    $objPHPExcel->getActiveSheet()->setCellValue("S" . $pos, FuncaoGeneral::converteDataParaDiaMesAno(DataGeneral::dataINDatetime(FuncaoGeneral::object2Array($pagamAux[0]->getData()))));
                    $objPHPExcel->getActiveSheet()->setCellValue("T" . $pos, "");

                    $taxa = $em->getRepository("UsokoSIGBundle:CreditoPlafond")->findOneBy(array('ano' => date('Y')));
                    $objPHPExcel->getActiveSheet()->setCellValue("U" . $pos, $taxa->getTaxajuros());

                    $objPHPExcel->getActiveSheet()->setCellValue("V" . $pos, "");
                    $objPHPExcel->getActiveSheet()->setCellValue("W" . $pos, "");
                    $objPHPExcel->getActiveSheet()->setCellValue("X" . $pos, "");
                    $objPHPExcel->getActiveSheet()->setCellValue("Y" . $pos, "");
                }
				/*
                $objPHPExcel->getActiveSheet()->setCellValue("Z" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AA" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AB" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AC" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AD" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AE" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AF" . $pos, "");*/

			else if($tipoPagamento =='PP'){
                $objPHPExcel->getActiveSheet()->setCellValue("AG" . $pos, "");
				$objPHPExcel->getActiveSheet()->setCellValue("AH" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AI" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AJ" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AK" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AL" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AL" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AM" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AN" . $pos, "");
				}


                $objPHPExcel->getActiveSheet()->setCellValue("Z" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AA" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AB" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AC" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AD" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AE" . $pos, "");
                $objPHPExcel->getActiveSheet()->setCellValue("AF" . $pos, "");



                //$objPHPExcel->setActiveSheetIndex()->getStyle("C" . $l . ":C" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $l . ":AN" . $l)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                //Fundo em todas as células
                $objPHPExcel->getActiveSheet()->getStyle("H" . $pos . ":J" . $pos)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('B8D189');
                $objPHPExcel->getActiveSheet()->getStyle("K" . $pos . ":P" . $pos)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('98F5FF');
                $objPHPExcel->getActiveSheet()->getStyle("Q" . $pos . ":Y" . $pos)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('388E8E');
                $objPHPExcel->getActiveSheet()->getStyle("Z" . $pos . ":AF" . $pos)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('CDCD00');
                $objPHPExcel->getActiveSheet()->getStyle("AG" . $pos . ":AN" . $pos)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FF8C00');





//Bordas
                $objPHPExcel->getActiveSheet()->getStyle("A" . $lin . ":AN" . $pos)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("J1:J6")->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle("A1:A6")->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

//Centralizar
                //$objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":K" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("M" . $lin . ":T" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("A" . $lin . ':A' . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->setActiveSheetIndex()->getStyle("C" . $lin . ":C" . $pos)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            }

            $nome = 'registoDeBeneficiosConcedidosExcel-' . date('Y') . '.xls';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $nome . '"');
            header('Cache-Control: max-age=0');

            header('Cache-Control: max-age=1');

            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            die;
        } else {
            return $this->render("UsokoSIGBundle:Excel:beneficios/registoDeBeneficiosConcedidosExcel.html.twig");
        }
    }

}