<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Funcao;
use Usoko\SIGBundle\Form\FuncaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;

/**
 * Funcao controller.
 *
 */
class FuncaoController extends Controller {

    /**
     * Lists all Funcao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Funcao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Funcao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Funcao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Funcao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->getConnection()->beginTransaction();

            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Funcao", "I", "Registo de Uma Nova Função");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('funcao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Funcao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Funcao entity.
     *
     * @param Funcao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Funcao $entity) {
        $form = $this->createForm(new FuncaoType(), $entity, array(
            'action' => $this->generateUrl('funcao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Funcao entity.
     *
     */
    public function newAction() {
        $entity = new Funcao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Funcao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Funcao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Funcao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Funcao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Funcao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Funcao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
         $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Funcao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Funcao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Funcao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Funcao entity.
     *
     * @param Funcao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Funcao $entity) {
        $form = $this->createForm(new FuncaoType(), $entity, array(
            'action' => $this->generateUrl('funcao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Funcao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Funcao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Funcao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Funcao", "U", "Actualização de Uma Função");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('funcao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Funcao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Funcao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Funcao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Funcao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Funcao", "D", "Remoção de Uma Função");

            $em->remove($entity);
            $em->flush();
            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('funcao'));
    }

    /**
     * Creates a form to delete a Funcao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('funcao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
