<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Grauparentesco;
use Usoko\SIGBundle\Form\GrauparentescoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\CryptGeneral;

/**
 * Grauparentesco controller.
 *
 */
class GrauparentescoController extends Controller {

    /**
     * Lists all Grauparentesco entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Grauparentesco')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Grauparentesco:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Grauparentesco entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Grauparentesco();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && \Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "GrauParentesco", "I", "Registo de Um Novo Grau de Parentesco");
            $em->getConnection()->commit();
            $id = CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('grauparentesco_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Grauparentesco:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Grauparentesco entity.
     *
     * @param Grauparentesco $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Grauparentesco $entity) {
        $form = $this->createForm(new GrauparentescoType(), $entity, array(
            'action' => $this->generateUrl('grauparentesco_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Grauparentesco entity.
     *
     */
    public function newAction() {
        $entity = new Grauparentesco();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Grauparentesco:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Grauparentesco entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Grauparentesco')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Grauparentesco entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Grauparentesco:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Grauparentesco entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Grauparentesco')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Grauparentesco entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Grauparentesco:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Grauparentesco entity.
     *
     * @param Grauparentesco $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Grauparentesco $entity) {
        $form = $this->createForm(new GrauparentescoType(), $entity, array(
            'action' => $this->generateUrl('grauparentesco_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Grauparentesco entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $id = $this->get('nzo_url_encryptor')->decrypt($id);

        $entity = $em->getRepository('UsokoSIGBundle:Grauparentesco')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Grauparentesco entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "GrauParentesco", "U", "Actualização de Um Grau de Parentesco");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('grauparentesco'));
        }

        return $this->render('UsokoSIGBundle:Grauparentesco:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Grauparentesco entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = CryptGeneral::decrypt($this, $id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Grauparentesco')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Grauparentesco entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "GrauParentesco", "D", "Remoção de Um Grau de Parentesco");
            try {
                $em->remove($entity);
                $em->flush();
            } catch (\Doctrine\DBAL\DBALException $e) {
                $em->getConnection()->rollback();
                return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
            }

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('grauparentesco'));
    }

    /**
     * Creates a form to delete a Grauparentesco entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = CryptGeneral::encrypt($this, $id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('grauparentesco_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
