<?php

namespace Usoko\SIGBundle\Controller;


use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Associado;

//use Ob\HighchartsBundle\Highcharts\Highchart;

use RC\AmChartsBundle\AmCharts\AmPieChart;

class HomeController extends Controller {

    public function homeAdminAction() {
        $em = $this->getDoctrine()->getManager();
        $TotalAssociado = $em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados();
        $TotalMasculino =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("M");
        $TotalFem =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("F");
         
        $TotalSolteiros =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("S");
        $TotalCasados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("C");
        $TotalUniaoFacto =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("U");
        $TotalDivorciados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("D");
        $TotalViuvos =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("V");
        
        
        $TotalActivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("A");
        $TotalInactivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("I");
        $TotalDesvinculado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("D");
        $TotalReformado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("R");
        $TotalFalecido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("F");
        $TotalAdido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("AD");
        
        
        $pieChart = new \RC\AmChartsBundle\AmCharts\AmPieChart(); 
        $pieChart->renderTo('piechart'); $pieChart->setTitleField('number'); 
        $pieChart->setValueField('column-1');
        $pieChart->addData(array('number' => '1', 'column-1' => 10));
        $pieChart->addData(array('number' => '2', 'column-1' => 40)); 
        $pieChart->addData(array('number' => '3', 'column-1' => 30)); 
        
        
        return $this->render('UsokoSIGBundle:Home:homeGestor.html.twig', array( 't_genero' => $TotalAssociado ,    
            't_masc' => $TotalMasculino  , 't_fem' => $TotalFem , 't_estadoCivil' => $TotalAssociado ,    
            't_solteiro' => $TotalSolteiros, 't_casado' => $TotalCasados,'t_uniaofacto' => $TotalUniaoFacto,'t_divorsiado' => $TotalDivorciados,'t_viuvo' => $TotalViuvos, 
        't_status' => $TotalAssociado ,    
            't_activo' => $TotalActivo ,'t_inactivo' => $TotalInactivo , 't_desvinculado' => $TotalDesvinculado , 't_reformado' => $TotalReformado , 't_falecido' => $TotalFalecido , 't_adido' => $TotalAdido ,
            'chart' => $pieChart));
    
        //return $this->render('UsokoSIGBundle:Home:homeGestor.html.twig', array());
    }
    
    
    
    
    
     public function homeGestorEstatisticaPoOrgaoAction() {
        $em = $this->getDoctrine()->getManager();
        $TotalAssociado = $em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados();
        $TotalMasculino =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("M");
        $TotalFem =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("F");
         
        $TotalSolteiros =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("S");
        $TotalCasados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("C");
        $TotalUniaoFacto =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("U");
        $TotalDivorciados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("D");
        $TotalViuvos =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("V");
        
        
        $TotalNENHUM =$em->getRepository('UsokoSIGBundle:Associado')->TotalOrgao("_NENHUM");
        $TotalBRIGADA_ESPECIAL_DE_TRÂNSITO =$em->getRepository('UsokoSIGBundle:Associado')->TotalOrgao("BRIGADA ESPECIAL DE TRÂNSITO");
        $TotalCMDO_P_LUANDA =$em->getRepository('UsokoSIGBundle:Associado')->TotalOrgao("CMDO P/ LUANDA");
        $TotalCENTRO_POLIVALENTE_NZONGI =$em->getRepository('UsokoSIGBundle:Associado')->TotalOrgao("CENTRO POLIVALENTE NZONGI");
        $TotalCMDO_DE_UNIDADE_DE_POLICIA_MONTADA =$em->getRepository('UsokoSIGBundle:Associado')->TotalOrgao("CMDO DE UNIDADE DE POLICIA MONTADA");
        $TotalCMDO_OBJECTIVOS_ESTRATEGICOS =$em->getRepository('UsokoSIGBundle:Associado')->TotalOrgao("CMDO OBJECTIVOS ESTRATEGICOS");
        
        $series = array(
        array("name" => "Data Serie Name",    "data" => array(1,2,4,5,6,3,8))
    );

        
        return $this->render('UsokoSIGBundle:Home:homeGestorEstatisticaPoOrgao.html.twig', array( 
           't_nenhum' => $TotalNENHUM ,'t_BEDT' => $TotalBRIGADA_ESPECIAL_DE_TRÂNSITO ,'t_cpl' => $TotalCMDO_P_LUANDA ,
            't_cpn' => $TotalCENTRO_POLIVALENTE_NZONGI ,'t_cdudpm' => $TotalCMDO_DE_UNIDADE_DE_POLICIA_MONTADA ,'t_coe' => $TotalCMDO_OBJECTIVOS_ESTRATEGICOS
            
            ));
    }

    
    
    
       public function hGEstatisticaPorProvinciaAction() {
        $em = $this->getDoctrine()->getManager();
        $TotalAssociado = $em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados();
        $TotalMasculino =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("M");
        $TotalFem =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("F");
         
        $TotalSolteiros =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("S");
        $TotalCasados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("C");
        $TotalUniaoFacto =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("U");
        $TotalDivorciados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("D");
        $TotalViuvos =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("V");
        
        
        
        //$TotalAssociado = $em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados();
//        $TotalLuanda =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Luanda");
//        $TotalBengo =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Bengo");
//        $TotalBeguela =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Beguela");
//        $TotalCabinga =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Cabinga");
//        $TotalCuando-Cubango =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Cuando-Cubango");
//        $TotalKwanza-Norte =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Kwanza-Norte");
//        $TotalKwanza-Sul =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Kwanza-Sul");
//        $TotalCunene =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Cunene");
//        $TotalHuambo =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Huambo");
//        $TotalHuila =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Huila");
//        $TotalBié =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Bié");
//        $TotalLunda-Norte =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Lunda-Norte");
//        $TotalLunda-Sul =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Lunda-Sul");
//        $TotalMalange =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Malange");
//        $TotalMoxico =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Moxico");
//        $TotalNamibe =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Namibe");
//        $TotalUige =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Uige");
//        $TotalZaire =$em->getRepository('UsokoSIGBundle:Associado')->$TotalProvincia("Zaire");
//        
        
        
        
        
        $TotalActivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("A");
        $TotalInactivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("I");
        $TotalDesvinculado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("D");
        $TotalReformado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("R");
        $TotalFalecido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("F");
        $TotalAdido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("AD");
        
        $series = array(
        array("name" => "Data Serie Name",    "data" => array(1,2,4,5,6,3,8))
    );
        
//        $ob = new Highchart();
//    $ob->chart->renderTo('linechart');  // The #id of the div where to render the chart
//    $ob->title->text('Chart Title');
//    $ob->xAxis->title(array('text'  => "Horizontal axis title"));
//    $ob->yAxis->title(array('text'  => "Vertical axis title"));
//    $ob->series($series);
        
        $pieChart = new \RC\AmChartsBundle\AmCharts\AmPieChart(); 
        $pieChart->renderTo('piechart'); $pieChart->setTitleField('number'); 
        $pieChart->setValueField('column-1');
        $pieChart->addData(array('number' => 'Brigada Especial De Trânsito', 'column-1' => 50));
        $pieChart->addData(array('number' => 'Cmdo P/ Luanda', 'column-1' => 50)); 
        $pieChart->addData(array('number' => 'Centro Polivalente Nzongi', 'column-1' => 50));
        $pieChart->addData(array('number' => 'Cmdo De Unidade De Policia Montada', 'column-1' => 20)); 
//return $this->render('::template.html.twig', array( 'chart' => $chart )); }
        
        
        return $this->render('UsokoSIGBundle:Home:hGEstatisticaPorProvincia.html.twig', array( 't_genero' => $TotalAssociado ,    
            't_masc' => $TotalMasculino  , 't_fem' => $TotalFem , 't_estadoCivil' => $TotalAssociado ,    
            't_solteiro' => $TotalSolteiros, 't_casado' => $TotalCasados,'t_uniaofacto' => $TotalUniaoFacto,'t_divorsiado' => $TotalDivorciados,'t_viuvo' => $TotalViuvos, 
        't_status' => $TotalAssociado ,    
            't_activo' => $TotalActivo ,'t_inactivo' => $TotalInactivo , 't_desvinculado' => $TotalDesvinculado , 't_reformado' => $TotalReformado , 't_falecido' => $TotalFalecido , 't_adido' => $TotalAdido ,
             'chart' => $pieChart));
    }
    
    

    public function homeAtendenteAction() {
        return $this->render('UsokoSIGBundle:Home:homeAtendente.html.twig', array(
                        // ...
        ));
    }

    public function homeSimuladorAction() {
        return $this->render('UsokoSIGBundle:Home:homeSimulador.html.twig', array());
    }

    public function homeGestorAction() {
        $em = $this->getDoctrine()->getManager();
        $TotalAssociado = $em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados();
        $TotalMasculino =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("M");
        $TotalFem =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("F");
         
        $TotalSolteiros =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("S");
        $TotalCasados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("C");
        $TotalUniaoFacto =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("U");
        $TotalDivorciados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("D");
        $TotalViuvos =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("V");
        
        
        $TotalActivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("A");
        $TotalInactivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("I");
        $TotalDesvinculado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("D");
        $TotalReformado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("R");
        $TotalFalecido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("F");
        $TotalAdido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("AD");
        
        $series = array(
        array("name" => "Data Serie Name",    "data" => array(1,2,4,5,6,3,8))
    );
        
//        $ob = new Highchart();
//    $ob->chart->renderTo('linechart');  // The #id of the div where to render the chart
//    $ob->title->text('Chart Title');
//    $ob->xAxis->title(array('text'  => "Horizontal axis title"));
//    $ob->yAxis->title(array('text'  => "Vertical axis title"));
//    $ob->series($series);
        
        $pieChart = new \RC\AmChartsBundle\AmCharts\AmPieChart(); 
        $pieChart->renderTo('piechart'); $pieChart->setTitleField('number'); 
        $pieChart->setValueField('column-1');
        $pieChart->addData(array('number' => 'Brigada Especial De Tr창nsito', 'column-1' => 50));
        $pieChart->addData(array('number' => 'Cmdo P/ Luanda', 'column-1' => 50)); 
        $pieChart->addData(array('number' => 'Centro Polivalente Nzongi', 'column-1' => 50));
        $pieChart->addData(array('number' => 'Cmdo De Unidade De Policia Montada', 'column-1' => 20)); 
//return $this->render('::template.html.twig', array( 'chart' => $chart )); }
        
        
        return $this->render('UsokoSIGBundle:Home:homeGestor.html.twig', array( 't_genero' => $TotalAssociado ,    
            't_masc' => $TotalMasculino  , 't_fem' => $TotalFem , 't_estadoCivil' => $TotalAssociado ,    
            't_solteiro' => $TotalSolteiros, 't_casado' => $TotalCasados,'t_uniaofacto' => $TotalUniaoFacto,'t_divorsiado' => $TotalDivorciados,'t_viuvo' => $TotalViuvos, 
        't_status' => $TotalAssociado ,    
            't_activo' => $TotalActivo ,'t_inactivo' => $TotalInactivo , 't_desvinculado' => $TotalDesvinculado , 't_reformado' => $TotalReformado , 't_falecido' => $TotalFalecido , 't_adido' => $TotalAdido ,
             'chart' => $pieChart));
    }

    public function homeFinanceiroAction() {
        
         $em = $this->getDoctrine()->getManager();
        $TotalAssociado = $em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados();
        $TotalMasculino =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("M");
        $TotalFem =$em->getRepository('UsokoSIGBundle:Associado')->TotalAssociados("F");
         
        $TotalSolteiros =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("S");
        $TotalCasados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("C");
        $TotalUniaoFacto =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("U");
        $TotalDivorciados =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("D");
        $TotalViuvos =$em->getRepository('UsokoSIGBundle:Associado')->TotalEstadoCivil("V");
        
        
        $TotalActivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("A");
        $TotalInactivo =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("I");
        $TotalDesvinculado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("D");
        $TotalReformado =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("R");
        $TotalFalecido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("F");
        $TotalAdido =$em->getRepository('UsokoSIGBundle:Associado')->TotalStatus("AD");
        
         $pieChart = new \RC\AmChartsBundle\AmCharts\AmPieChart(); 
        $pieChart->renderTo('piechart'); $pieChart->setTitleField('number'); 
        $pieChart->setValueField('column-1');
        $pieChart->addData(array('number' => '1', 'column-1' => 10));
        $pieChart->addData(array('number' => '2', 'column-1' => 40)); 
        $pieChart->addData(array('number' => '3', 'column-1' => 30)); 
        
        return $this->render('UsokoSIGBundle:Home:homeFinanceiro.html.twig', array( 't_genero' => $TotalAssociado ,    
            't_masc' => $TotalMasculino  , 't_fem' => $TotalFem , 't_estadoCivil' => $TotalAssociado ,    
            't_solteiro' => $TotalSolteiros, 't_casado' => $TotalCasados,'t_uniaofacto' => $TotalUniaoFacto,'t_divorsiado' => $TotalDivorciados,'t_viuvo' => $TotalViuvos, 
        't_status' => $TotalAssociado ,    
            't_activo' => $TotalActivo ,'t_inactivo' => $TotalInactivo , 't_desvinculado' => $TotalDesvinculado , 't_reformado' => $TotalReformado , 't_falecido' => $TotalFalecido , 't_adido' => $TotalAdido ,
            'chart' => $pieChart));
    
//        return $this->render('UsokoSIGBundle:Home:homeFinanceiro.html.twig', array());
    }

    public function homeFinanSeniorAction() {
        return $this->render('UsokoSIGBundle:Home:homeFinanSenior.html.twig', array());
    }

    public function homeConsultaAction() {
        return $this->render('UsokoSIGBundle:Home:homeConsulta1.html.twig', array());
    }

    public function homeRedirectionAction() {
        
        if ($this->get('security.context')->isGranted('ROLE_ADMIN')) {
            return $this->redirect($this->generateUrl('home_admin'));
        } elseif ($this->get('security.context')->isGranted('ROLE_SIMULADOR')) {
            return $this->redirect($this->generateUrl('home_simulador'));
        } elseif ($this->get('security.context')->isGranted('ROLE_FINANCEIRO')) {
            return $this->redirect($this->generateUrl('home_financeiro'));
        } elseif ($this->get('security.context')->isGranted('ROLE_FINANSENION')) {
            return $this->redirect($this->generateUrl('home_financeiroSenior'));
        } elseif ($this->get('security.context')->isGranted('ROLE_CONSULTA1')) {
            return $this->redirect($this->generateUrl('home_consulta1'));
        } elseif ($this->get('security.context')->isGranted('ROLE_ATENDENTE')) {
            return $this->redirect($this->generateUrl('home_atendente'));
        } elseif ($this->get('security.context')->isGranted('ROLE_GESTOR')) {
            return $this->redirect($this->generateUrl('home_gestor'));
        } else {
            return $this->redirect($this->generateUrl('login'));
        }
    }

}
