<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Importacao;
use Usoko\SIGBundle\Form\ImportacaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * Importacao controller.
 *
 */
class ImportacaoController extends Controller {

    /**
     * Lists all Importacao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Importacao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Importacao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Importacao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Importacao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();

            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Importacao", "I", "Registo de Uma Nova Importação");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('importacao_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:Importacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Importacao entity.
     *
     * @param Importacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Importacao $entity) {
        $form = $this->createForm(new ImportacaoType(), $entity, array(
            'action' => $this->generateUrl('importacao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Importacao entity.
     *
     */
    public function newAction() {
        $entity = new Importacao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Importacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Importacao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Importacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Importacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Importacao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Importacao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Importacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Importacao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Importacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Importacao entity.
     *
     * @param Importacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Importacao $entity) {
        $form = $this->createForm(new ImportacaoType(), $entity, array(
            'action' => $this->generateUrl('importacao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing Importacao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:Importacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Importacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Importacao", "U", "Actualização de Uma Importação");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('importacao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Importacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Importacao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Importacao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Importacao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Importacao", "D", "Remoção de Uma Importação");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('importacao'));
    }

    /**
     * Creates a form to delete a Importacao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('importacao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

}
