<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Usoko\SIGBundle\Entity\Moeda;
use Usoko\SIGBundle\Entity\Operacao;
use Usoko\SIGBundle\Form\MoedaType;
use Usoko\SIGBundle\General\DataGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * Moeda controller.
 *
 */
class MoedaController extends Controller {

    /**
     * Lists all Moeda entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Moeda')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Moeda:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Moeda entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Moeda();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();

            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Moeda", "I", "Registo de Uma Nova Moeda");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('moeda_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Moeda:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Moeda entity.
     *
     * @param Moeda $entity The entity
     * 
     */
    private function createCreateForm(Moeda $entity) {
        $form = $this->createForm(new MoedaType(), $entity, array(
            'action' => $this->generateUrl('moeda_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Moeda entity.
     *
     */
    public function newAction() {
        $entity = new Moeda();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Moeda:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Moeda entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Moeda')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Moeda entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Moeda:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Moeda entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Moeda')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Moeda entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Moeda:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Moeda entity.
     *
     * @param Moeda $entity The entity
     *
     * @return Form The form
     */
    private function createEditForm(Moeda $entity) {
        $form = $this->createForm(new MoedaType(), $entity, array(
            'action' => $this->generateUrl('moeda_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Moeda entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:Moeda')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Moeda entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Moeda", "U", "Actualização de Uma Moeda");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('moeda_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Moeda:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Moeda entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Moeda')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Moeda entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Moeda", "D", "Remoção de Uma Moeda");

            $em->remove($entity);
            $em->flush();
            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('moeda'));
    }

    /**
     * Creates a form to delete a Moeda entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('moeda_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
