<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Orgao;
use Usoko\SIGBundle\Form\OrgaoType;
use Usoko\SIGBundle\Entity\Patente;
use Usoko\SIGBundle\Form\PatenteType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;

/**
 * Patente controller.
 *
 */
class PatenteController extends Controller {

    /**
     * Lists all Patente entities.
     *
     */
        public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Patente')->findBy(array(), array('nome' => 'ASC'));

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Patente:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }
    
    public function indexAction1(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Patente')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Patente:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Patente entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Patente();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid($this) && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Patente", "I", "Registo de Uma nova Patente");
            $em->getConnection()->commit();

            $id = \Usoko\SIGBundle\General\CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('patente_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Patente:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Patente entity.
     *
     * @param Patente $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Patente $entity) {
        $form = $this->createForm(new PatenteType(), $entity, array(
            'action' => $this->generateUrl('patente_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Patente entity.
     *
     */
    public function newAction() {
        $entity = new Patente();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Patente:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Patente entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Patente')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Patente entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Patente:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Patente entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Patente')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Patente entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Patente:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Patente entity.
     *
     * @param Patente $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Patente $entity) {
        $form = $this->createForm(new PatenteType(), $entity, array(
            'action' => $this->generateUrl('patente_update', array('id' => $id = $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Patente entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Patente')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Patente entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Patente", "U", "Actualização de Um Orgão");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('patente'));
        }

        return $this->render('UsokoSIGBundle:Patente:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Patente entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Patente')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Patente entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "Patente", "D", "Remoção de Um Orgão");

            try {
                $em->remove($entity);
                $em->flush();
            } catch (\Doctrine\DBAL\DBALException $e) {
                $em->getConnection()->rollback();
                return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
            }

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('patente'));
    }

    /**
     * Creates a form to delete a Patente entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = $this->get('nzo_url_encryptor')->encrypt($id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('patente_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
