<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\PpDesvinculacao;
use Usoko\SIGBundle\Form\PpDesvinculacaoType;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * PpDesvinculacao controller.
 *
 */
class PpDesvinculacaoController extends Controller {

    /**
     * Lists all PpDesvinculacao entities.
     *
     */
    public function indexAction($cod, Request $request) {
        $em = $this->getDoctrine()->getManager();

        if ($cod == 'sxsy') {
            $pago = 'S'; // Paga
        } elseif ($cod == 'nsns') {
            $pago = 'N'; // Não Paga   
        }

        $entities = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->findBy(array('pago' => $pago));

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:PpDesvinculacao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
                    'pago' => $pago,
        ));
    }

    /**
     * Creates a new PpDesvinculacao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new PpDesvinculacao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinculacao", "I", "Inserção de uma nova regra de desvinculação.");
            return $this->redirect($this->generateUrl('ppdesvinculacao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:PpDesvinculacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a PpDesvinculacao entity.
     *
     * @param PpDesvinculacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(PpDesvinculacao $entity) {
        $form = $this->createForm(new PpDesvinculacaoType(), $entity, array(
            'action' => $this->generateUrl('ppdesvinculacao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new PpDesvinculacao entity.
     *
     */
    public function newAction() {
        $entity = new PpDesvinculacao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:PpDesvinculacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a PpDesvinculacao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PpDesvinculacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:PpDesvinculacao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing PpDesvinculacao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PpDesvinculacao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:PpDesvinculacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a PpDesvinculacao entity.
     *
     * @param PpDesvinculacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(PpDesvinculacao $entity) {
        $form = $this->createForm(new PpDesvinculacaoType(), $entity, array(
            'action' => $this->generateUrl('ppdesvinculacao_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing PpDesvinculacao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PpDesvinculacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinculacao", "U", "Actualização de uma regra de desvinculação.");
            return $this->redirect($this->generateUrl('ppdesvinculacao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:PpDesvinculacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a PpDesvinculacao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find PpDesvinculacao entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinculacao", "D", "Remoção de uma regra de desvinculação.");
            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('ppdesvinculacao'));
    }

    /**
     * Creates a form to delete a PpDesvinculacao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('ppdesvinculacao_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
