<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\PpDesvinculacaoPercentagem;
use Usoko\SIGBundle\Form\PpDesvinculacaoPercentagemType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;

/**
 * PpDesvinculacaoPercentagem controller.
 *
 */
class PpDesvinculacaoPercentagemController extends Controller {

    /**
     * Lists all PpDesvinculacaoPercentagem entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:PpDesvinculacaoPercentagem')->findAll();
        
         $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:PpDesvinculacaoPercentagem:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new PpDesvinculacaoPercentagem entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new PpDesvinculacaoPercentagem();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinvulacaoPercentagem", "I", "Registo de Uma Nova Percentagem de Desvinculação");

            return $this->redirect($this->generateUrl('ppdesvinculacaopercentagem_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:PpDesvinculacaoPercentagem:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a PpDesvinculacaoPercentagem entity.
     *
     * @param PpDesvinculacaoPercentagem $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(PpDesvinculacaoPercentagem $entity) {
        $form = $this->createForm(new PpDesvinculacaoPercentagemType(), $entity, array(
            'action' => $this->generateUrl('ppdesvinculacaopercentagem_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new PpDesvinculacaoPercentagem entity.
     *
     */
    public function newAction() {
        $entity = new PpDesvinculacaoPercentagem();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:PpDesvinculacaoPercentagem:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a PpDesvinculacaoPercentagem entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacaoPercentagem')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PpDesvinculacaoPercentagem entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:PpDesvinculacaoPercentagem:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing PpDesvinculacaoPercentagem entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacaoPercentagem')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PpDesvinculacaoPercentagem entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:PpDesvinculacaoPercentagem:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a PpDesvinculacaoPercentagem entity.
     *
     * @param PpDesvinculacaoPercentagem $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(PpDesvinculacaoPercentagem $entity) {
        $form = $this->createForm(new PpDesvinculacaoPercentagemType(), $entity, array(
            'action' => $this->generateUrl('ppdesvinculacaopercentagem_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing PpDesvinculacaoPercentagem entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacaoPercentagem')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PpDesvinculacaoPercentagem entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinvulacaoPercentagem", "U", "Actualização de Um PpDesvinculacao Percentagem");

            return $this->redirect($this->generateUrl('ppdesvinculacaopercentagem_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:PpDesvinculacaoPercentagem:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a PpDesvinculacaoPercentagem entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:PpDesvinculacaoPercentagem')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find PpDesvinculacaoPercentagem entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinvulacaoPercentagem", "D", "Remoção de Um PpDesvinculacaoPercentagem");
            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('ppdesvinculacaopercentagem'));
    }

    /**
     * Creates a form to delete a PpDesvinculacaoPercentagem entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('ppdesvinculacaopercentagem_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
