<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Profissao;
use Usoko\SIGBundle\Form\ProfissaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\CryptGeneral;

/**
 * Profissao controller.
 *
 */
class ProfissaoController extends Controller {

    /**
     * Lists all Profissao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Profissao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Profissao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Profissao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Profissao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Profissao", "I", "Registo de Uma Nova Profissão");
            $em->getConnection()->commit();
            $id = CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('profissao_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Profissao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Profissao entity.
     *
     * @param Profissao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Profissao $entity) {
        $form = $this->createForm(new ProfissaoType(), $entity, array(
            'action' => $this->generateUrl('profissao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Profissao entity.
     *
     */
    public function newAction() {
        $entity = new Profissao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Profissao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Profissao entity.
     *
     */
    public function showAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Profissao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Profissao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Profissao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Profissao entity.
     *
     */
    public function editAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Profissao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Profissao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Profissao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Profissao entity.
     *
     * @param Profissao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Profissao $entity) {
        $id = CryptGeneral::encrypt($this, $entity->getId());
        $form = $this->createForm(new ProfissaoType(), $entity, array(
            'action' => $this->generateUrl('profissao_show', array('id' => $id)),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Profissao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $idR = $id;
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Profissao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Profissao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Profissao", "U", "Actualização de Uma Profissão");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('profissao_edit', array('id' => $idR)));
        }

        return $this->render('UsokoSIGBundle:Profissao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Profissao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = CryptGeneral::decrypt($this, $id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Profissao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Profissao entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "Profissao", "D", "Actualização de Uma Profissão");

            try {
                $em->remove($entity);
                $em->flush();
            } catch (\Doctrine\DBAL\DBALException $e) {
                $em->getConnection()->rollback();
                return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
            }

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('profissao'));
    }

    /**
     * Creates a form to delete a Profissao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = CryptGeneral::encrypt($this, $id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('profissao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    public function registarProfissaoAction(Request $requisicao) {

        $em = $this->getDoctrine()->getManager();

        if (true) {
            $profissao = new Profissao();
            $profissao->setNome($nome);
            $profissao->setDescricao($sigla);

            $em->persist($profissao);
            $em->flush();
            return $this->redirect($this->generateUrl('profissao'));
        } else {
            return $this->redirect($this->generateUrl('profissao'));
        }
    }

}
