<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Usoko\SIGBundle\Controller\PDFController;

class RelatorioController extends PDFController {

    public function comparticipacao_tipoSubsidioAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT s.tipo as tipo, SUM(c.valor) as valor 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s
                                   where c.subsidio = s.id
                                   GROUP BY c.subsidio");

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacao_tipoSubsidio.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacao_tipoSubsidio.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function comparticipacaoQtdAssociadoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT s.tipo as tipo, count(c.associado) as pessoas 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s, UsokoSIGBundle:Associado a 
                                   where c.subsidio = s.id
                                   and   c.associado  = a.id
                                    ");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoQtdAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoQtdAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    //Entradas e saídas
    public function comparticipacaoAssociadoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT c as ab, SUM(c.valor) as total 
                                   FROM UsokoSIGBundle:Comparticipacao c
                                   JOIN c.associado ca
                                   GROUP BY c.associado
                                   ORDER BY ca.nMecanografico");

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function comparticipacaoMensalAction() {

        $em = $this->getDoctrine()->getManager();

        $query = $em->createQuery("SELECT SUM(c.valor) as total 
                                   FROM UsokoSIGBundle:Comparticipacao c
                                   ");


        $saida = $query->getSingleScalarResult();

        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function quotaMensalAction() {

        $em = $this->getDoctrine()->getManager();


        for ($dia = 1; $dia <= 12; $dia++) {
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $ano = date('Y') . '-' . "$mes";
            $i = '%' . $ano . '%';

            $query = $em->createQuery("SELECT SUM(c.valor) FROM UsokoSIGBundle:Comparticipacao c 
                                  JOIN c.subsidio s WITH substring(c.dataActual,1,7) 
                                  LIKE :foo");
            $query->setParameter('foo', "$i");
            $saida = $query->getSingleScalarResult();

            $vetor_dados[] = is_null($saida) ? 0 : $saida;
        }

        $saida = $vetor_dados;
        //print_r($saida); die;

        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/quotaMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('quotaMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function relatorioInfracaoAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT at as infra, count(at.associado) as qtd 
                                   FROM UsokoSIGBundle:AssociadoTipoinfraccao at,
                                   UsokoSIGBundle:Tipoinfraccao t,
                                   UsokoSIGBundle:Associado a 
                                   where at.associado = a.id 
                                   AND at.tipoinfraccao = t.id
                                   GROUP BY at.associado, at.tipoinfraccao
                                   ORDER BY qtd ASC");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/infracaoAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('infracaoAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    
    public function associadoPagamentoAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT sum(p.valor) as total,a as pessoa
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a 
                                   where p.associado = a.id 
                                   GROUP BY p.associado, p.quota
                                   ORDER BY total ASC");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/pagamentosAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Nasa');
        $html2pdf->pdf->SetTitle('Nasa');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('associadoPagamento.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }
    
    
}
