<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Usoko\SIGBundle\Controller\PDFController;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\NasaPdf;
use Usoko\SIGBundle\General\AmortizacaoPdf;
use Symfony\Component\HttpFoundation\JsonResponse;

class RelatorioCreditoController extends PDFController {

    public function ajaxPesquisaEstudanteAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $dado = $request->query->get('a');

        $result = array();
        $result['rs'] = 0;

        $em = $this->getDoctrine()->getManager();


        $estudante = $em->getRepository('UsokoSIGBundle:CreditoResposta')->findBy(array('id' => $dado, 'resposta' => 'A'));

        $confirmado = $em->getRepository('UsokoSIGBundle:CreditoResposta')->findBy(array('id' => $dado, 'resposta' => 'AP'));

        if ($confirmado) {
            $result['rs'] = 3;
			$result['dado'] = 3;
			$result['nome'] = json_encode($confirmado[0]->getCreditoPedido()->getCodigo());
			$result['associado'] = json_encode($confirmado[0]->getCreditoPedido()->getAssociado()->getPessoa()->getNome());			
            return new JsonResponse($result);
        }
        if (!$estudante) {
            $result['rs'] = 4;
			$result['dado'] = 4; 			
            return new JsonResponse($result);
        }
        if ($estudante) {

            $result['rs'] = 1;
            $estudante[0]->getCreditoPedido()->setEstado('AP');
            $estudante[0]->setResposta('AP');
            $em->flush();
            $result['nome'] = json_encode($estudante[0]->getCreditoPedido()->getCodigo());
			$result['associado'] = json_encode($estudante[0]->getCreditoPedido()->getAssociado()->getPessoa()->getNome());
            return new JsonResponse($result);
        }
    }

    public function associadoCreditoAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT p.nome as nomes,tc.nome, a.nMecanografico as nMec,
                                   cp.dataActual as actual, cp.valor as solic           
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
                                   UsokoSIGBundle:TipoCredito tc
                                   where cp.associado = a.id
                                   and cp.tipoCredito = tc.id
                                   and a.id = p.id
                                   and cp.estado = :state  
                                   order by tc.nome,nomes,cp.dataActual
                                    ")->setParameters(array('state' => 'A'));

        $saida = $query->getResult();


        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Credito/associadoCredito.html.twig', array('entities' => $saida));

        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioAssociadoCredito($saida);
        $declaracao->Output("associadoCredito.pdf", 'I');
    }

    public function associadoTipoCreditoAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT sum(cp.valor) as total, tc.nome as nom,count(cp.associado) as qtd 
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where cp.associado = a.id
                                   and a.id  = p.id
                                   and tc.id = cp.tipoCredito
								   and cp.estado = :state
                                   group by cp.tipoCredito
								   order by nom
                                    ")->setParameters(array('state' => 'A'));

        $saida = $query->getResult();



        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioAssociadoTipoCredito($saida);
        $declaracao->Output("associadoCredito2.pdf", 'I');
    }

    public function associadoRecusadosAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT distinct tc.nome as ccc,p.nome as nome, a.nMecanografico as nMec, 
								   cp.dataActual as actual, cp.valor as valores	
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where cp.associado = a.id
                                   and a.id  = p.id
                                   and tc.id = cp.tipoCredito
                                   and cp.estado = :est
                                   ")->setParameters(array('est' => 'R'));

        $saida = $query->getResult();


        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Credito/associadoRecusados.html.twig', array('entities' => $saida));

        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioAssociadoRecusadosCredito($saida);
        $declaracao->Output("associadoRecusados.pdf", 'I');
    }

    public function ficheiroMensalAction() {


        $em = $this->getDoctrine()->getManager();

        $datas = date('Y/m/d');

        $ano1 = substr($datas, 0, 4);
        $mes1 = substr($datas, 5, 2);
        $mesAnoReferente = $mes1 . "-" . $ano1;

        $query = $em->createQuery("SELECT p.nome as nomeA,a.nMecanografico as Mec, 
                                   cp.valorMensal as valorM,
                                   cp.tempoAmortizacao as tempo
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:CreditoResposta cr,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
                                   UsokoSIGBundle:Pagamento pa,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where cp.associado = a.id
                                   and a.id  = p.id
                                   and tc.id = cp.tipoCredito
                                   and cr.creditoPedido = cp.id
                                   and cr.resposta = :respo
                                   and pa.associado = a.id
                                   and pa.mesAno = :mesA
                                   and tp.id     =  pa.tipopagamento
                                   and tp.tipo =:tipos
                                   and cp.estado =:est
                                   group by cp.associado
                                   order by cp.associado
                                   ")->setParameters(array('respo' => 'A',
            'mesA' => $mesAnoReferente,
            'tipos' => 'C',
            'est' => 'A'
                )
        );

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Credito/ficheiroMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('ficheiroMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function tabelaAmortizacaoAction(Request $req, $associado) {

        $em = $this->getDoctrine()->getManager();

        $nprocesso = $req->query->get('q');
        $cod_associado = $this->get('nzo_url_encryptor')->decrypt($associado);

        $query = $em->createQuery("SELECT cp 
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where cp.associado = a.id
                                   and a.id  = p.id
                                   and tc.id = cp.tipoCredito
                                   and cp.codigo =:processo
                                   and cp.associado =:assoc
                                    ")->setParameters(array('processo' => $nprocesso, 'assoc' => $cod_associado));
        $saida = $query->getResult();
        if (!$saida) {
            return $this->render('UsokoSIGBundle:Error:NotObject.html.twig');
        } else {
            $tempo = $query->getOneOrNullResult()->getTempoAmortizacao();
            $idPedido = $query->getOneOrNullResult()->getId();
            $dataPedido = $query->getSingleResult()->getDataActual();


            $datas = \Usoko\SIGBundle\General\FuncaoGeneral::object2Array($dataPedido);
            $anoQuestao = substr((string) $datas['date'], 0, -15);

            $query_taxa = $em->createQuery("SELECT cpl 
                                           FROM UsokoSIGBundle:CreditoPlafond cpl
                                           where cpl.ano =:anee
                                          ")->setParameters(array('anee' => $anoQuestao));


            $taxa = $query_taxa->getSingleResult()->getTaxajuros();
            $anoPlaf = $query_taxa->getSingleResult()->getAno();



            $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

            $assoc = $em->getRepository("UsokoSIGBundle:Associado")->find($cod_associado);

            $declaracao = new NasaPdf($this, 1, 1, 1);

            $declaracao->amort($query->getSingleResult()->getValor(), $taxa, $tempo / 12);
            //$declaracao->amort(365000,8,15/12);

            $declaracao->showTable(true, $nprocesso, $taxa, $assoc->getPessoa()->getNome(), $query->getOneOrNullResult()->getTipoCredito()->getNome());
            $declaracao->SetFont('times', '', 12);
            $declaracao->Output("TabelaCredito$nprocesso.pdf", 'I');
        }
    }

    public function amortizacaoAction($codigo) {

        $em = $this->getDoctrine()->getManager();

        $cPedido = $em->getRepository("UsokoSIGBundle:CreditoPedido")->findOneBy(array('codigo' => $codigo));

        if (!$cPedido) {
            return $this->render('UsokoSIGBundle:Error:NotObject.html.twig');
        }

        $dataPedido = $cPedido->getDataActual();
        $datas = \Usoko\SIGBundle\General\FuncaoGeneral::object2Array($dataPedido);
        $anoQuestao = substr((string) $datas['date'], 0, -15);

	$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $taxa = $em->getRepository("UsokoSIGBundle:CreditoPlafond")->findOneBy(array('ano' => $anoQuestao))->getTaxajuros();
        $amortizacao = new NasaPdf($this);
        $amortizacao->calAmort($cPedido->getValor(),$taxa,$cPedido->getTempoAmortizacao()/12,$cPedido->getValor()+$cPedido->getValor()*($taxa/100),$cPedido->getAssociado()->getPessoa()->getNome(),$cPedido->getTipoCredito()->getNome(),$cPedido->getCodigo());
        
        //$amortizacao->calAmort(30000,2,24/12);
        
        $amortizacao->SetFont('times', '', 12);
        $amortizacao->Output("TabelaDeAmortizacaoProcesso$codigo.pdf", 'I');
    }

    public function tabelaAmortizacaoAtAction(Request $req, $associado) {

        $em = $this->getDoctrine()->getManager();

        $nprocesso = $req->query->get('q');
        $cod_associado = $this->get('nzo_url_encryptor')->decrypt($associado);

        $query = $em->createQuery("SELECT cp 
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where cp.associado = a.id
                                   and a.id  = p.id
                                   and tc.id = cp.tipoCredito
                                   and cp.codigo =:processo
                                   and cp.associado =:assoc
                                    ")->setParameters(array('processo' => $nprocesso, 'assoc' => $cod_associado));
        $saida = $query->getResult();
        if (!$saida) {
            return $this->render('UsokoSIGBundle:Error:NotObject.html.twig');
        } else {
            $tempo = $query->getOneOrNullResult()->getTempoAmortizacao();
            $idPedido = $query->getOneOrNullResult()->getId();
            $dataPedido = $query->getSingleResult()->getDataActual();


            $datas = \Usoko\SIGBundle\General\FuncaoGeneral::object2Array($dataPedido);
            $anoQuestao = substr((string) $datas['date'], 0, -15);

            $query_taxa = $em->createQuery("SELECT cpl 
                                           FROM UsokoSIGBundle:CreditoPlafond cpl
                                           where cpl.ano =:anee
                                          ")->setParameters(array('anee' => $anoQuestao));


            $taxa = $query_taxa->getSingleResult()->getTaxajuros();
            $anoPlaf = $query_taxa->getSingleResult()->getAno();



            $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

            $assoc = $em->getRepository("UsokoSIGBundle:Associado")->find($cod_associado);

            $declaracao = new NasaPdf($this, 1, 1, 1);

            $declaracao->amort($query->getSingleResult()->getValor(), $taxa, $tempo / 12);
            //$declaracao->amort(365000,8,15/12);

            $declaracao->showTable(true, $nprocesso, $taxa, $assoc->getPessoa()->getNome(), $query->getOneOrNullResult()->getTipoCredito()->getNome());
            $declaracao->SetFont('times', '', 12);
            $declaracao->Output("TabelaCredito$nprocesso.pdf", 'I');
        }
    }

    public function visaoOrdemSaqueSubsidioAction() {
        return $this->render('UsokoSIGBundle:Pagamento:ordemSaqueSubsidio.html.twig');
    }

    public function visaoOrdemSaqueCreditoAction() {
        return $this->render('UsokoSIGBundle:Pagamento:ordemSaqueCredito.html.twig');
    }

    public function visaoConfirmarPagamentoCreditoAction() {
        return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoCredito2.html.twig');
    }

    public function visaoConfirmarPagamentoDesvinculadosAction() {
        return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoDesvinculados.html.twig');
    }

    public function pagamentoAssociadosDesvinculadosAction() {
        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT distinct(p.nome) as nomeDele, ppp.id as ide,
                                   a.nMecanografico as nMec, ppp.pago as pagou,
								   ppp.valortotalpp as val
                                   FROM 
                                   UsokoSIGBundle:PlanoPensao pp,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
								   UsokoSIGBundle:PpDesvinculacao ppp
                                   where a.pessoa = p.id
								   and   pp.associado = a.id
								   and ppp.planoPensao=pp.id
								   and ppp.pago =:pagar
								   order by nomeDele
                                   ')->setParameter('pagar', 'N');

        $saida = $query->getResult();


        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->ordemTransfDesvincPP($saida);
        $declaracao->Output("ficheiroMensalSubsidio.pdf", 'I');


        //$html = $this->renderView('UsokoSIGBundle:Pagamento:associadoDesvinculado.html.twig', array('entities' => $saida,
    }

}
