<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\General\DataGeneral;
use Usoko\SIGBundle\General\MathGeneral;

/**
 * Utilizador controller.
 *
 */
class SimuladorController extends Controller {

    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Utilizador')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Utilizador:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    public function configuracaoAction() {
        return $this->render('UsokoSIGBundle:Simulador:simularPorPrazo.html.twig', array());
    }

    public function PorIdadeAction() {
        $em = $this->getDoctrine()->getManager();
        $entities = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findBy(array('estado' => 'A'), array('id' => 'desc'), 1);
        return $this->render('UsokoSIGBundle:Simulador:simularPorIdade.html.twig', array(
                    'entities' => $entities,
        ));
    }

    public function PorPrazoAction() {
        $em = $this->getDoctrine()->getManager();
        $entities = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findBy(array('estado' => 'A'), array('id' => 'desc'), 1);
        return $this->render('UsokoSIGBundle:Simulador:simularPorPrazo.html.twig', array('entities' => $entities,));
    }

//numeroMecanografico equivale ao num_bi

    public function rapidaAction() {
        $nMecanografico = filter_input(INPUT_POST, 'numeroMecanografico');
        $resposta = array();
        $resposta['error'] = 500;

        if ($nMecanografico) {
            $em = $this->getDoctrine()->getManager();
            $query = $em->createQuery(
                            'SELECT p.nome, p.dataNascimento, a.salario
                                FROM
                                UsokoSIGBundle:Documentoidentificacao d,
                                UsokoSIGBundle:PessoaDocumento pd,
                                UsokoSIGBundle:Pessoa p,
                                UsokoSIGBundle:Associado a
                                WHERE
                                d.numero = :numero
                                AND
                                d.id = pd.documentoidentificacao
                                AND
                                pd.pessoa = p.id
                                AND
                                p.id = a.pessoa
                ')->setParameter('numero', "$nMecanografico");
            $entity = $query->getResult();

            if ($entity) {
                $anosFuturo = 0;
                $idadeTotal = 0;
                $anoServico = 60;
                $percentagemAnual = 0;
                $taxaRendSalarial = 0;
                $saldoLiqAcumulado = 0;
                $percentagemC = 6;

                /* @var $entity type */
                foreach ($entity as $entit) {
                    $idadeTotal = DataGeneral::diference($entit['dataNascimento']);
                    $resposta['nome'] = $entit['nome'];
                    $salario = $entit['salario'];
                    $resposta['salario'] = $salario;
                    $resposta['salarioAnual'] = $this->calcularSalarioAnual($salario);

                    $resposta['idade'] = $idadeTotal;
                    $resposta['anos'] = substr($idadeTotal, 0, 2);
                }

                $entities = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findBy(array('estado' => 'A'), array('id' => 'desc'), 1);

                foreach ($entities as $ent) {
                    // $ent = new Parametrosimulacao();
                    $taxaRentabilidade = $ent->getTaxaRentabilidade();
                    $taxaRendSalarial = $ent->getTaxaRendSalarial();

                    $anosFuturo = $this->calcularAnosFuturo(substr($idadeTotal, 0, 2), $anoServico);
                    $percentagemAnual = $this->calcularContribuicaoAnual($salario);
                    $saldoLiqAcumulado = $this->calcularSaldoLiquidoAcumulado($taxaRentabilidade, $taxaRendSalarial, $anosFuturo, $percentagemAnual);

                    $resposta['percentagemC'] = $percentagemC;  //Mudar depois a percentagem de contribuição
                    $resposta['anoServico'] = $ent->getAnosServico();
                    $resposta['taxaRentabilidade'] = $taxaRentabilidade;
                    $resposta['taxaRendSalarial'] = $taxaRendSalarial;
                    $resposta['anosFuturo'] = $anosFuturo;
                    //$resposta['percentagemAnual']  = $percentagemAnual;
                    //$resposta['saldoLiqAcumulado'] = $saldoLiqAcumulado;
                    $resposta['error'] = 0;
                }
            } else {
                $resposta['error'] = 500;
            }
        }
        print_r(json_encode($resposta));
        die;
    }

//AntesPesquisa Feita pelo num_Mecanografico
    public function rapidaAntesAction() {
        $nMecanografico = filter_input(INPUT_POST, 'numeroMecanografico');
        $resposta = array();
        $resposta['error'] = 500;

        if ($nMecanografico) {
            $em = $this->getDoctrine()->getManager();
            $query = $em->createQuery(
                            'SELECT p.nome, p.dataNascimento, a.salario
                                FROM UsokoSIGBundle:Pessoa p,
                                UsokoSIGBundle:Associado a
                                WHERE p.id = a.pessoa
                                AND a.nMecanografico = :numero
                ')->setParameter('numero', "$nMecanografico");
            $entity = $query->getResult();

            if ($entity) {
                $anosFuturo = 0;
                $idadeTotal = 0;
                $anoServico = 60;
                $percentagemAnual = 0;
                $taxaRendSalarial = 0;
                $saldoLiqAcumulado = 0;
                $percentagemC = 6;

                /* @var $entity type */
                foreach ($entity as $entit) {
                    $idadeTotal = DataGeneral::diference($entit['dataNascimento']);
                    $resposta['nome'] = $entit['nome'];
                    $salario = $entit['salario'];
                    $resposta['salario'] = $salario;
                    $resposta['salarioAnual'] = $this->calcularSalarioAnual($salario);

                    $resposta['idade'] = $idadeTotal;
                    $resposta['anos'] = substr($idadeTotal, 0, 2);
                }

                $entities = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findBy(array('estado' => 'A'), array('id' => 'desc'), 1);

                foreach ($entities as $ent) {
                    // $ent = new Parametrosimulacao();
                    $taxaRentabilidade = $ent->getTaxaRentabilidade();
                    $taxaRendSalarial = $ent->getTaxaRendSalarial();

                    $anosFuturo = $this->calcularAnosFuturo(substr($idadeTotal, 0, 2), $anoServico);
                    $percentagemAnual = $this->calcularContribuicaoAnual($salario);
                    $saldoLiqAcumulado = $this->calcularSaldoLiquidoAcumulado($taxaRentabilidade, $taxaRendSalarial, $anosFuturo, $percentagemAnual);

                    $resposta['percentagemC'] = $percentagemC;  //Mudar depois a percentagem de contribuição
                    $resposta['anoServico'] = $ent->getAnosServico();
                    $resposta['taxaRentabilidade'] = $taxaRentabilidade;
                    $resposta['taxaRendSalarial'] = $taxaRendSalarial;
                    $resposta['anosFuturo'] = $anosFuturo;
                    //$resposta['percentagemAnual']  = $percentagemAnual;
                    //$resposta['saldoLiqAcumulado'] = $saldoLiqAcumulado;
                    $resposta['error'] = 0;
                }
            } else {
                $resposta['error'] = 500;
            }
        }
        print_r(json_encode($resposta));
        die;
    }

    /**
     * <h3>Método existsDados</h3>
     * @param value $dados dados a ser análisado
     * @return boolean <b>True</b> caso existe dado e <b>False<7b> caso não existe ou não contém dados
     * @author Nasa Expert
     * @since 1.0
     */
    public function existsDados($dados) {
        return (isset($dados) && !empty($dados));
    }

    /**
     * <h3>Método calcularAnosFuturo</h3>
     * @param int $idade Representando a idade actual do associado
     * @param int $anoServico Representando o total de anos que um funcionario
     * deve exercer por lei na função pública
     * @return int Anos que falte para passar para aposentadoria
     * @author Nasa Expert
     * @since 1.0
     */
    public function calcularAnosFuturo($idade, $anoServico = 60) {
        return ($this->existsDados($idade)) ? $anoServico - $idade : $anoServico;
    }

    /**
     * <h3>Método calcularSalarioAnual</h3>
     * @param double $salario valor salarial
     * @return double O valor do salario em 12 meses ou zero (0) caso não exista o salário
     * @author Nasa Expert
     * @since 1.0
     */
    public function calcularSalarioAnual($salario) {
        return $this->existsDados($salario) ? $salario = $salario * 12 : 0;
    }

    /**
     * <h3>Método calcularContribuicaoAnual</h3>
     * @param double $salario valor salarial
     * @param int $percentagemC A percentagem de contribuição de um associado
     * @return double Que representa o salário durante um ano em função das
     * contribuições dadas ou zero (0) caso não exista o salário ou a
     * percentagem de contribuição
     * @author Nasa Expert
     * @since 1.0
     */
    public function calcularContribuicaoAnual($salario, $percentagemC = 6) {
        return ($this->existsDados($salario) && $this->existsDados($percentagemC)) ? ($percentagemC < 2 ? ($this->calcularSalarioAnual($salario) * 2 / 100) : ($this->calcularSalarioAnual($salario) * $percentagemC / 100)) : 0;
    }

    public function calcularSaldoLiquidoAcumulado($taxaRentabilidade, $taxaRendSalarial, $anosFuturo, $percentagemAnual) {
        // $saldoLAC = (1 + $taxaRentabilidade)*((1- Math.pow(((1 + $taxaRendSalarial) * (1 + $taxaRentabilidade)),($anosFuturo)))/(1 - ((1 + $taxaRendSalarial)*(1 + $taxaRentabilidade))))*($percentagemAnual);
        return (1 + $taxaRentabilidade) * ((1 - MathGeneral::potencia(((1 + $taxaRendSalarial) * (1 + $taxaRentabilidade)), ($anosFuturo))) / (1 - ((1 + $taxaRendSalarial) * (1 + $taxaRentabilidade)))) * ($percentagemAnual);
    }

}
