<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Subsidio;
use Usoko\SIGBundle\Form\SubsidioType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\CryptGeneral;
use Usoko\SIGBundle\General\NumeroReal;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Subsidio controller.
 *
 */
class SubsidioController extends Controller {

    public function ajaxPesquisaSubsidioAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $dado = $request->query->get('a');

        $result = array();
        $result['rs'] = 0;

        $em = $this->getDoctrine()->getManager();


        $comparticipacao = $em->getRepository('UsokoSIGBundle:Comparticipacao')->findBy(array('id' => $dado));

        $comparticRespos = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->findBy(array('comparticipacao' => $dado,
            'resposta' => 'AP'));

        $comparticRespo1 = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->
                findBy(array('comparticipacao' => $dado, 'resposta' => 'A'));


        if ($comparticRespos) {
            $result['rs'] = 3; // Comparticipação resposta já confirmada 
            $result['dado'] = 3;
            return new JsonResponse($result);
        }
        if (!$comparticipacao) {
            $result['rs'] = 4; // Comparticipação não encontrada
            $result['dado'] = 4;
            return new JsonResponse($result);
        }
        if ($comparticipacao and $comparticRespo1) {

            $result['rs'] = 1;
            $comparticRespo1[0]->setResposta('AP');
            $em->flush();
            $result['nome'] = json_encode($comparticRespo1[0]->getComparticipacao()->getAssociado()->getPessoa()->getNome());
            return new JsonResponse($result);
        } else {
            $result['rs'] = 0;
            $result['dado'] = 0;
            return new JsonResponse($result);
        }
    }

    /**
     * Lists all Subsidio entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Subsidio')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Subsidio:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    public function index2Action(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Subsidio')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Subsidio:Atendente/index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Subsidio entity.
     *
     */
    public function createAction(Request $request) {
        $valorMaximoTitular = $request->request->get('usoko_sigbundle_subsidio')['valorMaximoTitular'];
        $valorMaximoTitular = NumeroReal::converter($valorMaximoTitular);

        $valorMaximoDependente = $request->request->get('usoko_sigbundle_subsidio')['valorMaximoDependente'];
        $valorMaximoDependente = NumeroReal::converter($valorMaximoDependente);

        $entity = new Subsidio();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $entity->setValorMaximoTitular((double) $valorMaximoTitular);
            $entity->setValorMaximoDependente((double) $valorMaximoDependente);
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Subsidio", "I", "Registo de Um Novo Subsidio");
            $em->getConnection()->commit();

            $id = CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('subsidio_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Subsidio:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Subsidio entity.
     *
     * @param Subsidio $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Subsidio $entity) {
        $form = $this->createForm(new SubsidioType(), $entity, array(
            'action' => $this->generateUrl('subsidio_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'submit', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Subsidio entity.
     *
     */
    public function newAction() {
        $entity = new Subsidio();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Subsidio:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Subsidio entity.
     *
     */
    public function showAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Subsidio')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Subsidio entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Subsidio:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Subsidio entity.
     *
     */
    public function editAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Subsidio')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Subsidio entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Subsidio:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Subsidio entity.
     *
     * @param Subsidio $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Subsidio $entity) {
        $id = CryptGeneral::encrypt($this, $entity->getId());
        $form = $this->createForm(new SubsidioType(), $entity, array(
            'action' => $this->generateUrl('subsidio_show', array('id' => $id)),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Subsidio entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $idR = $id;
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Subsidio')->find($id);

        $valorMaximoTitular = $request->request->get('usoko_sigbundle_subsidio')['valorMaximoTitular'];
        $valorMaximoTitular = NumeroReal::converter($valorMaximoTitular);

        $valorMaximoDependente = $request->request->get('usoko_sigbundle_subsidio')['valorMaximoDependente'];
        $valorMaximoDependente = NumeroReal::converter($valorMaximoDependente);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Subsidio entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $entity->setValorMaximoTitular((double) $valorMaximoTitular);
            $entity->setValorMaximoDependente((double) $valorMaximoDependente);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Subsidio", "U", "Actualização de Um Subsídio");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('subsidio_edit', array('id' => $idR)));
        }

        return $this->render('UsokoSIGBundle:Subsidio:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Subsidio entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = CryptGeneral::decrypt($this, $id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Subsidio')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Subsidio entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "Subsidio", "D", "Remoção de Um Subsídio");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('subsidio'));
    }

    /**
     * Creates a form to delete a Subsidio entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = CryptGeneral::encrypt($this, $id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('subsidio_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    public function visaoConfirmarPagamentoSubsidioAction() {
        return $this->render('UsokoSIGBundle:Subsidio:Gestor/confirmarPagamentoSubsidio.html.twig');
    }

}
