<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\TipoCredito;
use Usoko\SIGBundle\Form\TipoCreditoType;
use Symfony\Component\HttpFoundation\JsonResponse;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\NumeroReal;

/**
 * TipoCredito controller.
 *
 */
class TipoCreditoController extends Controller {

    /**
     * Lists all TipoCredito entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:TipoCredito')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:TipoCredito:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new TipoCredito entity.
     *
     */
    public function createAction(Request $request) {

        $valorReal = $request->request->get('usoko_sigbundle_tipocredito')['valormaximo'];
        $valorReal = NumeroReal::converter($valorReal);

        $entity = new TipoCredito();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $entity->setValormaximo((double) $valorReal);
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "TipoCredito", "I", "Registo de Um Novo Tipo de Credito");

            return $this->redirect($this->generateUrl('tipocredito_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:TipoCredito:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a TipoCredito entity.
     *
     * @param TipoCredito $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(TipoCredito $entity) {
        $form = $this->createForm(new TipoCreditoType(), $entity, array(
            'action' => $this->generateUrl('tipocredito_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new TipoCredito entity.
     *
     */
    public function newAction() {
        $entity = new TipoCredito();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:TipoCredito:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a TipoCredito entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:TipoCredito')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find TipoCredito entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:TipoCredito:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing TipoCredito entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:TipoCredito')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find TipoCredito entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:TipoCredito:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a TipoCredito entity.
     *
     * @param TipoCredito $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(TipoCredito $entity) {
        $form = $this->createForm(new TipoCreditoType(), $entity, array(
            'action' => $this->generateUrl('tipocredito_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing TipoCredito entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);

        $entity = $em->getRepository('UsokoSIGBundle:TipoCredito')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find TipoCredito entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $entity->setValorMaximo((double) $this->valor($request));
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "TipoCredito", "U", "Actualização de Um Tipo de Credito");

            return $this->redirect($this->generateUrl('tipocredito_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:TipoCredito:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a TipoCredito entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:TipoCredito')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find TipoCredito entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "TipoCredito", "D", "Remoção de Um Tipo de Credito");

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('tipocredito'));
    }

    /**
     * Creates a form to delete a TipoCredito entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('tipocredito_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    public function ajaxLimiteReembolsoAction(Request $request) {

//        if (!$request->isXmlHttpRequest()) {
//            throw new NotFoundHttpException();
//        }

        $id = $request->query->get('tipocredito');
        $em = $this->getDoctrine()->getManager();
        $entity = new TipoCredito();
        $entity = $em->getRepository('UsokoSIGBundle:TipoCredito')->find($id);

        if (!$entity) {
            return new JsonResponse(0);
        }
        $result = array();
        $result = $entity->getLimitereembolso();

        return new JsonResponse($result);
    }

    private function valor($request) {
        $valorLimite = $request->request->get('usoko_sigbundle_tipocredito')['valormaximo'];
        $valorLimite = NumeroReal::converter($valorLimite);
        return $valorLimite;
    }

}
