<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Utilizador;
use Usoko\SIGBundle\Form\UtilizadorType;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\UploadGeneral;
use Usoko\SIGBundle\General\CryptGeneral;

/**
 * Utilizador controller.
 *
 */
class UtilizadorController extends Controller {

    /**
     * Lists all Utilizador entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
         
        $entities = $em->getRepository('UsokoSIGBundle:Utilizador')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Utilizador:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Utilizador entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Utilizador();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        // \Usoko\SIGBundle\General\Validacao::validar($this, $entity)
        if (\Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {

            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();

            $password = \Usoko\SIGBundle\General\CryptGeneral::cryptSenha($this, $entity);
            $entity->setPassword($password);

            // pessoa
            $entity->getPessoa()->setTipo(VarsGeneral::CONS_PESSOA_TIPO_UTILIZADOR);
            $temp_fotoPessoa = $entity->getPessoa()->getFoto();
            $entity->getPessoa()->setFoto(null);

            $em->persist($entity);
            $em->flush();

            // uploads
            if ($temp_fotoPessoa) {
                $file_name = md5($entity->getPessoa()->getId()) . VarsGeneral::CONS_UPLOAD_EXTENCTION;
                $answer = UploadGeneral::upload($temp_fotoPessoa, VarsGeneral::CONS_UPLOAD_USER, $file_name);
                $entity->getPessoa()->setFoto($file_name);
            }

            $em->flush();   // update 
            \Usoko\SIGBundle\General\AuditoriaGeneral::auditar($this, $em, $entity, "Utilizador", "I", "Registo de Um Novo Utilizador");
            $em->getConnection()->commit();
            //Fim da Operação
            return $this->redirect($this->generateUrl('utilizador_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Utilizador:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Utilizador entity.
     *
     * @param Utilizador $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Utilizador $entity) {
        $form = $this->createForm(new UtilizadorType(), $entity, array(
            'action' => $this->generateUrl('utilizador_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Utilizador entity.
     *
     */
    public function newAction() {
        $entity = new Utilizador();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Utilizador:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Utilizador entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
         $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Utilizador')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Utilizador entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Utilizador:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Utilizador entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Utilizador')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Utilizador entity.');
        }

        //$entity = new Utilizador();
        $entity->getPessoa()->setFoto(null);

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Utilizador:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Utilizador entity.
     *
     * @param Utilizador $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Utilizador $entity) {
        $form = $this->createForm(new UtilizadorType(), $entity, array(
            'action' => $this->generateUrl('utilizador_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Utilizador entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
         $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Utilizador')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Utilizador entity.');
        }
        $entity->getPessoa()->setFoto(null);
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        $password = \Usoko\SIGBundle\General\CryptGeneral::cryptSenha($this, $entity);
        $entity->setPassword($password);

        if ($editForm->isValid() && \Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {

            $em->getConnection()->beginTransaction();
            $em->flush();
            \Usoko\SIGBundle\General\AuditoriaGeneral::auditar($this, $em, $entity, "Utilizador", "U", "Actualização de Um Utilizador");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('utilizador_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Utilizador:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Utilizador entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Utilizador')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Utilizador entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Utilizador", "D", "Remoção de Um Utilizador");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('utilizador'));
    }

    /**
     * Creates a form to delete a Utilizador entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('utilizador_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    /**
     * Mostra o perfil do utilizador.
     *
     */
    public function perfilAction($id, $msg = 0) {
        $em = $this->getDoctrine()->getManager();
        $id = \Usoko\SIGBundle\General\CryptGeneral::decrypt($this, $id);
        $entity = $em->getRepository('UsokoSIGBundle:Utilizador')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Utilizador entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Utilizador:perfil.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
                    'msg' => $msg
        ));
    }

    public function senhaAction(Request $request, $id) {

        $senha_nova = $request->request->get('senha_nova');
        $conf_senha_nova = $request->request->get('conf_senha_nova');

        if ($senha_nova == $conf_senha_nova) {
            $idR = $id;
            $id = CryptGeneral::decrypt($this, $id);
            $em = $this->getDoctrine()->getManager();

            $entity = new Utilizador();
            $entity = $em->getRepository('UsokoSIGBundle:Utilizador')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Utilizador entity.');
            }

            $senha_antiga = $request->request->get('senha_antiga');
            $senha_antiga = CryptGeneral::cryptSenha($this, $entity, $senha_antiga);

            if ($entity->getPassword() == $senha_antiga) {
                $em->getConnection()->beginTransaction();
                $entity->setPassword(CryptGeneral::cryptSenha($this, $entity, $senha_nova));
                $em->persist($entity);
                $em->flush();

                \Usoko\SIGBundle\General\AuditoriaGeneral::auditar($this, $em, $entity, "Utilizador", "U", "Actualização Da Senha");
                $em->getConnection()->commit();
                $msg['msg'] = "Senha alterada com sucesso";
                $msg['class'] = "alert alert info";
                return $this->redirect($this->generateUrl('utilizador_perfil', array('id' => $idR, 'msg' => '5481')));
            }
            $msg['msg'] = "Senha Antiga Errada ";
            $msg['class'] = "alert alert danger";
            return $this->redirect($this->generateUrl('utilizador_perfil', array('id' => $idR, 'msg' => '4519')));
        }
        //
        return $this->redirect($this->generateUrl('utilizador_perfil', array('id' => $idR, 'msg' => '1593')));
    }

}
