<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BancoConta
 *
 * @ORM\Table(name="banco_conta", indexes={@ORM\Index(name="fk_Banco_Conta_Banco_Instituicao1_idx", columns={"Banco_Instituicao"})})
 * @ORM\Entity
 */
class BancoConta {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="iban", type="string", length=100, nullable=false)
     */
    private $iban;

    /**
     * @var string
     *
     * @ORM\Column(name="numero", type="string", length=45, nullable=false)
     */
    private $numero;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=1, nullable=true)
     */
    private $tipo = 'A';

    /**
     * @var \BancoInstituicao
     *
     * @ORM\ManyToOne(targetEntity="BancoInstituicao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Banco_Instituicao", referencedColumnName="id")
     * })
     */
    private $bancoInstituicao;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set iban
     *
     * @param string $iban
     * @return BancoConta
     */
    public function setIban($iban) {
        $this->iban = $iban;

        return $this;
    }

    /**
     * Get iban
     *
     * @return string 
     */
    public function getIban() {
        return $this->iban;
    }

    /**
     * Set numero
     *
     * @param string $numero
     * @return BancoConta
     */
    public function setNumero($numero) {
        $this->numero = $numero;

        return $this;
    }

    /**
     * Get numero
     *
     * @return string 
     */
    public function getNumero() {
        return $this->numero;
    }

    /**
     * Set bancoInstituicao
     *
     * @param \Usoko\SIGBundle\Entity\BancoInstituicao $bancoInstituicao
     * @return BancoConta
     */
    public function setBancoInstituicao(\Usoko\SIGBundle\Entity\BancoInstituicao $bancoInstituicao = null) {
        $this->bancoInstituicao = $bancoInstituicao;

        return $this;
    }

    /**
     * Get bancoInstituicao
     *
     * @return \Usoko\SIGBundle\Entity\BancoInstituicao 
     */
    public function getBancoInstituicao() {
        return $this->bancoInstituicao;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return BancoConta
     */
    public function setTipo($tipo) {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo() {
        return $this->tipo;
    }

    public function __toString() {
        return $this->getBancoInstituicao()->getSigla() . ' - ' . $this->getNumero();
    }

}
